/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Symbols;

public abstract class AbstractStargateModel {
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation EMPTY_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/empty.png");
    public static final String EMPTY = "sgjourney:empty";
    private static final int[] dialed9ChevronConfiguration = new int[]{0, 1, 2, 3, 7, 8, 4, 5, 6};
    private static final int[] dialed8ChevronConfiguration = new int[]{0, 1, 2, 3, 7, 4, 5, 6};
    protected static final float DEFAULT_ANGLE = 10.0f;
    protected static final float DEFAULT_DISTANCE_FROM_CENTER = 56.0f;
    protected static final int BOXES_PER_RING = 36;
    protected static final float CHEVRON_LIGHT_ANGLE = 15.0f;
    protected static final float CHEVRON_LIGHT_Z = 4.0f;
    protected static final float CHEVRON_LIGHT_Z_OFFSET = 0.5f;
    protected static final float CHEVRON_BACK_LIGHT_Z = 5.0f;
    protected static final float CHEVRON_LIGHT_TOP_X = 6.0f;
    protected static final float CHEVRON_LIGHT_TOP_Y = 1.0f;
    protected static final float CHEVRON_LIGHT_CENTER_X = 3.0f;
    protected static final float CHEVRON_LIGHT_CENTER_Y = 6.0f;
    protected static final float CHEVRON_LIGHT_SIDE_X = 2.0f;
    protected static final float CHEVRON_LIGHT_SIDE_Y = 6.1847f;
    protected static final float OUTER_CHEVRON_ANGLE = 22.5f;
    protected static final float OUTER_CHEVRON_Z_OFFSET = 3.5f;
    protected static final float OUTER_CHEVRON_CENTER_X = 4.0f;
    protected static final float OUTER_CHEVRON_CENTER_Y = 2.0f;
    protected static final float OUTER_CHEVRON_CENTER_Z = 1.0f;
    protected static final float OUTER_CHEVRON_SIDE_X = 2.0f;
    protected static final float OUTER_CHEVRON_SIDE_Y = 10.0f;
    protected static final float OUTER_CHEVRON_SIDE_Z = 1.0f;
    protected static final float OUTER_CHEVRON_Y_OFFSET = 10.0f;
    protected static final float OUTER_RING_X = 10.0f;
    protected static final float OUTER_RING_Y = 7.0f;
    protected static final float OUTER_RING_Z = 7.0f;
    protected static final float OUTER_RING_X_CENTER = 5.0f;
    protected static final float OUTER_RING_Z_CENTER = 3.5f;
    protected static final float BACK_RING_X = 9.0f;
    protected static final float BACK_RING_Y = 6.0f;
    protected static final float BACK_RING_Z = 4.0f;
    protected static final float BACK_RING_Z_OFFSET = 3.5f;
    protected static final float BACK_RING_X_CENTER = 4.5f;
    protected static final float INNER_RING_X = 8.0f;
    protected static final float INNER_RING_Y = 3.0f;
    protected static final float INNER_RING_Z = 7.0f;
    protected static final float SYMBOL_RING_X = 8.0f;
    protected static final float SYMBOL_RING_Y = 8.0f;
    protected static final float SYMBOL_RING_Z = 2.0f;
    protected static final float SYMBOL_RING_Y_OFFSET = 6.0f;
    protected static final float SYMBOL_RING_Z_OFFSET = 0.5f;
    protected static final float DIVIDER_X = 1.0f;
    protected ResourceLocation CHEVRON_TEXTURE;
    protected ResourceLocation ENGAGED_CHEVRON_TEXTURE;
    protected ResourceLocation CHEVRON_FRONT_TEXTURE;
    protected ResourceLocation ENGAGED_CHEVRON_FRONT_TEXTURE;
    protected String stargateName;

    public AbstractStargateModel(String stargateName) {
        this.stargateName = stargateName;
        this.CHEVRON_TEXTURE = this.getChevronTexture(true, false);
        this.ENGAGED_CHEVRON_TEXTURE = this.getChevronTexture(true, true);
        this.CHEVRON_FRONT_TEXTURE = this.getChevronTexture(false, false);
        this.ENGAGED_CHEVRON_FRONT_TEXTURE = this.getChevronTexture(false, true);
    }

    protected ResourceLocation getSymbolTexture(AbstractStargateEntity stargate, int symbol) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry symbolRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        if (symbol > 0) {
            String symbols = stargate.getSymbols();
            if (this.isLocationValid(symbols) && symbolRegistry.m_7804_(new ResourceLocation(symbols))) {
                return ((Symbols)symbolRegistry.m_7745_(new ResourceLocation(symbols))).texture(symbol - 1);
            }
            if (symbols.equals(EMPTY)) {
                return EMPTY_LOCATION;
            }
            return ERROR_LOCATION;
        }
        String pointOfOrigin = stargate.getPointOfOrigin();
        if (this.isLocationValid(pointOfOrigin) && pointOfOriginRegistry.m_7804_(new ResourceLocation(pointOfOrigin))) {
            return ((PointOfOrigin)pointOfOriginRegistry.m_7745_(new ResourceLocation(pointOfOrigin))).texture();
        }
        if (pointOfOrigin.equals(EMPTY)) {
            return EMPTY_LOCATION;
        }
        return ERROR_LOCATION;
    }

    public static int getChevronConfiguration(boolean defaultOrder, int addresslength, int chevron) {
        int[] configuration;
        if (defaultOrder) {
            return chevron;
        }
        switch (addresslength) {
            case 7: {
                configuration = dialed8ChevronConfiguration;
                break;
            }
            case 8: {
                configuration = dialed9ChevronConfiguration;
                break;
            }
            default: {
                return chevron;
            }
        }
        if (chevron >= configuration.length) {
            return 0;
        }
        int returned = configuration[chevron];
        System.out.println(returned);
        return returned;
    }

    protected ResourceLocation getChevronTexture(boolean lightsUp, boolean engaged) {
        String chevron = lightsUp ? this.stargateName + "_chevron" : this.stargateName + "_chevron_front";
        String path = "textures/entity/stargate/" + this.stargateName + "/";
        String suffix = engaged ? "_lit.png" : ".png";
        return new ResourceLocation("sgjourney", path + chevron + suffix);
    }

    private boolean isLocationValid(String location) {
        String[] split = location.split(":");
        if (split.length > 2) {
            return false;
        }
        if (!ResourceLocation.m_135843_((String)split[0])) {
            return false;
        }
        return ResourceLocation.m_135841_((String)split[1]);
    }

    public static void createChevron(PartDefinition chevron) {
        PartDefinition chevronLight = chevron.m_171599_("chevron_light", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        AbstractStargateModel.createChevronLight(chevronLight);
        PartDefinition outerChevron = chevron.m_171599_("outer_chevron", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        AbstractStargateModel.createOuterChevron(outerChevron);
        PartDefinition backChevron = chevron.m_171599_("back_chevron", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        AbstractStargateModel.createBackChevron(backChevron);
    }

    public static void createChevronLight(PartDefinition chevronLight) {
        chevronLight.m_171599_("chevron_top", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(-3.0f, 0.0f, 0.5f, 6.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)56.0f, (float)0.0f));
        chevronLight.m_171599_("chevron_center", CubeListBuilder.m_171558_().m_171514_(22, 5).m_171481_(-1.5f, 0.0f, 0.5f, 3.0f, 6.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)50.0f, (float)0.0f));
        chevronLight.m_171599_("chevron_right", CubeListBuilder.m_171558_().m_171514_(22, 15).m_171481_(-2.0f, -6.1847f, 0.5f, 2.0f, 6.1847f, 4.0f), PartPose.m_171423_((float)3.0f, (float)56.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-15.0))));
        chevronLight.m_171599_("chevron_left", CubeListBuilder.m_171558_().m_171514_(22, 15).m_171481_(0.0f, -6.1847f, 0.5f, 2.0f, 6.1847f, 4.0f), PartPose.m_171423_((float)-3.0f, (float)56.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(15.0))));
    }

    public static void createOuterChevron(PartDefinition outerChevron) {
        outerChevron.m_171599_("chevron_f", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-2.0f, 0.0f, 3.5f, 4.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)46.0f, (float)0.0f));
        outerChevron.m_171599_("chevron_right_f", CubeListBuilder.m_171558_().m_171514_(10, 29).m_171481_(-2.0f, 0.0f, 3.5f, 2.0f, 10.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)46.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-22.5))));
        outerChevron.m_171599_("chevron_left_f", CubeListBuilder.m_171558_().m_171514_(10, 29).m_171481_(0.0f, 0.0f, 3.5f, 2.0f, 10.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)46.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5))));
    }

    public static void createBackChevron(PartDefinition backChevron) {
        backChevron.m_171599_("chevron_b", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(-2.0f, 0.0f, -4.5f, 4.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)46.0f, (float)0.0f));
        backChevron.m_171599_("chevron_right_b", CubeListBuilder.m_171558_().m_171514_(10, 40).m_171481_(-2.0f, 0.0f, -4.5f, 2.0f, 10.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)46.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-22.5))));
        backChevron.m_171599_("chevron_left_b", CubeListBuilder.m_171558_().m_171514_(10, 40).m_171481_(0.0f, 0.0f, -4.5f, 2.0f, 10.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)46.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5))));
        backChevron.m_171599_("chevron_b_top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 0.0f, 0.5f, 6.0f, 1.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)56.0f, (float)-5.0f));
        backChevron.m_171599_("chevron_b_center", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.5f, 0.0f, 0.5f, 3.0f, 6.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)50.0f, (float)-5.0f));
        backChevron.m_171599_("chevron_b_right", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-2.0f, -6.1847f, -4.5f, 2.0f, 6.1847f, 5.0f), PartPose.m_171423_((float)3.0f, (float)56.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-15.0))));
        backChevron.m_171599_("chevron_b_left", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(0.0f, -6.1847f, -4.5f, 2.0f, 6.1847f, 5.0f), PartPose.m_171423_((float)-3.0f, (float)56.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(15.0))));
    }

    public static void createOuterRing(PartDefinition outerRing) {
        for (int i = 0; i < 9; ++i) {
            outerRing.m_171599_("outer_ring_" + 4 * i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -56.0f, -3.5f, 10.0f, 7.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0f * (float)i))));
            outerRing.m_171599_("outer_ring_" + (4 * i + 1), CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(-5.0f, -56.0f, -3.5f, 10.0f, 7.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 1)))));
            outerRing.m_171599_("outer_ring_" + (4 * i + 2), CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(-5.0f, -56.0f, -3.5f, 10.0f, 7.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 2)))));
            outerRing.m_171599_("outer_ring_" + (4 * i + 3), CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-5.0f, -56.0f, -3.5f, 10.0f, 7.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 3)))));
        }
    }

    public static void createBackRing(PartDefinition backRing) {
        for (int i = 0; i < 9; ++i) {
            backRing.m_171599_("back_ring_" + 4 * i, CubeListBuilder.m_171558_().m_171514_(34, -2).m_171481_(-4.5f, -49.0f, -3.5f, 9.0f, 6.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-40.0f * (float)i))));
            backRing.m_171599_("back_ring_" + (4 * i + 1), CubeListBuilder.m_171558_().m_171514_(34, 6).m_171481_(-4.5f, -49.0f, -3.5f, 9.0f, 6.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 1)))));
            backRing.m_171599_("back_ring_" + (4 * i + 2), CubeListBuilder.m_171558_().m_171514_(34, 14).m_171481_(-4.5f, -49.0f, -3.5f, 9.0f, 6.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 2)))));
            backRing.m_171599_("back_ring_" + (4 * i + 3), CubeListBuilder.m_171558_().m_171514_(34, 6).m_171481_(-4.5f, -49.0f, -3.5f, 9.0f, 6.0f, 4.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)(4 * i + 3)))));
        }
    }

    public static void createInnerRing(PartDefinition innerRing) {
        for (int i = 0; i < 36; ++i) {
            innerRing.m_171599_("inner_ring_" + i, CubeListBuilder.m_171558_().m_171514_(34, 24).m_171481_(-4.0f, -43.0f, -3.5f, 8.0f, 3.0f, 7.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-10.0f * (float)i))));
        }
    }

    public static void createRing(PartDefinition ring) {
        PartDefinition outerRing = ring.m_171599_("outer_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        AbstractStargateModel.createOuterRing(outerRing);
        PartDefinition backRing = ring.m_171599_("back_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        AbstractStargateModel.createBackRing(backRing);
        PartDefinition innerRing = ring.m_171599_("inner_ring", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        AbstractStargateModel.createInnerRing(innerRing);
    }

    public static void createSymbolRing(PartDefinition symbolRing, int symbolCount) {
        double angle = 360.0 / (double)symbolCount;
        for (int i = 0; i < symbolCount; ++i) {
            symbolRing.m_171599_("symbol_" + i, CubeListBuilder.m_171558_().m_171514_(-4, 6).m_171481_(-4.0f, -50.0f, 0.5f, 8.0f, 8.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(180.0 - angle * (double)i))));
        }
    }

    public static void createDividers(PartDefinition dividers, int symbolCount) {
        double angle = 360.0 / (double)symbolCount;
        for (int i = 0; i < symbolCount; ++i) {
            dividers.m_171599_("divider_" + i, CubeListBuilder.m_171558_().m_171514_(34, 34).m_171481_(-0.5f, -50.0f, 0.5f, 1.0f, 8.0f, 2.5f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(180.0 - (angle / 2.0 + angle * (double)i)))));
        }
    }
}

