/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.models.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ClassicStargateModel
extends AbstractStargateModel {
    private static final ResourceLocation STARGATE_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/classic/classic_stargate.png");
    private static final ResourceLocation ENGAGED_STARGATE_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/classic/classic_stargate_lit.png");
    protected static final float DEFAULT_DISTANCE = 3.5f;
    protected static final int DEFAULT_SIDES = 36;
    protected static final int SPINNING_SIDES = 39;
    private static final float ANGLE = 9.230769f;
    protected static final float STARGATE_RING_THICKNESS = 8.0f;
    protected static final float STARGATE_RING_OFFSET = 0.25f;
    protected static final float SPINNY_RING_THICKNESS = 7.0f;
    protected static final float SPINNY_RING_OFFSET = 0.21875f;
    protected static final float SYMBOL_OFFSET = 0.21975f;
    protected static final float LOCKED_CHEVRON_OFFSET = 0.25f;
    protected static final float CHEVRON_LIGHT_THICKNESS = 0.125f;
    protected static final float CHEVRON_LIGHT_UPPER_WIDTH = 0.4375f;
    protected static final float CHEVRON_LIGHT_LOWER_WIDTH = 0.125f;
    protected static final float CHEVRON_LIGHT_HEIGHT = 0.375f;
    protected static final float CHEVRON_LIGHT_Z_OFFSET = 0.375f;
    protected static final float CHEVRON_LIGHT_UPPER_X_OFFSET = 0.21875f;
    protected static final float CHEVRON_LIGHT_LOWER_X_OFFSET = 0.0625f;
    protected static final float CHEVRON_LIGHT_HEIGHT_Y_OFFSET = 0.1875f;
    protected static final float OUTER_CHEVRON_THICKNESS = 0.1875f;
    protected static final float OUTER_CHEVRON_BOTTOM_WIDTH = 0.375f;
    protected static final float OUTER_CHEVRON_BOTTOM_HEIGHT = 0.1875f;
    protected static final float OUTER_CHEVRON_SIDE_HEIGHT = 0.5625f;
    protected static final float SIN_25_5 = (float)Math.sin(Math.toRadians(22.5));
    protected static final float COS_25_5 = (float)Math.cos(Math.toRadians(22.5));
    protected static final float OUTER_CHEVRON_ANGLE = (float)Math.atan(3.0);
    protected static final float OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION = SIN_25_5 * 0.5625f;
    protected static final float OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION = COS_25_5 * 0.5625f;
    protected static final float OUTER_CHEVRON_SIDE_WIDTH = 0.1875f;
    protected static final float OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION = COS_25_5 * 0.1875f;
    protected static final float OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION = SIN_25_5 * 0.1875f;
    protected static final float OUTER_CHEVRON_Z_OFFSET = 0.40625f;
    protected static final float OUTER_CHEVRON_BOTTOM_X_OFFSET = 0.1875f;
    protected static final float OUTER_CHEVRON_BOTTOM_Y_OFFSET = 0.09375f;
    protected static final float[] stargateRingOuter = SGJourneyModel.shrinkingCoordinates(36, 3.5f, 3.5f);
    protected static final float[] stargateRingInner = SGJourneyModel.shrinkingCoordinates(36, 3.0f, 3.5f);
    protected static final float[] spinnyRingOuter = SGJourneyModel.shrinkingCoordinates(39, 3.05f, 3.5f);
    protected static final float[] spinnyRingInner = SGJourneyModel.shrinkingCoordinates(39, 2.5f, 3.5f);
    protected static final float STARGATE_RING_OUTER_LENGTH = Math.abs(stargateRingOuter[0] * 16.0f - stargateRingOuter[2] * 16.0f);
    protected static final float STARGATE_RING_INNER_LENGTH = Math.abs(stargateRingInner[0] * 16.0f - stargateRingInner[2] * 16.0f);
    protected static final float STARGATE_RING_HEIGHT = Math.abs(stargateRingOuter[1] * 16.0f - stargateRingInner[1] * 16.0f);
    protected static final float SPINNY_RING_OUTER_LENGTH = Math.abs(spinnyRingOuter[0] * 16.0f - spinnyRingOuter[2] * 16.0f);
    protected static final float SPINNY_RING_INNER_LENGTH = Math.abs(spinnyRingInner[0] * 16.0f - spinnyRingInner[2] * 16.0f);
    protected static final float SPINNY_RING_HEIGHT = Math.abs(spinnyRingOuter[1] * 16.0f - spinnyRingInner[1] * 16.0f);
    private float rotation = 0.0f;

    public ClassicStargateModel() {
        super("classic");
    }

    public void renderStargate(ClassicStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(STARGATE_TEXTURE));
        this.renderOuterRing(stack, consumer, source, combinedLight);
        this.renderSpinnyRing(stargate, stack, consumer, source, combinedLight);
        this.renderChevrons(stargate, stack, source, combinedLight, stargate.chevronsRendered());
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    protected void renderOuterRing(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        for (int j = 0; j < 36; ++j) {
            stack.m_252781_(Axis.f_252403_.m_252977_(10.0f));
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, stargateRingOuter[0], stargateRingOuter[1], 0.25f, (5.0f - STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, (12.0f - STARGATE_RING_HEIGHT / 2.0f) / 64.0f, stargateRingInner[0], stargateRingInner[1], 0.25f, (5.0f - STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, (12.0f + STARGATE_RING_HEIGHT / 2.0f) / 64.0f, stargateRingInner[2], stargateRingInner[3], 0.25f, (5.0f + STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, (12.0f + STARGATE_RING_HEIGHT / 2.0f) / 64.0f, stargateRingOuter[2], stargateRingOuter[3], 0.25f, (5.0f + STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, (12.0f - STARGATE_RING_HEIGHT / 2.0f) / 64.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, stargateRingOuter[2], stargateRingOuter[3], -0.25f, (15.0f - STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, (12.0f - STARGATE_RING_HEIGHT / 2.0f) / 64.0f, stargateRingInner[2], stargateRingInner[3], -0.25f, (15.0f - STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, (12.0f + STARGATE_RING_HEIGHT / 2.0f) / 64.0f, stargateRingInner[0], stargateRingInner[1], -0.25f, (15.0f + STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, (12.0f + STARGATE_RING_HEIGHT / 2.0f) / 64.0f, stargateRingOuter[0], stargateRingOuter[1], -0.25f, (15.0f + STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, (12.0f - STARGATE_RING_HEIGHT / 2.0f) / 64.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, stargateRingOuter[0], stargateRingOuter[1], -0.25f, (5.0f - STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, 0.0f, stargateRingOuter[0], stargateRingOuter[1], 0.25f, (5.0f - STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, 0.125f, stargateRingOuter[2], stargateRingOuter[3], 0.25f, (5.0f + STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, 0.125f, stargateRingOuter[2], stargateRingOuter[3], -0.25f, (5.0f + STARGATE_RING_OUTER_LENGTH / 2.0f) / 64.0f, 0.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, stargateRingInner[2], stargateRingInner[3], -0.25f, (15.0f - STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.0f, stargateRingInner[2], stargateRingInner[3], 0.25f, (15.0f - STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.125f, stargateRingInner[0], stargateRingInner[1], 0.25f, (15.0f + STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.125f, stargateRingInner[0], stargateRingInner[1], -0.25f, (15.0f + STARGATE_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.0f);
        }
    }

    protected void renderSpinnyRing(ClassicStargateEntity stargate, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight) {
        int j;
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        for (j = 0; j < 39; ++j) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252403_.m_252977_(-9.230769f * (float)j + this.rotation));
            matrix4 = stack.m_85850_().m_252922_();
            matrix3 = stack.m_85850_().m_252943_();
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, spinnyRingOuter[0], spinnyRingOuter[1], 0.21875f, (24.5f - SPINNY_RING_OUTER_LENGTH / 2.0f) / 64.0f, (11.5f - SPINNY_RING_HEIGHT / 2.0f) / 64.0f, spinnyRingInner[0], spinnyRingInner[1], 0.21875f, (24.5f - SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, (11.5f + SPINNY_RING_HEIGHT / 2.0f) / 64.0f, spinnyRingInner[2], spinnyRingInner[3], 0.21875f, (24.5f + SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, (11.5f + SPINNY_RING_HEIGHT / 2.0f) / 64.0f, spinnyRingOuter[2], spinnyRingOuter[3], 0.21875f, (24.5f + SPINNY_RING_OUTER_LENGTH / 2.0f) / 64.0f, (11.5f - SPINNY_RING_HEIGHT / 2.0f) / 64.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, spinnyRingOuter[2], spinnyRingOuter[3], -0.21875f, (33.5f - SPINNY_RING_OUTER_LENGTH / 2.0f) / 64.0f, (11.5f - SPINNY_RING_HEIGHT / 2.0f) / 64.0f, spinnyRingInner[2], spinnyRingInner[3], -0.21875f, (33.5f - SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, (11.5f + SPINNY_RING_HEIGHT / 2.0f) / 64.0f, spinnyRingInner[0], spinnyRingInner[1], -0.21875f, (33.5f + SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, (11.5f + SPINNY_RING_HEIGHT / 2.0f) / 64.0f, spinnyRingOuter[0], spinnyRingOuter[1], -0.21875f, (33.5f + SPINNY_RING_OUTER_LENGTH / 2.0f) / 64.0f, (11.5f - SPINNY_RING_HEIGHT / 2.0f) / 64.0f);
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, spinnyRingInner[0], spinnyRingInner[1], 0.21875f, (23.5f - SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.0f, spinnyRingInner[0], spinnyRingInner[1], -0.21875f, (23.5f - SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.109375f, spinnyRingInner[2], spinnyRingInner[3], -0.21875f, (23.5f + SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.109375f, spinnyRingInner[2], spinnyRingInner[3], 0.21875f, (23.5f + SPINNY_RING_INNER_LENGTH / 2.0f) / 64.0f, 0.0f);
            stack.m_85849_();
        }
        for (j = 0; j < 39; ++j) {
            stack.m_85836_();
            stack.m_252781_(Axis.f_252403_.m_252977_((float)j * -9.230769f + this.rotation));
            matrix4 = stack.m_85850_().m_252922_();
            matrix3 = stack.m_85850_().m_252943_();
            VertexConsumer symbolConsumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getSymbolTexture(stargate, j)));
            SGJourneyModel.createQuad(symbolConsumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, 0.0f, 0.42745098f, 0.4745098f, 1.0f, -0.25f, spinnyRingInner[1] + 0.5625f, 0.21975f, 0.0f, 0.0f, -0.25f, spinnyRingInner[1], 0.21975f, 0.0f, 1.0f, 0.25f, spinnyRingInner[3], 0.21975f, 1.0f, 1.0f, 0.25f, spinnyRingInner[3] + 0.5625f, 0.21975f, 1.0f, 0.0f);
            stack.m_85849_();
        }
    }

    protected void renderChevrons(ClassicStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int chevronsActive) {
        this.renderPrimaryChevron(stargate, stack, source, combinedLight);
        for (int i = 1; i < 9; ++i) {
            this.renderChevron(stargate, stack, source, combinedLight, i, i <= chevronsActive);
        }
    }

    protected void renderPrimaryChevron(ClassicStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight) {
        boolean isLocked = stargate.isConnected() && (stargate.isDialingOut() || stargate.getKawooshTickCount() > 0);
        float subtracted = isLocked ? 0.3125f : 0.0625f;
        stack.m_85836_();
        stack.m_252880_(0.0f, 3.5f - subtracted, 0.0f);
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(STARGATE_TEXTURE));
        this.renderChevronLight(stack, consumer, source, combinedLight, isLocked);
        this.renderOuterChevron(stack, consumer, source, combinedLight, isLocked);
        if (isLocked) {
            consumer = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ENGAGED_STARGATE_TEXTURE));
            this.renderChevronLight(stack, consumer, source, 0xF000E0, isLocked);
            this.renderOuterChevron(stack, consumer, source, 0xF000E0, isLocked);
        }
        stack.m_85849_();
    }

    protected void renderChevron(ClassicStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int chevronNumber, boolean isEngaged) {
        int chevron = stargate.getEngagedChevrons()[chevronNumber];
        float subtracted = isEngaged ? 0.3125f : 0.0625f;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252403_.m_252977_((float)(-40 * chevron)));
        stack.m_252880_(0.0f, 3.5f - subtracted, 0.0f);
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(STARGATE_TEXTURE));
        this.renderChevronLight(stack, consumer, source, combinedLight, isEngaged);
        this.renderOuterChevron(stack, consumer, source, combinedLight, isEngaged);
        if (isEngaged) {
            consumer = source.m_6299_(SGJourneyRenderTypes.stargateChevron(ENGAGED_STARGATE_TEXTURE));
            this.renderChevronLight(stack, consumer, source, 0xF000E0, isEngaged);
            this.renderOuterChevron(stack, consumer, source, 0xF000E0, isEngaged);
        }
        stack.m_85849_();
    }

    protected void renderChevronLight(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean isLocked) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.21875f, 0.1875f, 0.375f, 0.5f, 0.328125f, -0.0625f, -0.1875f, 0.375f, 0.53125f, 0.40625f, 0.0625f, -0.1875f, 0.375f, 0.5625f, 0.40625f, 0.21875f, 0.1875f, 0.375f, 0.59375f, 0.328125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.21875f, 0.1875f, 0.25f, 0.5f, 0.296875f, -0.21875f, 0.1875f, 0.375f, 0.5f, 0.328125f, 0.21875f, 0.1875f, 0.375f, 0.59375f, 0.328125f, 0.21875f, 0.1875f, 0.25f, 0.59375f, 0.296875f);
        if (!isLocked) {
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, 0.21875f, 0.1875f, 0.25f, 0.59375f, 0.296875f, 0.21875f, 0.0f, 0.25f, 0.59375f, 0.25f, -0.21875f, 0.0f, 0.25f, 0.5f, 0.25f, -0.21875f, 0.1875f, 0.25f, 0.5f, 0.296875f);
        }
    }

    protected void renderOuterChevron(PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, boolean isLocked) {
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.0625f, -0.1875f, 0.40625f, 0.203125f, 0.2578125f, 0.0625f, -0.1875f, 0.40625f, 0.203125f, 0.265625f, 0.0625f, -0.1875f, 0.375f, 0.234375f, 0.265625f, -0.0625f, -0.1875f, 0.375f, 0.234375f, 0.2578125f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.0625f, -0.1875f, 0.40625f, 0.203125f, 0.265625f, -0.1875f, -0.375f, 0.40625f, 0.1875f, 0.3125f, 0.1875f, -0.375f, 0.40625f, 0.25f, 0.3125f, 0.0625f, -0.1875f, 0.40625f, 0.234375f, 0.265625f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, -1.0f, 0.0f, -0.1875f, -0.375f, 0.40625f, 0.1875f, 0.3125f, -0.1875f, -0.375f, 0.21875f, 0.1875f, 0.359375f, 0.1875f, -0.375f, 0.21875f, 0.25f, 0.359375f, 0.1875f, -0.375f, 0.40625f, 0.25f, 0.3125f);
        this.renderLeftChevronSide(stack, source, consumer, matrix3.rotate((Quaternionfc)Axis.f_252403_.m_252977_(22.5f)), matrix4, combinedLight, isLocked);
        this.renderRightChevronSide(stack, source, consumer, matrix3.rotate((Quaternionfc)Axis.f_252403_.m_252977_(-22.5f)), matrix4, combinedLight, isLocked);
    }

    protected void renderLeftChevronSide(PoseStack stack, MultiBufferSource source, VertexConsumer consumer, Matrix3f matrix3, Matrix4f matrix4, int combinedLight, boolean isLocked) {
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.046875f, 0.296875f, -0.1875f, -0.375f, 0.40625f, 0.046875f, 0.4375f, -0.0625f, -0.1875f, 0.40625f, 0.09375f, 0.40625f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.09375f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 0.0f, 0.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.0f, 0.296875f, -0.1875f, -0.375f, 0.21875f, 0.0f, 0.4375f, -0.1875f, -0.375f, 0.40625f, 0.046875f, 0.4375f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.046875f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 0.0f, 0.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.09375f, 0.296875f, -0.0625f, -0.1875f, 0.40625f, 0.09375f, 0.40625f, -0.0625f, -0.1875f, 0.21875f, 0.140625f, 0.40625f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.140625f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.046875f, 0.25f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.046875f, 0.296875f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.09375f, 0.296875f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.09375f, 0.25f);
        if (!isLocked) {
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.140625f, 0.296875f, -0.0625f, -0.1875f, 0.21875f, 0.140625f, 0.40625f, -0.1875f, -0.375f, 0.21875f, 0.1875f, 0.4375f, -0.1875f - OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.1875f, 0.296875f);
        }
    }

    protected void renderRightChevronSide(PoseStack stack, MultiBufferSource source, VertexConsumer consumer, Matrix3f matrix3, Matrix4f matrix4, int combinedLight, boolean isLocked) {
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.296875f, 0.296875f, 0.0625f, -0.1875f, 0.40625f, 0.296875f, 0.40625f, 0.1875f, -0.375f, 0.40625f, 0.34375f, 0.4375f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.34375f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 1.0f, 0.0f, 0.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.34375f, 0.296875f, 0.1875f, -0.375f, 0.40625f, 0.34375f, 0.4375f, 0.1875f, -0.375f, 0.21875f, 0.390625f, 0.4375f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.390625f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, -1.0f, 0.0f, 0.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.25f, 0.296875f, 0.0625f, -0.1875f, 0.21875f, 0.25f, 0.40625f, 0.0625f, -0.1875f, 0.40625f, 0.296875f, 0.40625f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.296875f, 0.296875f);
        SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 1.0f, 0.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.296875f, 0.25f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.40625f, 0.296875f, 0.296875f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.40625f, 0.34375f, 0.296875f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.34375f, 0.25f);
        if (!isLocked) {
            SGJourneyModel.createQuad(consumer, matrix4, matrix3, combinedLight, 0.0f, 0.0f, 1.0f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION, 0.21875f, 0.390625f, 0.296875f, 0.1875f, -0.375f, 0.21875f, 0.390625f, 0.4375f, 0.0625f, -0.1875f, 0.21875f, 0.4375f, 0.40625f, 0.1875f + OUTER_CHEVRON_SIDE_HEIGHT_X_PROJECTION - OUTER_CHEVRON_SIDE_WIDTH_X_PROJECTION, -0.375f + OUTER_CHEVRON_SIDE_HEIGHT_Y_PROJECTION + OUTER_CHEVRON_SIDE_WIDTH_Y_PROJECTION, 0.21875f, 0.4375f, 0.296875f);
        }
    }
}

