/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.SGJourneyConfigValue;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WormholeModel {
    private static final ResourceLocation EVENT_HORIZON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/event_horizon/event_horizon_idle.png");
    protected static final float DEFAULT_DISTANCE = 3.5f;
    protected static final int DEFAULT_SIDES = 36;
    protected static final float SHIELDING_OFFSET = 0.03125f;
    protected SGJourneyConfigValue.RGBAValue rgbaValue;
    protected float maxDefaultDistortion;
    protected float scale = 0.03125f;
    protected float[][] outerCircle = WormholeModel.coordinates(36, 2.5f, 5.0f, 0);
    protected float[][] circle1 = WormholeModel.coordinates(36, 2.0f, 0.0f, 98);
    protected float[][] circle2 = WormholeModel.coordinates(36, 1.5f, -5.0f, 67);
    protected float[][] circle3 = WormholeModel.coordinates(36, 1.0f, -10.0f, 567);
    protected float[][] circle4 = WormholeModel.coordinates(36, 0.5f, -15.0f, 257);
    protected float[][] circle5 = WormholeModel.coordinates(36, 0.0f, 0.0f, -2);
    protected float[][][] coordinates = new float[][][]{this.outerCircle, this.circle1, this.circle2, this.circle3, this.circle4, this.circle5};

    public WormholeModel(SGJourneyConfigValue.RGBAValue rgbaValue, float maxDefaultDistortion) {
        this.rgbaValue = rgbaValue;
        this.maxDefaultDistortion = maxDefaultDistortion;
    }

    public void renderEventHorizon(AbstractStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        this.renderKawoosh(stack, source, (float)stargate.getTickCount() * this.scale, stargate.getKawooshTickCount(), false);
        this.renderPuddle(stack, source, (float)stargate.getTickCount() * this.scale, stargate.getKawooshTickCount(), false);
        if (ClientStargateConfig.enable_vortex.get()) {
            this.renderVortex(stack, source, (float)stargate.getTickCount() * this.scale, stargate.getKawooshTickCount());
        }
    }

    protected void renderPuddle(PoseStack stack, MultiBufferSource source, float yOffset, int kawooshProgress, boolean isShieldOn) {
        if (kawooshProgress <= 0) {
            return;
        }
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        for (int i = 0; i < 5; ++i) {
            VertexConsumer frontConsumer = source.m_6299_(SGJourneyRenderTypes.eventHorizonFront(EVENT_HORIZON_TEXTURE, 0.0f, yOffset));
            int totalSides = this.coordinates[0].length;
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0));
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0));
            }
            VertexConsumer backConsumer = source.m_6299_(SGJourneyRenderTypes.eventHorizonBack(EVENT_HORIZON_TEXTURE, 0.0f, yOffset));
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(backConsumer, matrix4, matrix3, this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, 0));
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, 0));
            }
        }
    }

    protected void renderKawoosh(PoseStack stack, MultiBufferSource source, float yOffset, int kawooshProgress, boolean isShieldOn) {
        if (kawooshProgress <= 0 || kawooshProgress >= 40) {
            return;
        }
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        VertexConsumer kawooshConsumer = source.m_6299_(SGJourneyRenderTypes.vortex(EVENT_HORIZON_TEXTURE, 0.0f, yOffset));
        int totalSides = this.coordinates[0].length;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(kawooshConsumer, matrix4, matrix3, WormholeModel.bubbleX(this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress));
                this.createTriangle(kawooshConsumer, matrix4, matrix3, WormholeModel.bubbleX(this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isShieldOn, this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress));
            }
        }
    }

    protected void renderVortex(PoseStack stack, MultiBufferSource source, float yOffset, int kawooshProgress) {
        if (kawooshProgress <= 40) {
            return;
        }
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        VertexConsumer vortexConsumer = source.m_6299_(SGJourneyRenderTypes.vortex(EVENT_HORIZON_TEXTURE, yOffset, yOffset));
        int totalSides = this.coordinates[0].length;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(vortexConsumer, matrix4, matrix3, this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.vortexMaker(this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.vortexMaker(this.maxDefaultDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, kawooshProgress));
                this.createTriangle(vortexConsumer, matrix4, matrix3, this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(this.maxDefaultDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.vortexMaker(this.maxDefaultDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(this.maxDefaultDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress));
            }
        }
    }

    protected static float[][] coordinates(int sides, float distanceFromCenter, float offset, int seed) {
        float defaultOffset;
        Random random = new Random(seed);
        float angle = 360.0f / (float)sides;
        float[][] coordinates = new float[sides][3];
        float baseWidth = 0.6125f;
        float ratio = distanceFromCenter / 3.5f;
        float usedWidth = baseWidth * ratio;
        float circumcircleRadius = SGJourneyModel.circumcircleRadius(angle, usedWidth);
        float f = defaultOffset = seed == 0 ? 0.0f : random.nextFloat() - 0.5f;
        if (distanceFromCenter >= 0.0f) {
            for (int i = 0; i < sides; ++i) {
                coordinates[i][0] = CoordinateHelper.polarToCartesianY(circumcircleRadius, angle * (float)i - offset);
                coordinates[i][1] = CoordinateHelper.polarToCartesianX(circumcircleRadius, angle * (float)i - offset);
                coordinates[i][2] = seed <= 0 ? defaultOffset : 2.0f * random.nextFloat() - 1.0f;
            }
        } else {
            coordinates[0][0] = 0.0f;
            coordinates[0][1] = 0.0f;
            coordinates[0][2] = defaultOffset;
        }
        return coordinates;
    }

    protected static float bubbleX(float x, float y, int multiplier, int progress) {
        float r = CoordinateHelper.cartesianToPolarR(x, y);
        float phi = CoordinateHelper.cartesianToPolarPhi(x, y);
        r = (float)((double)r * (1.0 + 0.4 * (double)((float)(Math.pow(Math.sin((double)multiplier / 3.0), 4.0) * AbstractStargateEntity.kawooshFunction(progress)))));
        return CoordinateHelper.polarToCartesianX(r, phi);
    }

    protected static float bubbleY(float x, float y, int multiplier, int progress) {
        float r = CoordinateHelper.cartesianToPolarR(x, y);
        float phi = CoordinateHelper.cartesianToPolarPhi(x, y);
        r = (float)((double)r * (1.0 + 0.4 * (double)((float)(Math.pow(Math.sin((double)multiplier / 3.0), 4.0) * AbstractStargateEntity.kawooshFunction(progress)))));
        return CoordinateHelper.polarToCartesianY(r, phi);
    }

    protected static float distortionMaker(boolean shielded, float maxDefaultDistortion, float defaultOffset, float distortionOffset, int multiplier, int progress) {
        float defaultDistortion = ClientStargateConfig.flat_event_horizon.get() ? 0.0f : (float)Math.sin((defaultOffset *= maxDefaultDistortion) * distortionOffset * 8.0f) * maxDefaultDistortion;
        float gradualKawoosh = (float)Math.pow(Math.sin((double)multiplier / 4.0), 2.0);
        float kawooshDistortion = (float)(1.2 * AbstractStargateEntity.kawooshFunction(progress)) * gradualKawoosh;
        float totalDistortion = defaultDistortion + kawooshDistortion;
        if (shielded && totalDistortion > 0.03125f) {
            totalDistortion = 0.03025f;
        }
        return totalDistortion < -maxDefaultDistortion ? -maxDefaultDistortion : totalDistortion;
    }

    protected static float vortexMaker(float maxDefaultDistortion, float defaultOffset, float distortionOffset, int multiplier, int progress) {
        float defaultDistortion = ClientStargateConfig.flat_event_horizon.get() ? 0.0f : (float)Math.sin((defaultOffset *= maxDefaultDistortion) * distortionOffset * 8.0f) * maxDefaultDistortion;
        float actualDistortion = defaultDistortion * (1.0f + (float)(Math.pow(Math.sin((double)multiplier / 5.0), 4.0) * AbstractStargateEntity.kawooshFunction(progress)));
        float gradualKawoosh = (float)Math.pow(Math.sin((double)multiplier / 5.0), 2.0);
        float kawooshDistortion = (float)(1.2 * AbstractStargateEntity.kawooshFunction(progress)) * gradualKawoosh;
        float totalDistortion = actualDistortion + kawooshDistortion;
        return totalDistortion;
    }

    protected void createTriangle(VertexConsumer consumer, Matrix4f matrix4, Matrix3f matrix3, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float red = (float)this.rgbaValue.getRed() / 255.0f;
        float blue = (float)this.rgbaValue.getBlue() / 255.0f;
        float green = (float)this.rgbaValue.getGreen() / 255.0f;
        float alpha = (float)this.rgbaValue.getAlpha() / 255.0f;
        consumer.m_252986_(matrix4, x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(x1 / 2.5f / 2.0f + 0.5f, y1 / 2.5f / 16.0f + 0.5f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(x2 / 2.5f / 2.0f + 0.5f, y2 / 2.5f / 16.0f + 0.5f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4, x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(x3 / 2.5f / 2.0f + 0.5f, y3 / 2.5f / 16.0f + 0.5f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

