/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.CartoucheEntity;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.misc.Orientation;
import net.povstalec.sgjourney.common.stargate.Symbols;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class CartoucheRenderer {
    private static final ResourceLocation ERROR = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    protected static final float MAX_WIDTH = 0.625f;
    protected static final float MAX_HEIGHT = 1.625f;
    protected static final float SYMBOL_OFFSET = 0.51f;
    protected int red;
    protected int green;
    protected int blue;

    public CartoucheRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected Symbols getSymbols(CartoucheEntity symbolBlock) {
        String symbols = symbolBlock.getSymbols();
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry registry = registries.m_175515_(Symbols.REGISTRY_KEY);
        if (symbols != null) {
            return (Symbols)registry.m_7745_(new ResourceLocation(symbols));
        }
        return (Symbols)registry.m_7745_(new ResourceLocation("sgjourney:universal"));
    }

    protected void renderSymbol(VertexConsumer consumer, Matrix4f matrix4, Matrix3f matrix3, int light, float size, float x, float y, float z) {
        float halfsize = size / 2.0f;
        consumer.m_252986_(matrix4, x - halfsize, y + halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4, x - halfsize, y - halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4, x + halfsize, y - halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4, x + halfsize, y + halfsize, z).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    protected void renderCartoucheBlock(CartoucheEntity cartouche, PoseStack stack, MultiBufferSource source, int light) {
        BlockState blockstate = cartouche.m_58900_();
        if (blockstate.m_61143_(CartoucheBlock.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        Direction direction = (Direction)blockstate.m_61143_((Property)CartoucheBlock.f_54117_);
        float facing = direction.m_122435_();
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_(CartoucheBlock.ORIENTATION));
        BlockPos pos = cartouche.m_58899_().m_121945_(Orientation.getEffectiveDirection(direction, orientation));
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        if (cartouche != null) {
            Matrix4f matrix4 = stack.m_85850_().m_252922_();
            Matrix3f matrix3 = stack.m_85850_().m_252943_();
            Symbols symbols = this.getSymbols(cartouche);
            light = LevelRenderer.m_109541_((BlockAndTintGetter)cartouche.m_58904_(), (BlockPos)pos);
            int[] address = cartouche.getAddress();
            if (address != null) {
                float symbolSize = 1.625f / (float)address.length;
                if (symbolSize > 0.625f) {
                    symbolSize = 0.625f;
                }
                for (int i = 0; i < address.length; ++i) {
                    ResourceLocation texture = symbols != null ? symbols.texture(address[i] - 1) : ERROR;
                    VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.symbol(texture));
                    float yStart = 0.5f + symbolSize * (float)address.length / 2.0f;
                    if (yStart > 1.3125f) {
                        yStart = 1.3125f;
                    }
                    float yPos = yStart - symbolSize / 2.0f - symbolSize * (float)i;
                    this.renderSymbol(consumer, matrix4, matrix3, light, symbolSize, 0.0f, yPos, 0.51f);
                }
            }
        }
        stack.m_85849_();
    }

    public static class Sandstone
    extends CartoucheRenderer
    implements BlockEntityRenderer<CartoucheEntity.Sandstone> {
        public Sandstone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 198;
            this.green = 174;
            this.blue = 113;
        }

        public void render(CartoucheEntity.Sandstone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderCartoucheBlock(symbol, stack, source, combinedLight);
        }
    }

    public static class Stone
    extends CartoucheRenderer
    implements BlockEntityRenderer<CartoucheEntity.Stone> {
        public Stone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 90;
            this.green = 89;
            this.blue = 90;
        }

        public void render(CartoucheEntity.Stone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderCartoucheBlock(symbol, stack, source, combinedLight);
        }
    }
}

