/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.level;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.client.render.level.SGJourneySkyRenderer;
import org.joml.Matrix4f;

public class LanteaSkyRenderer
extends SGJourneySkyRenderer {
    public LanteaSkyRenderer() {
        super(17892L, 2250);
    }

    protected void renderEcliptic(ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder, float rain) {
        stack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rain);
        stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        stack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTicks) * 360.0f));
        this.renderStars(level, partialTicks, rain, stack, projectionMatrix, setupFog);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f lastMatrix = stack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.createCelestialObject(bufferbuilder, lastMatrix, GALAXY_LOCATION, 0.6f, 100.0f, (float)Math.toRadians(-80.0), (float)Math.toRadians(120.0), new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        this.renderSun(bufferbuilder, lastMatrix, 30.0f);
        this.renderMoon(bufferbuilder, lastMatrix, 20.0f, level.m_46941_(), 0.0f, (float)Math.toRadians(180.0));
        stack.m_85849_();
    }

    @Override
    public void renderSky(ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        setupFog.run();
        if (this.isFoggy(camera)) {
            return;
        }
        Vec3 skyColor = level.m_171660_(this.minecraft.f_91063_.m_109153_().m_90583_(), partialTicks);
        float skyX = (float)skyColor.f_82479_;
        float skyY = (float)skyColor.f_82480_;
        float skyZ = (float)skyColor.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.renderSunrise(level, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float rain = 1.0f - level.m_46722_(partialTicks);
        this.renderEcliptic(level, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder, rain);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double height = this.minecraft.f_91074_.m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (height < 0.0) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 12.0f, 0.0f);
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            stack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }
}

