/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.client.sound.sounds.MilkyWayStargateRingBuildupSound;
import net.povstalec.sgjourney.client.sound.sounds.MilkyWayStargateRingSound;
import net.povstalec.sgjourney.client.sound.sounds.PegasusStargateRingSound;
import net.povstalec.sgjourney.client.sound.sounds.StargateSound;
import net.povstalec.sgjourney.client.sound.sounds.UniverseStargateRingSound;
import net.povstalec.sgjourney.client.sound.sounds.WormholeIdleSound;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;

public abstract class StargateSoundWrapper
extends SoundWrapper {
    protected static Minecraft minecraft = Minecraft.m_91087_();
    protected AbstractStargateEntity stargate;
    protected StargateSound sound;
    protected boolean playingSound = false;

    protected StargateSoundWrapper(AbstractStargateEntity stargate, StargateSound sound) {
        this.stargate = stargate;
        this.sound = sound;
    }

    @Override
    public boolean isPlaying() {
        return this.playingSound;
    }

    @Override
    public boolean hasSound() {
        return this.sound != null && !this.sound.m_7801_();
    }

    @Override
    public void playSound() {
        if (!this.playingSound) {
            minecraft.m_91106_().m_120372_((TickableSoundInstance)this.sound);
            this.playingSound = true;
        }
    }

    @Override
    public void stopSound() {
        if (this.playingSound) {
            this.sound.stopSound();
            this.playingSound = false;
        }
    }

    public static class PegasusRingRotation
    extends StargateSoundWrapper {
        public PegasusRingRotation(PegasusStargateEntity stargate) {
            super(stargate, new PegasusStargateRingSound(stargate));
        }

        @Override
        public void playSound() {
            this.sound = new PegasusStargateRingSound((PegasusStargateEntity)this.stargate);
            minecraft.m_91106_().m_120367_((SoundInstance)this.sound);
            this.playingSound = true;
        }

        @Override
        public void stopSound() {
            this.sound.stopSound();
            this.playingSound = false;
        }
    }

    public static class MilkyWayRingRotation
    extends StargateSoundWrapper {
        public MilkyWayRingRotation(MilkyWayStargateEntity stargate) {
            super(stargate, new MilkyWayStargateRingSound(stargate));
        }
    }

    public static class MilkyWayRingBuildup
    extends StargateSoundWrapper {
        public MilkyWayRingBuildup(MilkyWayStargateEntity stargate) {
            super(stargate, new MilkyWayStargateRingBuildupSound(stargate));
        }

        @Override
        public void playSound() {
            if (!this.playingSound) {
                this.sound = new MilkyWayStargateRingBuildupSound((MilkyWayStargateEntity)this.stargate);
                minecraft.m_91106_().m_120367_((SoundInstance)this.sound);
                this.playingSound = true;
            }
        }
    }

    public static class UniverseRingRotation
    extends StargateSoundWrapper {
        public UniverseRingRotation(UniverseStargateEntity stargate) {
            super(stargate, new UniverseStargateRingSound(stargate));
        }

        @Override
        public void playSound() {
            this.sound = new UniverseStargateRingSound((UniverseStargateEntity)this.stargate);
            minecraft.m_91106_().m_120367_((SoundInstance)this.sound);
            this.playingSound = true;
        }

        @Override
        public void stopSound() {
            this.sound.stopSound();
            this.playingSound = false;
        }
    }

    public static class WormholeIdle
    extends StargateSoundWrapper {
        public WormholeIdle(AbstractStargateEntity stargate) {
            super(stargate, new WormholeIdleSound(stargate));
        }
    }
}

