/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.blocks.BasicInterfaceBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.capabilities.CCTweakedCapabilities;
import net.povstalec.sgjourney.common.cctweaked.peripherals.BasicPeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.misc.Orientation;
import net.povstalec.sgjourney.common.packets.ClientboundBasicInterfaceUpdatePacket;
import net.povstalec.sgjourney.common.stargate.StargatePart;
import org.jetbrains.annotations.NotNull;

public class BasicInterfaceEntity
extends EnergyBlockEntity {
    private int desiredSymbol = 0;
    private int currentSymbol = 0;
    private boolean rotate = false;
    private boolean rotateClockwise = true;
    public EnergyBlockEntity energyBlockEntity = null;
    protected BasicPeripheralWrapper peripheralWrapper;

    public BasicInterfaceEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.BASIC_INTERFACE.get(), pos, state);
        if (ModList.get().isLoaded("computercraft")) {
            this.peripheralWrapper = new BasicPeripheralWrapper(this);
        }
    }

    protected BasicInterfaceEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58904_().m_8055_(pos);
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof BasicInterfaceBlock) {
            BasicInterfaceBlock ccInterface = (BasicInterfaceBlock)block;
            ccInterface.updateInterface(state, level, pos);
        }
        super.onLoad();
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ModList.get().isLoaded("computercraft") && cap == CCTweakedCapabilities.CAPABILITY_PERIPHERAL) {
            return this.peripheralWrapper.newPeripheral().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean updateInterface(Level level, BlockPos pos, Block block, BlockState state) {
        if (this.peripheralWrapper != null) {
            return this.peripheralWrapper.resetInterface();
        }
        Block block2 = level.m_8055_(pos).m_60734_();
        if (block2 instanceof BasicInterfaceBlock) {
            BasicInterfaceBlock ccInterface = (BasicInterfaceBlock)block2;
            ccInterface.updateInterface(state, level, pos);
        }
        return true;
    }

    public Direction getDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof BasicInterfaceBlock) {
            return (Direction)gateState.m_61143_((Property)BasicInterfaceBlock.FACING);
        }
        StargateJourney.LOGGER.info("Couldn't find Direction");
        return null;
    }

    @Nullable
    public EnergyBlockEntity findEnergyBlockEntity() {
        EnergyBlockEntity energyBlockEntity;
        BlockEntity blockEntity;
        Direction direction = this.getDirection();
        if (direction == null) {
            return null;
        }
        BlockPos realPos = this.m_58899_().m_121945_(direction);
        BlockState state = this.f_58857_.m_8055_(realPos);
        if (this.f_58857_.m_8055_(realPos).m_60734_() instanceof AbstractStargateRingBlock) {
            realPos = ((StargatePart)((Object)state.m_61143_(AbstractStargateRingBlock.PART))).getBaseBlockPos(realPos, (Direction)state.m_61143_((Property)AbstractStargateRingBlock.FACING), (Orientation)((Object)state.m_61143_(AbstractStargateRingBlock.ORIENTATION)));
        }
        return (blockEntity = this.f_58857_.m_7702_(realPos)) instanceof EnergyBlockEntity ? (energyBlockEntity = (EnergyBlockEntity)blockEntity) : null;
    }

    @Override
    public boolean isCorrectSide(Direction side) {
        return side != this.getDirection().m_122424_();
    }

    @Override
    protected boolean outputsEnergy() {
        return false;
    }

    @Override
    protected boolean receivesEnergy() {
        return true;
    }

    @Override
    public long capacity() {
        return (Long)CommonInterfaceConfig.basic_interface_capacity.get();
    }

    @Override
    public long maxReceive() {
        return (Long)CommonInterfaceConfig.basic_interface_max_transfer.get();
    }

    @Override
    public long maxExtract() {
        return (Long)CommonInterfaceConfig.basic_interface_max_transfer.get();
    }

    @Override
    protected void outputEnergy(Direction outputDirection) {
        long storedEnergy = this.getEnergyStored();
        long energyExtracted = Math.min(storedEnergy, this.maxExtract());
        long simulatedReceiveAmount = this.energyBlockEntity.receiveEnergy(energyExtracted, true);
        this.setEnergy(storedEnergy - energyExtracted);
        this.energyBlockEntity.receiveEnergy(simulatedReceiveAmount, false);
    }

    public BasicPeripheralWrapper getPeripheralWrapper() {
        if (!ModList.get().isLoaded("computercraft")) {
            return null;
        }
        return this.peripheralWrapper;
    }

    public void queueEvent(String eventName, Object ... objects) {
        if (!ModList.get().isLoaded("computercraft")) {
            return;
        }
        this.peripheralWrapper.queueEvent(eventName, objects);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BasicInterfaceEntity basicInterface) {
        basicInterface.energyBlockEntity = basicInterface.findEnergyBlockEntity();
        if (basicInterface.energyBlockEntity != null) {
            int lastSymbol = basicInterface.currentSymbol;
            basicInterface.outputEnergy(basicInterface.getDirection());
            EnergyBlockEntity energyBlockEntity = basicInterface.energyBlockEntity;
            if (energyBlockEntity instanceof MilkyWayStargateEntity) {
                MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)energyBlockEntity;
                basicInterface.rotateStargate(stargate);
            }
            if (lastSymbol != basicInterface.currentSymbol && !level.m_5776_()) {
                BasicInterfaceEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                level.m_46590_(pos, state.m_60734_(), (Direction)state.m_61143_((Property)BasicInterfaceBlock.FACING));
            }
        }
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(basicInterface.f_58858_)), (Object)new ClientboundBasicInterfaceUpdatePacket(basicInterface.f_58858_, basicInterface.getEnergyStored()));
    }

    private void rotateStargate(MilkyWayStargateEntity stargate) {
        if (this.rotate) {
            if (stargate.isCurrentSymbol(this.desiredSymbol)) {
                this.rotate = false;
            } else {
                stargate.rotate(this.rotateClockwise);
            }
        }
        this.currentSymbol = stargate.getCurrentSymbol();
    }
}

