/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.TransportRingsEntity;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundRingPanelUpdatePacket;
import org.jetbrains.annotations.NotNull;

public class RingPanelEntity
extends BlockEntity {
    private String[] rings;
    public int ringsFound;
    private BlockPos connectedPos;
    private BlockPos targetPos;
    public BlockPos[] ringsPos = new BlockPos[6];
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public RingPanelEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.RING_PANEL.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                RingPanelEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 1: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 2: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 3: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 4: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                    case 5: {
                        return stack.m_41720_() == ItemInit.MEMORY_CRYSTAL.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, side);
    }

    public CompoundTag getNearest6Rings(Level level, BlockPos pos, double maxDistance) {
        String connected = this.connectToRings();
        CompoundTag tag = TransporterNetwork.get(level).get6ClosestRingsFromTag(level.m_46472_().m_135782_().toString(), pos, maxDistance, connected);
        List tagList = tag.m_128431_().stream().collect(Collectors.toList());
        this.ringsFound = tag.m_128440_();
        for (int i = 0; i < 6; ++i) {
            if (i < this.ringsFound) {
                int[] coords = tag.m_128469_((String)tagList.get(i)).m_128465_("Coordinates");
                this.ringsPos[i] = new BlockPos(coords[0], coords[1], coords[2]);
                continue;
            }
            this.ringsPos[i] = new BlockPos(0, 0, 0);
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundRingPanelUpdatePacket(this.f_58858_, this.ringsFound, this.ringsPos[0], this.ringsPos[1], this.ringsPos[2], this.ringsPos[3], this.ringsPos[4], this.ringsPos[5]));
        return tag;
    }

    public String connectToRings() {
        CompoundTag rings = TransporterNetwork.get(this.f_58857_).getClosestRingsFromTag(this.f_58857_.m_46472_().m_135782_().toString(), this.m_58899_(), new CompoundTag(), 32000.0);
        if (rings.m_128456_()) {
            return null;
        }
        List tagList = rings.m_128431_().stream().collect(Collectors.toList());
        String connected = (String)tagList.get(0);
        int[] coords = rings.m_128469_(connected).m_128465_("Coordinates");
        this.connectedPos = new BlockPos(coords[0], coords[1], coords[2]);
        return connected;
    }

    public void activateRings(int chosenNumber) {
        ItemStack stack = this.itemHandler.getStackInSlot(chosenNumber);
        if (!stack.m_41619_() && stack.m_41783_().m_128441_("coordinates")) {
            int[] coordinates = this.itemHandler.getStackInSlot(chosenNumber).m_41783_().m_128465_("coordinates");
            this.targetPos = new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
        } else {
            this.targetPos = this.ringsPos[chosenNumber];
        }
        if (this.targetPos == null) {
            return;
        }
        if (this.connectedPos == null) {
            return;
        }
        BlockEntity localRings = this.f_58857_.m_7702_(this.connectedPos);
        if (localRings instanceof TransportRingsEntity) {
            TransportRingsEntity rings = (TransportRingsEntity)localRings;
            if (!rings.canTransport()) {
                return;
            }
            BlockEntity targetRings = this.f_58857_.m_7702_(this.targetPos);
            if (targetRings instanceof TransportRingsEntity) {
                TransportRingsEntity target = (TransportRingsEntity)targetRings;
                if (!target.canTransport()) {
                    return;
                }
                rings.activate(this.targetPos);
            }
        }
    }

    public int[] getTargetCoords(int chosenNumber) {
        ItemStack stack = this.itemHandler.getStackInSlot(chosenNumber);
        if (!stack.m_41619_() && stack.m_41783_().m_128441_("coordinates")) {
            return this.itemHandler.getStackInSlot(chosenNumber).m_41783_().m_128465_("coordinates");
        }
        CompoundTag ringsTag = BlockEntityList.get(this.f_58857_).getBlockEntities("TransportRings");
        int[] coords = new int[]{ringsTag.m_128465_(this.rings[chosenNumber])[0], ringsTag.m_128465_(this.rings[chosenNumber])[1], ringsTag.m_128465_(this.rings[chosenNumber])[2]};
        return coords;
    }
}

