/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.misc.ArrayHelper;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundPegasusStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class PegasusStargateEntity
extends AbstractStargateEntity {
    public int currentSymbol = 0;
    public int[] addressBuffer = new int[0];
    public int symbolBuffer = 0;
    private boolean passedOver = false;

    public PegasusStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get(), pos, state, Stargate.Gen.GEN_3, 3);
        this.setOpenSoundLead(13);
    }

    @Override
    public void onLoad() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.setPointOfOrigin(this.m_58904_());
        this.setSymbols(this.m_58904_());
        super.onLoad();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.addressBuffer = nbt.m_128465_("AddressBuffer");
        this.symbolBuffer = nbt.m_128451_("SymbolBuffer");
        this.currentSymbol = nbt.m_128451_("CurrentSymbol");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128385_("AddressBuffer", this.addressBuffer);
        nbt.m_128405_("SymbolBuffer", this.symbolBuffer);
        nbt.m_128405_("CurrentSymbol", this.currentSymbol);
    }

    @Override
    public SoundEvent getChevronEngageSound() {
        return (SoundEvent)SoundInit.PEGASUS_CHEVRON_ENGAGE.get();
    }

    public SoundEvent chevronIncomingSound() {
        return (SoundEvent)SoundInit.PEGASUS_CHEVRON_INCOMING.get();
    }

    @Override
    public SoundEvent getWormholeOpenSound() {
        return (SoundEvent)SoundInit.PEGASUS_WORMHOLE_OPEN.get();
    }

    @Override
    public SoundEvent getFailSound() {
        return (SoundEvent)SoundInit.PEGASUS_DIAL_FAIL.get();
    }

    @Override
    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.isConnected() && symbol == 0) {
            return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT);
        }
        if (Address.addressContainsSymbol(this.addressBuffer, symbol)) {
            return Stargate.Feedback.SYMBOL_ENCODED;
        }
        if (this.addressBuffer.length == this.getAddress().length && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, false));
        }
        this.addressBuffer = ArrayHelper.growIntArray(this.addressBuffer, symbol);
        return Stargate.Feedback.SYMBOL_ENCODED;
    }

    @Override
    protected Stargate.Feedback lockPrimaryChevron() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, true));
        }
        return super.lockPrimaryChevron();
    }

    @Override
    public Stargate.Feedback encodeChevron(int symbol, boolean incoming) {
        ++this.symbolBuffer;
        this.passedOver = false;
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, true));
        }
        Stargate.Feedback feedback = super.encodeChevron(symbol, incoming);
        if (this.addressBuffer.length > this.getAddress().length && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, false));
        }
        return feedback;
    }

    @Override
    public void chevronSound(boolean incoming) {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, incoming));
        }
    }

    public int getChevronPosition(int chevron) {
        if (chevron < 1 || chevron > 8) {
            return 0;
        }
        return (new int[]{4, 8, 12, 24, 28, 32, 16, 20})[chevron - 1];
    }

    private void animateSpin() {
        if (!this.isConnected() && this.addressBuffer.length > this.symbolBuffer) {
            int symbol = this.addressBuffer[this.symbolBuffer];
            if (symbol == 0) {
                if (this.currentSymbol == this.getChevronPosition(9)) {
                    this.lockPrimaryChevron();
                } else {
                    this.symbolWork();
                }
            } else if (this.currentSymbol == this.getChevronPosition(this.symbolBuffer + 1)) {
                if (this.symbolBuffer % 2 != 0 && !this.passedOver) {
                    this.passedOver = true;
                    this.symbolWork();
                } else {
                    this.encodeChevron(symbol, false);
                }
            } else {
                this.symbolWork();
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PegasusStargateEntity stargate) {
        if (level.m_5776_()) {
            return;
        }
        stargate.animateSpin();
        AbstractStargateEntity.tick(level, pos, state, stargate);
        stargate.updatePegasusStargate();
    }

    public void updatePegasusStargate() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundPegasusStargateUpdatePacket(this.f_58858_, this.symbolBuffer, this.addressBuffer, this.currentSymbol));
    }

    private void symbolWork() {
        this.currentSymbol = this.symbolBuffer % 2 == 0 ? --this.currentSymbol : ++this.currentSymbol;
        if (this.currentSymbol > 35) {
            this.currentSymbol = 0;
        } else if (this.currentSymbol < 0) {
            this.currentSymbol = 35;
        }
    }

    @Override
    public Stargate.Feedback resetStargate(Stargate.Feedback feedback) {
        this.currentSymbol = 0;
        this.symbolBuffer = 0;
        this.addressBuffer = new int[0];
        return super.resetStargate(feedback);
    }

    @Override
    public void playRotationSound() {
        this.stopRotationSound();
        this.spinSound.playSound();
    }

    @Override
    public void stopRotationSound() {
        this.spinSound.stopSound();
    }
}

