/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.povstalec.sgjourney.common.block_entities.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.blocks.BasicInterfaceBlock;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.menu.CrystalInterfaceMenu;

public class CrystalInterfaceBlock
extends BasicInterfaceBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public CrystalInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrystalInterfaceEntity(pos, state);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!level.f_46443_) {
            final BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CrystalInterfaceEntity) {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"screen.sgjourney.crystal_interface");
                    }

                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new CrystalInterfaceMenu(windowId, playerInventory, blockEntity);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)blockEntity.m_58899_());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Block getDroppedBlock() {
        return (Block)BlockInit.CRYSTAL_INTERFACE.get();
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        if (level.m_5776_()) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(true)), 3);
        level.m_186460_(pos, (Block)this, 2);
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos targetPos = pos.m_121945_(direction);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrystalInterfaceEntity) {
            CrystalInterfaceEntity crystalInterface = (CrystalInterfaceEntity)blockEntity;
            crystalInterface.setInputSignal(level.m_277086_(pos));
            if (targetPos.equals((Object)pos2) && crystalInterface.updateInterface(level, targetPos, block, state)) {
                level.m_46590_(pos, state.m_60734_(), (Direction)state.m_61143_((Property)FACING));
            }
        }
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return CrystalInterfaceBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.CRYSTAL_INTERFACE.get()), CrystalInterfaceEntity::tick);
    }

    @Override
    public long getCapacity() {
        return 50000000L;
    }

    @Override
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        CrystalInterfaceEntity crystalInterface;
        EnergyBlockEntity energyBlockEntity;
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof CrystalInterfaceEntity && (energyBlockEntity = (crystalInterface = (CrystalInterfaceEntity)entity).findEnergyBlockEntity()) instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)energyBlockEntity;
            int offset = 0;
            if (crystalInterface.getInputSignal() >= 7) {
                offset = 26;
            } else if (crystalInterface.getInputSignal() > 0) {
                offset = 13;
            }
            int output = stargate.getCurrentSymbol() - offset;
            if (output <= 0) {
                return 0;
            }
            if (output >= 15) {
                return 15;
            }
            return output;
        }
        return 0;
    }
}

