/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.misc.Orientation;
import net.povstalec.sgjourney.common.stargate.StargatePart;

public abstract class AbstractStargateRingBlock
extends AbstractStargateBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);
    public static final EnumProperty<StargatePart> PART = EnumProperty.m_61587_((String)"stargate_part", StargatePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");
    public static final IntegerProperty CHEVRONS_ACTIVE = IntegerProperty.m_61631_((String)"chevrons_active", (int)0, (int)9);

    public AbstractStargateRingBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties, width, horizontalOffset);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return switch ((StargatePart)((Object)state.m_61143_(PART))) {
            case StargatePart.LEFT2, StargatePart.LEFT3_ABOVE -> this.getShapeFromArray(this.SHAPE_PROVIDER.CORNER_TOP_RIGHT, direction, orientation);
            case StargatePart.LEFT2_ABOVE -> this.getShapeFromArray(this.SHAPE_PROVIDER.STAIR_TOP_RIGHT, direction, orientation);
            case StargatePart.LEFT3_ABOVE5, StargatePart.LEFT2_ABOVE6 -> this.getShapeFromArray(this.SHAPE_PROVIDER.CORNER_BOTTOM_RIGHT, direction, orientation);
            case StargatePart.LEFT2_ABOVE5 -> this.getShapeFromArray(this.SHAPE_PROVIDER.STAIR_BOTTOM_RIGHT, direction, orientation);
            case StargatePart.RIGHT2_ABOVE6, StargatePart.RIGHT3_ABOVE5 -> this.getShapeFromArray(this.SHAPE_PROVIDER.CORNER_BOTTOM_LEFT, direction, orientation);
            case StargatePart.RIGHT2_ABOVE5 -> this.getShapeFromArray(this.SHAPE_PROVIDER.STAIR_BOTTOM_LEFT, direction, orientation);
            case StargatePart.RIGHT3_ABOVE, StargatePart.RIGHT2 -> this.getShapeFromArray(this.SHAPE_PROVIDER.CORNER_TOP_LEFT, direction, orientation);
            case StargatePart.RIGHT2_ABOVE -> this.getShapeFromArray(this.SHAPE_PROVIDER.STAIR_TOP_LEFT, direction, orientation);
            default -> this.getShapeFromArray(this.SHAPE_PROVIDER.FULL, direction, orientation);
        };
    }

    private boolean isWaterLogged(BlockState state, Level level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            return true;
        }
        return state.m_60734_() instanceof AbstractStargateBlock ? (Boolean)state.m_61143_((Property)AbstractStargateBlock.WATERLOGGED) : false;
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            BlockPos centerPos;
            BlockState centerState = level.m_8055_(centerPos = ((StargatePart)((Object)oldState.m_61143_(PART))).getBaseBlockPos(pos, (Direction)oldState.m_61143_((Property)FACING), (Orientation)((Object)oldState.m_61143_(ORIENTATION))));
            level.m_7731_(centerPos, this.isWaterLogged(centerState, level, centerPos) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 35);
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }
}

