/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.cctweaked.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import java.util.HashMap;
import net.povstalec.sgjourney.common.block_entities.CrystalInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.cctweaked.methods.InterfaceMethod;
import net.povstalec.sgjourney.common.cctweaked.methods.MilkyWayStargateMethods;
import net.povstalec.sgjourney.common.cctweaked.peripherals.CrystalInterfacePeripheral;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class CrystalStargatePeripheral
extends CrystalInterfacePeripheral
implements IDynamicPeripheral {
    protected AbstractStargateEntity stargate;
    private HashMap<String, InterfaceMethod<AbstractStargateEntity>> methods = new HashMap();

    public CrystalStargatePeripheral(CrystalInterfaceEntity crystalInterface, AbstractStargateEntity stargate) {
        super(crystalInterface);
        this.crystalInterface = crystalInterface;
        this.stargate = stargate;
        if (stargate instanceof MilkyWayStargateEntity) {
            this.registerMilkyWayStargateMethods();
        }
    }

    public String[] getMethodNames() {
        return this.methods.keySet().toArray(new String[0]);
    }

    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        String methodName = this.getMethodNames()[method];
        return this.methods.get(methodName).use(computer, context, this.stargate, arguments);
    }

    @LuaFunction
    public void inputSymbol(ILuaContext context, int symbol) throws LuaException {
        context.executeMainThreadTask(() -> {
            this.stargate.engageSymbol(symbol);
            return null;
        });
    }

    @LuaFunction
    public final boolean isStargateConnected() {
        return this.stargate.isConnected();
    }

    @LuaFunction
    public final long getStargateEnergy() {
        return this.stargate.getEnergyStored();
    }

    @LuaFunction
    public final int getChevronsEngaged() {
        return this.stargate.getChevronsEngaged();
    }

    @LuaFunction
    public final int getOpenTime() {
        return this.stargate.getOpenTime();
    }

    @LuaFunction
    public final MethodResult disconnectStargate(ILuaContext context) throws LuaException {
        MethodResult result = context.executeMainThreadTask(() -> {
            Stargate.Feedback feedback = this.stargate.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT);
            return new Object[]{!feedback.isError()};
        });
        return result;
    }

    private <Stargate extends AbstractStargateEntity> void registerMilkyWayStargateMethod(InterfaceMethod<Stargate> function) {
        this.methods.put(function.getName(), function);
    }

    public void registerMilkyWayStargateMethods() {
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.GetCurrentSymbol());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.IsCurrentSymbol());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.GetRotation());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.RotateClockwise());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.RotateAntiClockwise());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.EndRotation());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.RaiseChevron());
        this.registerMilkyWayStargateMethod(new MilkyWayStargateMethods.LowerChevron());
    }
}

