/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;

public class BlockEntityList
extends SavedData {
    private static final String FILE_NAME = "sgjourney-block_enties";
    public static final String STARGATES = "Stargates";
    public static final String TRANSPORT_RINGS = "TransportRings";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    protected CompoundTag blockEntityList = new CompoundTag();

    public CompoundTag addBlockEntity(Level level, BlockPos pos, String listName, String id) {
        String dimension = level.m_46472_().m_135782_().toString();
        CompoundTag localList = this.blockEntityList.m_128469_(listName);
        CompoundTag blockEntity = new CompoundTag();
        blockEntity.m_128359_(DIMENSION, dimension);
        blockEntity.m_128385_(COORDINATES, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        localList.m_128365_(id, (Tag)blockEntity);
        this.blockEntityList.m_128365_(listName, (Tag)localList);
        this.m_77762_();
        return blockEntity;
    }

    public void removeBlockEntity(String type, String id) {
        if (!this.getBlockEntities(type).m_128441_(id)) {
            StargateJourney.LOGGER.info(type + " does not contain " + id);
            return;
        }
        this.blockEntityList.m_128469_(type).m_128473_(id);
        StargateJourney.LOGGER.info("Removed " + id + " from " + type);
        this.m_77762_();
    }

    public CompoundTag getBlockEntities(String blockEntities) {
        return this.blockEntityList.m_6426_().m_128469_(blockEntities);
    }

    public static BlockEntityList create() {
        return new BlockEntityList();
    }

    public static BlockEntityList load(CompoundTag tag) {
        BlockEntityList data = BlockEntityList.create();
        data.blockEntityList = tag.m_6426_();
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.blockEntityList.m_6426_();
        return tag;
    }

    @Nonnull
    public static BlockEntityList get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return BlockEntityList.get(level.m_7654_());
    }

    @Nonnull
    public static BlockEntityList get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (BlockEntityList)storage.m_164861_(BlockEntityList::load, BlockEntityList::create, FILE_NAME);
    }
}

