/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.SGJourneyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateNetworkConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Connection;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class StargateNetwork
extends SavedData {
    private static boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    private static final String FILE_NAME = "sgjourney-stargate_network";
    private static final String VERSION = "Version";
    private static final String USE_DATAPACK_ADDRESSES = "UseDatapackAddresses";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    private static final String TIMES_OPENED = "TimesOpened";
    private static final String GENERATION = "Generation";
    private static final String HAS_DHD = "HasDHD";
    private static final String STARGATES = "Stargates";
    private static final String SOLAR_SYSTEMS = "SolarSystems";
    private static final String CONNECTIONS = "Connections";
    private static final String EMPTY = "sgjourney:empty";
    private static final int updateVersion = 5;
    private MinecraftServer server;
    private Map<String, Connection> connections = new HashMap<String, Connection>();
    private CompoundTag stargateNetwork = new CompoundTag();
    private int version = 5;

    public int getVersion() {
        CompoundTag network = this.stargateNetwork.m_6426_();
        if (network.m_128441_(VERSION)) {
            return network.m_128451_(VERSION);
        }
        return 0;
    }

    private void updateVersion() {
        this.stargateNetwork.m_128405_(VERSION, this.version);
    }

    public void updateNetwork(MinecraftServer server) {
        if (this.getVersion() == this.version) {
            StargateJourney.LOGGER.info("Stargate Network is up to date (Version: " + this.version + ")");
            return;
        }
        StargateJourney.LOGGER.info("Detected an incompatible Stargate Network version (Version: " + this.getVersion() + ") - updating to version " + this.version);
        this.stellarUpdate(server);
    }

    public void eraseNetwork() {
        this.stargateNetwork = new CompoundTag();
        this.m_77762_();
    }

    public boolean shouldUseDatapackAddresses() {
        CompoundTag network = this.stargateNetwork.m_6426_();
        if (network.m_128441_(USE_DATAPACK_ADDRESSES)) {
            return network.m_128471_(USE_DATAPACK_ADDRESSES);
        }
        return CommonStargateNetworkConfig.use_datapack_addresses.get();
    }

    public void stellarUpdate(MinecraftServer server) {
        for (Map.Entry<String, Connection> nextConnection : this.connections.entrySet()) {
            Connection connection = nextConnection.getValue();
            connection.terminate(server, Stargate.Feedback.CONNECTION_ENDED_BY_NETWORK);
        }
        StargateJourney.LOGGER.info("Connections terminated");
        StargateNetworkSettings.get(server).updateSettings();
        Universe.get(server).eraseUniverseInfo();
        StargateJourney.LOGGER.info("Universe erased");
        Universe.get(server).generateUniverseInfo(server);
        StargateJourney.LOGGER.info("Universe regenerated");
        this.eraseNetwork();
        StargateJourney.LOGGER.info("Network erased");
        this.resetStargates(server);
        StargateJourney.LOGGER.info("Stargates reset");
        this.updateVersion();
        StargateJourney.LOGGER.info("Version updated");
        this.m_77762_();
        StargateJourney.LOGGER.info("Changes applied");
    }

    private void resetStargates(MinecraftServer server) {
        CompoundTag stargates = BlockEntityList.get(server).getBlockEntities(SGJourneyBlockEntity.Type.STARGATE.id);
        stargates.m_128431_().forEach(stargateID -> {
            String dimensionString = stargates.m_128469_(stargateID).m_128461_(DIMENSION);
            ResourceKey<Level> dimension = Conversion.stringToDimension(dimensionString);
            int[] coordinates = stargates.m_128469_(stargateID).m_128465_(COORDINATES);
            BlockPos pos = new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
            BlockEntity blockentity = server.m_129880_(dimension).m_7702_(pos);
            if (blockentity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
                if (!stargateID.equals(stargate.getID())) {
                    this.removeStargate((Level)server.m_129880_(dimension), (String)stargateID);
                }
                stargate.resetStargate(Stargate.Feedback.CONNECTION_ENDED_BY_NETWORK);
                if (!this.getStargates().m_128441_(stargateID)) {
                    this.addStargate(server, (String)stargateID, BlockEntityList.get(server).getBlockEntities(SGJourneyBlockEntity.Type.STARGATE.id).m_128469_(stargateID), stargate.getGeneration().getGen());
                    stargate.updateStargate();
                }
            } else {
                this.removeStargate((Level)server.m_129880_(dimension), (String)stargateID);
                BlockEntityList.get(server).removeBlockEntity(SGJourneyBlockEntity.Type.STARGATE.id, (String)stargateID);
            }
        });
    }

    public void addStargate(MinecraftServer server, String stargateID, CompoundTag stargateInfo, int generation) {
        String dimension = stargateInfo.m_128461_(DIMENSION);
        String stargateDimension = stargateInfo.m_128461_(DIMENSION);
        int[] stargateCoordinates = stargateInfo.m_128465_(COORDINATES);
        CompoundTag stargates = this.getStargates();
        CompoundTag stargate = new CompoundTag();
        stargate.m_128359_(DIMENSION, stargateDimension);
        stargate.m_128385_(COORDINATES, stargateCoordinates);
        stargate.m_128405_(GENERATION, generation);
        if (Universe.get(server).getDimensions().m_128441_(dimension)) {
            String systemID = Universe.get(server).getSolarSystemFromDimension(dimension);
            CompoundTag solarSystems = this.getSolarSystems();
            CompoundTag solarSystem = this.getSolarSystem(systemID);
            solarSystem.m_128365_(stargateID, (Tag)stargate);
            solarSystems.m_128365_(systemID, (Tag)solarSystem);
            this.stargateNetwork.m_128365_(SOLAR_SYSTEMS, (Tag)solarSystems);
        }
        stargates.m_128365_(stargateID, (Tag)stargate);
        this.stargateNetwork.m_128365_(STARGATES, (Tag)stargates);
        this.m_77762_();
        StargateJourney.LOGGER.info("Added Stargate " + stargateID);
    }

    public void removeStargate(Level level, String stargateID) {
        String dimension = level.m_46472_().m_135782_().toString();
        this.stargateNetwork.m_128469_(SOLAR_SYSTEMS).m_128469_(Universe.get(level).getSolarSystemFromDimension(dimension)).m_128473_(stargateID);
        this.stargateNetwork.m_128469_(STARGATES).m_128473_(stargateID);
        this.m_77762_();
        StargateJourney.LOGGER.info("Removed Stargate " + stargateID);
    }

    public void updateStargate(Level level, String stargateID, int timesOpened, boolean hasDHD) {
        CompoundTag solarSystems = this.getSolarSystems();
        String systemID = Universe.get(level).getSolarSystemFromDimension(level.m_46472_().m_135782_().toString());
        CompoundTag solarSystem = this.getSolarSystem(systemID);
        if (systemID.equals(EMPTY) || !solarSystem.m_128441_(stargateID)) {
            return;
        }
        CompoundTag stargate = solarSystem.m_128469_(stargateID);
        stargate.m_128405_(TIMES_OPENED, timesOpened);
        stargate.m_128379_(HAS_DHD, hasDHD);
        solarSystem.m_128365_(stargateID, (Tag)stargate);
        solarSystems.m_128365_(systemID, (Tag)solarSystem);
        this.stargateNetwork.m_128365_(SOLAR_SYSTEMS, (Tag)solarSystems);
        this.m_77762_();
    }

    public CompoundTag getSolarSystems() {
        return this.stargateNetwork.m_6426_().m_128469_(SOLAR_SYSTEMS);
    }

    public CompoundTag getSolarSystem(String systemID) {
        return this.getSolarSystems().m_128469_(systemID);
    }

    public CompoundTag getStargates() {
        return this.stargateNetwork.m_6426_().m_128469_(STARGATES);
    }

    public String getPreferredStargate(CompoundTag solarSystem) {
        if (solarSystem.m_128456_()) {
            return EMPTY;
        }
        Iterator iterator = solarSystem.m_128431_().iterator();
        boolean bestDHD = false;
        int bestGen = 0;
        int bestTimesOpened = 0;
        String preferredStargate = EMPTY;
        while (iterator.hasNext()) {
            String stargateID = (String)iterator.next();
            boolean hasDHD = solarSystem.m_128469_(stargateID).m_128471_(HAS_DHD);
            int generation = solarSystem.m_128469_(stargateID).m_128451_(GENERATION);
            int timesOpened = solarSystem.m_128469_(stargateID).m_128451_(TIMES_OPENED);
            System.out.println(stargateID + " Has DHD: " + hasDHD + " Gen: " + generation + " Times Opened: " + timesOpened);
            if (Boolean.compare(hasDHD, bestDHD) > 0) {
                preferredStargate = stargateID;
                bestDHD = hasDHD;
                bestGen = generation;
                bestTimesOpened = timesOpened;
                continue;
            }
            if (Boolean.compare(hasDHD, bestDHD) != 0) continue;
            if (generation > bestGen) {
                preferredStargate = stargateID;
                bestDHD = hasDHD;
                bestGen = generation;
                bestTimesOpened = timesOpened;
                continue;
            }
            if (generation != bestGen || timesOpened < bestTimesOpened) continue;
            preferredStargate = stargateID;
            bestDHD = hasDHD;
            bestGen = generation;
            bestTimesOpened = timesOpened;
        }
        System.out.println("Chose: " + preferredStargate + " Has DHD: " + bestDHD + " Gen: " + bestGen + " Times Opened: " + bestTimesOpened);
        return preferredStargate;
    }

    public void handleConnections() {
        HashMap<String, Connection> connections = new HashMap<String, Connection>();
        connections.putAll(this.connections);
        connections.forEach((connectionID, connection) -> connection.tick(this.server));
        this.m_77762_();
    }

    public int getOpenTime(String uuid) {
        if (this.connections.containsKey(uuid)) {
            return this.connections.get(uuid).getOpenTime();
        }
        return 0;
    }

    public int getTimeSinceLastTraveler(String uuid) {
        if (this.connections.containsKey(uuid)) {
            return this.connections.get(uuid).getTimeSinceLastTraveler();
        }
        return 0;
    }

    public Stargate.Feedback createConnection(MinecraftServer server, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate) {
        Stargate.ConnectionType connectionType = StargateNetwork.getConnectionType(server, dialingStargate, dialedStargate);
        if (((Object)((Object)dialingStargate)).equals((Object)dialedStargate)) {
            return dialingStargate.resetStargate(Stargate.Feedback.SELF_DIAL);
        }
        if (requireEnergy) {
            if (dialingStargate.hasEnergy(dialedStargate)) {
                dialingStargate.depleteEnergy(connectionType.getEstabilishingPowerCost(), false);
            } else {
                return dialingStargate.resetStargate(Stargate.Feedback.NOT_ENOUGH_POWER);
            }
        }
        if (dialedStargate.isConnected()) {
            return dialingStargate.resetStargate(Stargate.Feedback.ALREADY_CONNECTED);
        }
        if (dialedStargate.isObstructed()) {
            return dialingStargate.resetStargate(Stargate.Feedback.TARGET_OBSTRUCTED);
        }
        Connection connection = Connection.create(connectionType, dialingStargate, dialedStargate);
        if (connection != null) {
            this.connections.put(connection.getID(), connection);
            switch (connectionType) {
                case SYSTEM_WIDE: {
                    return Stargate.Feedback.CONNECTION_ESTABILISHED_SYSTEM_WIDE;
                }
                case INTERSTELLAR: {
                    return Stargate.Feedback.CONNECTION_ESTABILISHED_INTERSTELLAR;
                }
            }
            return Stargate.Feedback.CONNECTION_ESTABILISHED_INTERGALACTIC;
        }
        return Stargate.Feedback.UNKNOWN_ERROR;
    }

    public void terminateConnection(MinecraftServer server, String uuid, Stargate.Feedback feedback) {
        if (this.connections.containsKey(uuid)) {
            this.connections.get(uuid).terminate(server, feedback);
        }
    }

    public void removeConnection(MinecraftServer server, String uuid, Stargate.Feedback feedback) {
        if (this.connections.containsKey(uuid)) {
            this.connections.remove(uuid);
            StargateJourney.LOGGER.info("Removed connection " + uuid);
        } else {
            StargateJourney.LOGGER.info("Could not find connection " + uuid);
        }
        this.m_77762_();
    }

    public void rerouteConnection(MinecraftServer server, String uuid, AbstractStargateEntity newDialedStargate) {
        if (this.connections.containsKey(uuid)) {
            this.connections.get(uuid).reroute(newDialedStargate);
            StargateJourney.LOGGER.info("Rerouted connection " + uuid + " to " + newDialedStargate.getID());
        } else {
            StargateJourney.LOGGER.info("Could not find connection " + uuid);
        }
        this.m_77762_();
    }

    public static Stargate.ConnectionType getConnectionType(MinecraftServer server, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate) {
        String dialedSystem;
        String dialingSystem = Universe.get(server).getSolarSystemFromDimension(dialingStargate.m_58904_().m_46472_().m_135782_().toString());
        if (dialingSystem.equals(dialedSystem = Universe.get(server).getSolarSystemFromDimension(dialedStargate.m_58904_().m_46472_().m_135782_().toString()))) {
            return Stargate.ConnectionType.SYSTEM_WIDE;
        }
        ListTag dialingGalaxyCandidates = Universe.get(server).getGalaxiesFromSolarSystem(dialingSystem);
        ListTag dialedGalaxyCandidates = Universe.get(server).getGalaxiesFromSolarSystem(dialedSystem);
        if (!dialingGalaxyCandidates.isEmpty()) {
            for (int i = 0; i < dialingGalaxyCandidates.size(); ++i) {
                for (int j = 0; j < dialedGalaxyCandidates.size(); ++j) {
                    String dialedGalaxy;
                    String dialingGalaxy = (String)dialingGalaxyCandidates.m_128728_(i).m_128431_().iterator().next();
                    if (!dialingGalaxy.equals(dialedGalaxy = (String)dialedGalaxyCandidates.m_128728_(j).m_128431_().iterator().next())) continue;
                    return Stargate.ConnectionType.INTERSTELLAR;
                }
            }
        }
        return Stargate.ConnectionType.INTERGALACTIC;
    }

    protected CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(VERSION, this.version);
        tag.m_128365_(CONNECTIONS, (Tag)this.serializeConnections());
        return tag;
    }

    protected CompoundTag serializeConnections() {
        CompoundTag tag = new CompoundTag();
        this.connections.forEach((connectionID, connection) -> tag.m_128365_(connectionID, (Tag)connection.serialize()));
        return tag;
    }

    protected void deserialize(CompoundTag tag) {
        this.version = tag.m_128451_(VERSION);
        this.deserializeConnections(tag);
    }

    protected void deserializeConnections(CompoundTag tag) {
        tag.m_128431_().forEach(connectionID -> this.connections.put((String)connectionID, Connection.deserialize(this.server, connectionID, tag.m_128469_(connectionID))));
    }

    public StargateNetwork(MinecraftServer server) {
        this.server = server;
    }

    public static StargateNetwork create(MinecraftServer server) {
        return new StargateNetwork(server);
    }

    public static StargateNetwork load(MinecraftServer server, CompoundTag tag) {
        StargateNetwork data = StargateNetwork.create(server);
        data.server = server;
        data.stargateNetwork = tag.m_6426_();
        data.deserializeConnections(tag.m_128469_(CONNECTIONS));
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.stargateNetwork.m_128365_(CONNECTIONS, (Tag)this.serializeConnections());
        tag = this.stargateNetwork.m_6426_();
        return tag;
    }

    @Nonnull
    public static StargateNetwork get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return StargateNetwork.get(level.m_7654_());
    }

    @Nonnull
    public static StargateNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (StargateNetwork)storage.m_164861_(tag -> StargateNetwork.load(server, tag), () -> StargateNetwork.create(server), FILE_NAME);
    }
}

