/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.TransportRingsEntity;
import net.povstalec.sgjourney.common.misc.Conversion;

public class TransporterNetwork
extends SavedData {
    private static final String FILE_NAME = "sgjourney-rings_network";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    private static final String CONNECTIONS = "Connections";
    private static final String RINGS_A = "RingsA";
    private static final String RINGS_B = "RingsB";
    private static final String CONNECTION_TIME = "ConnectionTime";
    private CompoundTag ringsNetwork = new CompoundTag();

    public CompoundTag getRings(String dimension) {
        return this.ringsNetwork.m_6426_().m_128469_(dimension);
    }

    public void addToNetwork(String ringsID, CompoundTag rings) {
        CompoundTag dimension = this.getRings(rings.m_128461_(DIMENSION));
        CompoundTag localRings = new CompoundTag();
        localRings.m_128385_(COORDINATES, rings.m_128465_(COORDINATES));
        dimension.m_128365_(ringsID, (Tag)localRings);
        this.ringsNetwork.m_128365_(rings.m_128461_(DIMENSION), (Tag)dimension);
        this.m_77762_();
        StargateJourney.LOGGER.info("Added Rings " + ringsID + " to Rings Network");
    }

    public void removeFromNetwork(Level level, String ringsID) {
        this.removeFromNetwork(level.m_46472_().m_135782_().toString(), ringsID);
    }

    public void removeFromNetwork(String dimension, String ringsID) {
        this.ringsNetwork.m_128469_(dimension).m_128473_(ringsID);
        this.m_77762_();
        StargateJourney.LOGGER.info("Removing from network " + ringsID);
    }

    private BlockPos intToPos(int[] coords) {
        return new BlockPos(coords[0], coords[1], coords[2]);
    }

    private double distance(BlockPos pos1, BlockPos pos2) {
        return Math.sqrt(Math.pow(pos1.m_123341_() - pos2.m_123341_(), 2.0) + Math.pow(pos1.m_123342_() - pos2.m_123342_(), 2.0) + Math.pow(pos1.m_123343_() - pos2.m_123343_(), 2.0));
    }

    private CompoundTag closestRings(CompoundTag dim, CompoundTag rings, BlockPos pos, double maxDistance) {
        double distance = maxDistance;
        CompoundTag close = new CompoundTag();
        List ids = dim.m_128431_().stream().collect(Collectors.toList());
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            BlockPos pos2 = this.intToPos(dim.m_128469_(id).m_128465_(COORDINATES));
            double dist = this.distance(pos, pos2);
            if (!(dist <= distance)) continue;
            distance = dist;
            close = new CompoundTag();
            close.m_128365_(id, (Tag)dim.m_128469_(id));
        }
        rings.m_128391_(close);
        return rings;
    }

    public CompoundTag getClosestRingsFromTag(String dimension, BlockPos pos, CompoundTag rings, double maxDistance) {
        CompoundTag dim = this.getRings(dimension);
        return this.getClosestRingsFromTag(dimension, pos, rings, maxDistance, dim);
    }

    public CompoundTag getClosestRingsFromTag(String dimension, BlockPos pos, CompoundTag rings, double maxDistance, String excludedID) {
        CompoundTag dim = this.getRings(dimension);
        dim.m_128473_(excludedID);
        return this.getClosestRingsFromTag(dimension, pos, rings, maxDistance, dim);
    }

    private CompoundTag getClosestRingsFromTag(String dimension, BlockPos pos, CompoundTag rings, double maxDistance, CompoundTag dim) {
        if (!rings.m_128456_()) {
            rings.m_128431_().stream().forEach(id -> dim.m_128473_(id));
        }
        rings = this.closestRings(dim, rings, pos, maxDistance);
        return rings;
    }

    public CompoundTag get6ClosestRingsFromTag(String dimension, BlockPos pos, double maxDistance, String excludedID) {
        CompoundTag rings = new CompoundTag();
        if (!this.ringsNetwork.m_128441_(dimension)) {
            return rings;
        }
        for (int i = 0; i < 6; ++i) {
            rings = this.getClosestRingsFromTag(dimension, pos, rings, maxDistance, excludedID);
        }
        return rings;
    }

    public void handleConnections(MinecraftServer server) {
        if (!this.getConnections().m_128456_()) {
            this.getConnections().m_128431_().forEach(uuid -> this.handleConnection(server, (String)uuid));
        }
    }

    private void handleConnection(MinecraftServer server, String uuid) {
        CompoundTag connections = this.getConnections();
        CompoundTag connection = connections.m_128469_(uuid);
        TransportRingsEntity ringsA = this.loadRings(server, connection.m_128469_(RINGS_A));
        TransportRingsEntity ringsB = this.loadRings(server, connection.m_128469_(RINGS_B));
        int connectionTime = connection.m_128451_(CONNECTION_TIME);
        ++connectionTime;
        if (ringsA == null || ringsB == null) {
            this.terminateConnection(server, uuid);
            return;
        }
        connection.m_128405_(CONNECTION_TIME, connectionTime);
        connections.m_128365_(uuid, (Tag)connection);
        this.ringsNetwork.m_128365_(CONNECTIONS, (Tag)connections);
        this.m_77762_();
        int heightA = ringsA.getTransportHeight();
        int heightB = ringsB.getTransportHeight();
        int greaterHeight = heightA >= heightB ? heightA : heightB;
        ringsA.setProgress(this.synchronizeProgress(greaterHeight, heightA, connectionTime));
        ringsA.setProgress(this.synchronizeProgress(greaterHeight, heightB, connectionTime));
    }

    public CompoundTag getConnections() {
        return this.ringsNetwork.m_128469_(CONNECTIONS).m_6426_();
    }

    public CompoundTag getConnection(String uuid) {
        return this.getConnections().m_128469_(uuid);
    }

    public ResourceKey<Level> getDimension(String uuid, String rings) {
        return Conversion.stringToDimension(this.getConnection(uuid).m_128469_(rings).m_128461_(DIMENSION));
    }

    public TransportRingsEntity getRings(MinecraftServer server, String uuid, String rings) {
        return this.loadRings(server, this.getConnection(uuid).m_128469_(rings));
    }

    public String startConnection(TransportRingsEntity ringsA, TransportRingsEntity ringsB) {
        if (((Object)((Object)ringsA)).equals((Object)ringsB)) {
            StargateJourney.LOGGER.info("Rings cannot create connection with itself");
            return "INVALID_SELF";
        }
        String uuid = UUID.randomUUID().toString();
        CompoundTag connections = this.getConnections();
        CompoundTag connection = new CompoundTag();
        CompoundTag ringsAInfo = this.saveRings(ringsA);
        CompoundTag ringsBInfo = this.saveRings(ringsB);
        connection.m_128365_(RINGS_A, (Tag)ringsAInfo);
        connection.m_128365_(RINGS_B, (Tag)ringsBInfo);
        connections.m_128365_(uuid, (Tag)connection);
        this.ringsNetwork.m_128365_(CONNECTIONS, (Tag)connections);
        this.m_77762_();
        StargateJourney.LOGGER.info("Created connection " + uuid);
        return uuid;
    }

    private int synchronizeProgress(int greaterHeight, int height, int progress) {
        int sync = height - greaterHeight + progress;
        return sync > 0 ? sync : 0;
    }

    private CompoundTag saveRings(TransportRingsEntity rings) {
        CompoundTag ringsInfo = new CompoundTag();
        ringsInfo.m_128359_(DIMENSION, rings.m_58904_().m_46472_().m_135782_().toString());
        ringsInfo.m_128385_(COORDINATES, new int[]{rings.m_58899_().m_123341_(), rings.m_58899_().m_123342_(), rings.m_58899_().m_123343_()});
        return ringsInfo;
    }

    private TransportRingsEntity loadRings(MinecraftServer server, CompoundTag ringsInfo) {
        ResourceKey<Level> dimension = Conversion.stringToDimension(ringsInfo.m_128461_(DIMENSION));
        BlockPos pos = Conversion.intArrayToBlockPos(ringsInfo.m_128465_(COORDINATES));
        BlockEntity blockEntity = server.m_129880_(dimension).m_7702_(pos);
        if (blockEntity instanceof TransportRingsEntity) {
            TransportRingsEntity rings = (TransportRingsEntity)blockEntity;
            return rings;
        }
        return null;
    }

    public void terminateConnection(MinecraftServer server, String uuid) {
        if (!this.getConnections().m_128441_(uuid)) {
            StargateJourney.LOGGER.info("Could not find connection " + uuid);
            return;
        }
        TransportRingsEntity ringsA = this.loadRings(server, this.getConnections().m_128469_(uuid).m_128469_(RINGS_A));
        TransportRingsEntity ringsB = this.loadRings(server, this.getConnections().m_128469_(uuid).m_128469_(RINGS_B));
        this.ringsNetwork.m_128469_(CONNECTIONS).m_128473_(uuid);
        this.m_77762_();
        StargateJourney.LOGGER.info("Ended connection " + uuid);
    }

    public static TransporterNetwork create() {
        return new TransporterNetwork();
    }

    public static TransporterNetwork load(CompoundTag tag) {
        TransporterNetwork data = TransporterNetwork.create();
        data.ringsNetwork = tag.m_6426_();
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.ringsNetwork.m_6426_();
        return tag;
    }

    @Nonnull
    public static TransporterNetwork get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return TransporterNetwork.get(level.m_7654_());
    }

    @Nonnull
    public static TransporterNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (TransporterNetwork)storage.m_164861_(TransporterNetwork::load, TransporterNetwork::create, FILE_NAME);
    }
}

