/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NaquadahBottleItem
extends Item {
    public NaquadahBottleItem(Item.Properties properties) {
        super(properties);
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new FluidHandlerItemStack.SwapEmpty(stack, new ItemStack((ItemLike)Items.f_42590_), 250){

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return stack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get();
            }

            protected void setContainerToEmpty() {
                super.setContainerToEmpty();
                this.container = this.emptyContainer;
            }
        };
    }

    public static ItemStack liquidNaquadahSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.LIQUID_NAQUADAH_BOTTLE.get());
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(((FlowingFluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get()).m_5613_(), 250), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    public static int getLiquidNaquadahAmount(ItemStack stack) {
        Optional liquidAmount = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> fluidHandler.getFluidInTank(0).getAmount());
        return liquidAmount.isPresent() ? (Integer)liquidAmount.get() : 0;
    }

    public static void drainLiquidNaquadah(ItemStack stack) {
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.drain(1, IFluidHandler.FluidAction.EXECUTE));
    }

    public static int getLiquidNaquadahMaxAmount() {
        return 250;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int fluidAmount = NaquadahBottleItem.getLiquidNaquadahAmount(stack);
        MutableComponent liquidNaquadah = Component.m_237115_((String)"fluid_type.sgjourney.liquid_naquadah").m_130940_(ChatFormatting.GREEN);
        liquidNaquadah.m_7220_((Component)Component.m_237113_((String)(" " + fluidAmount + "mB")).m_130940_(ChatFormatting.GREEN));
        tooltipComponents.add((Component)liquidNaquadah);
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

