/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.capabilities.ItemInventoryProvider;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.NaquadahBottleItem;

public class StaffWeaponItem
extends Item {
    public static final String IS_OPEN = "IsOpen";

    public StaffWeaponItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)this.getLiquidNaquadahAmount(stack) / 250.0f);
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)this.getLiquidNaquadahAmount(stack) / 250.0f);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemInventoryProvider(stack){

            @Override
            public int getNumberOfSlots() {
                return 1;
            }

            @Override
            public boolean isValid(int slot, ItemStack stack) {
                return stack.m_150930_((Item)ItemInit.LIQUID_NAQUADAH_BOTTLE.get()) || stack.m_150930_(Items.f_42590_);
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() && !level.m_5776_()) {
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (offHandStack.m_150930_((Item)ItemInit.MATOK.get())) {
                offHandStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    ItemStack returnStack = !mainHandStack.m_41619_() ? itemHandler.insertItem(0, mainHandStack, false) : itemHandler.extractItem(0, 1, false);
                    player.m_21008_(InteractionHand.MAIN_HAND, returnStack);
                });
            } else if (mainHandStack.m_150930_((Item)ItemInit.MATOK.get())) {
                StaffWeaponItem.setOpen(mainHandStack, !StaffWeaponItem.isOpen(mainHandStack));
            }
        } else if (!player.m_6144_() && this.canShoot(player, player.m_21120_(hand)) && StaffWeaponItem.isOpen(stack = player.m_21120_(hand))) {
            level.m_5594_(player, player.m_20183_(), (SoundEvent)SoundInit.MATOK_FIRE.get(), SoundSource.PLAYERS, 0.25f, 1.0f);
            if (!level.m_5776_()) {
                if (!player.m_7500_()) {
                    this.depleteLiquidNaquadah(player.m_21120_(hand));
                }
                PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends ThrowableProjectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)player, level);
                plasmaProjectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 5.0f, 1.0f);
                level.m_7967_((Entity)plasmaProjectile);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            player.m_36335_().m_41524_((Item)this, 25);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public int getLiquidNaquadahAmount(ItemStack stack) {
        Optional optional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            ItemStack inventoryStack = itemHandler.getStackInSlot(0);
            if (inventoryStack.m_150930_((Item)ItemInit.LIQUID_NAQUADAH_BOTTLE.get())) {
                return NaquadahBottleItem.getLiquidNaquadahAmount(inventoryStack);
            }
            return 0;
        });
        return optional.isPresent() ? (Integer)optional.get() : 0;
    }

    public void depleteLiquidNaquadah(ItemStack stack) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            ItemStack inventoryStack = itemHandler.getStackInSlot(0);
            if (inventoryStack.m_150930_((Item)ItemInit.LIQUID_NAQUADAH_BOTTLE.get())) {
                if (NaquadahBottleItem.getLiquidNaquadahAmount(inventoryStack) > 0) {
                    NaquadahBottleItem.drainLiquidNaquadah(inventoryStack);
                } else {
                    itemHandler.extractItem(0, 1, false);
                    itemHandler.insertItem(0, new ItemStack((ItemLike)Items.f_42590_), false);
                }
            }
        });
    }

    public boolean hasLiquidNaquadah(ItemStack stack) {
        return this.getLiquidNaquadahAmount(stack) > 0;
    }

    public boolean canShoot(Player player, ItemStack stack) {
        return player.m_7500_() ? true : this.hasLiquidNaquadah(stack);
    }

    public static boolean isOpen(ItemStack stack) {
        if (stack.m_150930_((Item)ItemInit.MATOK.get())) {
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(IS_OPEN)) {
                tag.m_128379_(IS_OPEN, false);
                stack.m_41751_(tag);
            }
            return tag.m_128471_(IS_OPEN);
        }
        return false;
    }

    public static void setOpen(ItemStack stack, boolean isOpen) {
        if (stack.m_150930_((Item)ItemInit.MATOK.get())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_(IS_OPEN, isOpen);
            stack.m_41751_(tag);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int fluidAmount = this.getLiquidNaquadahAmount(stack);
        MutableComponent isOpen = StaffWeaponItem.isOpen(stack) ? Component.m_237115_((String)"tooltip.sgjourney.matok.open").m_130940_(ChatFormatting.YELLOW) : Component.m_237115_((String)"tooltip.sgjourney.matok.closed").m_130940_(ChatFormatting.YELLOW);
        tooltipComponents.add((Component)isOpen);
        MutableComponent liquidNaquadah = Component.m_237115_((String)"fluid_type.sgjourney.liquid_naquadah").m_130940_(ChatFormatting.GREEN);
        liquidNaquadah.m_7220_((Component)Component.m_237113_((String)(" " + fluidAmount + "mB")).m_130940_(ChatFormatting.GREEN));
        tooltipComponents.add((Component)liquidNaquadah);
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

