/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.armor;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.capabilities.ItemEnergyProvider;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.misc.AncientTech;
import org.jetbrains.annotations.Nullable;

public class PersonalShieldItem
extends ArmorItem
implements AncientTech {
    public static final String ENERGY = "Energy";
    protected static final int MAX_ENERGY = 100000;

    public PersonalShieldItem(ArmorMaterial material, ArmorItem.Type slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)PersonalShieldItem.getEnergy(stack) / 100000.0f);
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)PersonalShieldItem.getEnergy(stack) / 100000.0f);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack){

            @Override
            public long capacity() {
                return 100000L;
            }

            @Override
            public long maxReceive() {
                return 1000L;
            }

            @Override
            public long maxExtract() {
                return 100000L;
            }
        };
    }

    public static int getEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ENERGY)) {
            tag.m_128405_(ENERGY, 0);
        }
        int energy = tag.m_128451_(ENERGY);
        return energy;
    }

    public static void depleteEnergy(ItemStack stack, int energyExtracted) {
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> System.out.println(energyExtracted + " " + energyStorage.extractEnergy(energyExtracted, false)));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int energy = PersonalShieldItem.getEnergy(stack);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + energy + "/100000 FE"))).m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static ItemStack personalShieldSetup() {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.PERSONAL_SHIELD_EMITTER.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(ENERGY, 100000L);
        return stack;
    }
}

