/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.SGJourneyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.data.StargateNetwork;

public class SGJourneyBlockItem
extends BlockItem {
    private static final String ID = "ID";
    private static final String ADD_TO_NETWORK = "AddToNetwork";
    private static final String POINT_OF_ORIGIN = "PointOfOrigin";
    private static final String SYMBOLS = "Symbols";
    private static final String TIMES_OPENED = "TimesOpened";
    private static final String EMPTY = "sgjourney:empty";

    public SGJourneyBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return SGJourneyBlockItem.m_40582_(level, player, pos, stack);
    }

    public static boolean m_40582_(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag compoundtag = SGJourneyBlockItem.m_186336_((ItemStack)stack);
        if (compoundtag != null) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity != null) {
                if (!(level.m_5776_() || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                    return false;
                }
                CompoundTag compoundtag1 = blockentity.m_187482_();
                CompoundTag compoundtag2 = compoundtag1.m_6426_();
                compoundtag1.m_128391_(compoundtag);
                if (!compoundtag1.equals((Object)compoundtag2)) {
                    blockentity.m_142466_(compoundtag1);
                    blockentity.m_6596_();
                    return SGJourneyBlockItem.setupBlockEntity(level, blockentity, compoundtag);
                }
            }
        } else {
            BlockEntity baseEntity = level.m_7702_(pos);
            if (baseEntity instanceof SGJourneyBlockEntity) {
                SGJourneyBlockEntity blockEntity = (SGJourneyBlockEntity)baseEntity;
                blockEntity.addNewToBlockEntityList();
            }
        }
        return false;
    }

    private static boolean setupBlockEntity(Level level, BlockEntity baseEntity, CompoundTag info) {
        if (baseEntity instanceof SGJourneyBlockEntity) {
            SGJourneyBlockEntity blockEntity = (SGJourneyBlockEntity)baseEntity;
            boolean addToNetwork = true;
            if (info.m_128441_(ADD_TO_NETWORK)) {
                addToNetwork = info.m_128471_(ADD_TO_NETWORK);
            }
            if (addToNetwork) {
                if (info.m_128441_(ID) && !info.m_128461_(ID).equals(EMPTY)) {
                    blockEntity.addToBlockEntityList();
                } else {
                    blockEntity.addNewToBlockEntityList();
                }
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    StargateNetwork.get(level).updateStargate(level, info.m_128461_(ID), info.m_128451_(TIMES_OPENED), false);
                }
            }
            if (blockEntity instanceof MilkyWayStargateEntity) {
                MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)blockEntity;
                if (!addToNetwork) {
                    if (!info.m_128441_(POINT_OF_ORIGIN)) {
                        milkyWayStargate.setPointOfOrigin(EMPTY);
                    }
                    if (!info.m_128441_(SYMBOLS)) {
                        milkyWayStargate.setSymbols(EMPTY);
                    }
                }
            }
        }
        return false;
    }
}

