/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CommunicationCrystalItem
extends Item {
    private static final String FREQUENCY = "Frequency";
    private final int distance;

    public CommunicationCrystalItem(Item.Properties properties, int distance) {
        super(properties);
        this.distance = distance;
    }

    public int getFrequency(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(FREQUENCY)) {
            tag.m_128405_(FREQUENCY, 0);
        }
        int frequency = tag.m_128451_(FREQUENCY);
        return frequency;
    }

    public static CompoundTag tagSetup(int frequency) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(FREQUENCY, frequency);
        return tag;
    }

    public int getMaxDistance() {
        return this.distance;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        MutableComponent description = Component.m_237115_((String)"tooltip.sgjourney.communication_crystal.frequency").m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(ChatFormatting.GRAY);
        int frequency = this.getFrequency(stack);
        if (frequency == 0) {
            tooltipComponents.add((Component)description.m_7220_((Component)Component.m_237115_((String)"tooltip.sgjourney.crystal.none").m_130940_(ChatFormatting.GRAY)));
        } else {
            tooltipComponents.add((Component)description.m_7220_((Component)Component.m_237113_((String)("" + frequency)).m_130940_(ChatFormatting.GRAY)));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

