/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.stargate.Address;
import org.jetbrains.annotations.Nullable;

public class MemoryCrystalItem
extends Item {
    private static final String MEMORY_TYPE = "MemoryType";
    private static final String MEMORY_LIST = "MemoryList";
    private static final String ID = "ID";
    private static final String COORDINATES = "Coordinates";
    private static final String ADDRESS = "Address";
    private int memoryCapacity;

    public MemoryCrystalItem(Item.Properties properties, int memoryCapacity) {
        super(properties);
        this.memoryCapacity = memoryCapacity;
    }

    public static ListTag getMemoryList(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() instanceof MemoryCrystalItem && (tag = stack.m_41784_()).m_128425_(MEMORY_LIST, 9)) {
            return tag.m_128437_(MEMORY_LIST, 10);
        }
        return new ListTag();
    }

    public static int getMemoryListSize(ItemStack stack) {
        return MemoryCrystalItem.getMemoryList(stack).size();
    }

    public static CompoundTag getMemory(ItemStack stack, int memory) {
        ListTag memoryList = MemoryCrystalItem.getMemoryList(stack);
        return memoryList.m_128728_(memory);
    }

    public static boolean saveMemory(ItemStack stack, CompoundTag memory) {
        Item item = stack.m_41720_();
        if (item instanceof MemoryCrystalItem) {
            MemoryCrystalItem memoryCrystal = (MemoryCrystalItem)item;
            if (MemoryCrystalItem.getMemoryListSize(stack) >= memoryCrystal.memoryCapacity) {
                StargateJourney.LOGGER.info("Memory at maximum capacity");
                return false;
            }
            CompoundTag tag = stack.m_41784_();
            ListTag memoryList = MemoryCrystalItem.getMemoryList(stack);
            memoryList.add((Object)memory);
            tag.m_128365_(MEMORY_LIST, (Tag)memoryList);
            stack.m_41751_(tag);
            StargateJourney.LOGGER.info("Saved Memory");
            return true;
        }
        StargateJourney.LOGGER.info("Failed to save Memory");
        return false;
    }

    public static int[] getCoordinatesAt(ItemStack stack, int memory) {
        String memoryType;
        CompoundTag tag = MemoryCrystalItem.getMemory(stack, memory);
        if (tag.m_128425_(MEMORY_TYPE, 8) && MemoryType.valueOf(memoryType = tag.m_128461_(MEMORY_TYPE)) == MemoryType.COORDINATES) {
            int[] coordinates = tag.m_128465_(COORDINATES);
            StargateJourney.LOGGER.info("Found Coordinates at Memory Slot " + memory);
            return coordinates;
        }
        return new int[0];
    }

    public static boolean saveCoordinates(ItemStack stack, int[] coordinates) {
        CompoundTag memory = new CompoundTag();
        memory.m_128359_(MEMORY_TYPE, MemoryType.COORDINATES.toString().toUpperCase());
        memory.m_128385_(COORDINATES, coordinates);
        return MemoryCrystalItem.saveMemory(stack, memory);
    }

    public static int[] getAddressAt(ItemStack stack, int memory) {
        String memoryType;
        CompoundTag tag = MemoryCrystalItem.getMemory(stack, memory);
        if (tag.m_128425_(MEMORY_TYPE, 8) && MemoryType.valueOf(memoryType = tag.m_128461_(MEMORY_TYPE)) == MemoryType.ADDRESS) {
            int[] coordinates = tag.m_128465_(ADDRESS);
            StargateJourney.LOGGER.info("Found Address at Memory Slot " + memory);
            return coordinates;
        }
        return new int[0];
    }

    public static boolean saveAddress(ItemStack stack, int[] address) {
        CompoundTag memory = new CompoundTag();
        memory.m_128359_(MEMORY_TYPE, MemoryType.ADDRESS.toString().toUpperCase());
        memory.m_128385_(ADDRESS, address);
        return MemoryCrystalItem.saveMemory(stack, memory);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        block5: for (int i = 0; i < MemoryCrystalItem.getMemoryListSize(stack); ++i) {
            int[] address = MemoryCrystalItem.getAddressAt(stack, i);
            switch (address.length) {
                case 6: {
                    tooltipComponents.add((Component)Component.m_237113_((String)Address.addressIntArrayToString(address)).m_130940_(ChatFormatting.GOLD));
                    continue block5;
                }
                case 7: {
                    tooltipComponents.add((Component)Component.m_237113_((String)Address.addressIntArrayToString(address)).m_130940_(ChatFormatting.LIGHT_PURPLE));
                    continue block5;
                }
                case 8: {
                    tooltipComponents.add((Component)Component.m_237113_((String)Address.addressIntArrayToString(address)).m_130940_(ChatFormatting.AQUA));
                    continue block5;
                }
            }
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static enum MemoryType {
        ID,
        COORDINATES,
        ADDRESS;

    }
}

