/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.Wormhole;

public class Connection {
    private static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    private static final String EVENT_INCOMING_WORMHOLE = "stargate_incoming_wormhole";
    private static final String EVENT_OUTGOING_WORMHOLE = "stargate_outgoing_wormhole";
    private static final String EVENT_DISCONNECTED = "stargate_disconnected";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    private static final String DIALING_STARGATE = "DialingStargate";
    private static final String DIALED_STARGATE = "DialedStargate";
    private static final String USED = "Used";
    private static final String TIME_SINCE_LAST_TRAVELER = "TimeSinceLastTraveler";
    private static final String OPEN_TIME = "OpenTime";
    private static final String CONNECTION_TIME = "ConnectionTime";
    private static final String CONNECTION_TYPE = "ConnectionType";
    public static final int KAWOOSH_TICKS = 40;
    public static final int VORTEX_TICKS = 20;
    protected static int maxOpenTime = (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    protected static boolean energyBypassEnabled = (Boolean)CommonStargateConfig.enable_energy_bypass.get();
    protected static int energyBypassMultiplier = (Integer)CommonStargateConfig.energy_bypass_multiplier.get();
    protected static boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    protected final String uuid;
    protected final Stargate.ConnectionType connectionType;
    protected final AbstractStargateEntity dialingStargate;
    protected AbstractStargateEntity dialedStargate;
    protected boolean used = false;
    protected int openTime = 0;
    protected int connectionTime = 0;
    protected int timeSinceLastTraveler = 0;

    private Connection(String uuid, Stargate.ConnectionType connectionType, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate, boolean used, int openTime, int connectionTime, int timeSinceLastTraveler) {
        this.uuid = uuid;
        this.connectionType = connectionType;
        this.dialingStargate = dialingStargate;
        this.dialedStargate = dialedStargate;
        this.used = used;
        this.openTime = openTime;
        this.connectionTime = connectionTime;
        this.timeSinceLastTraveler = timeSinceLastTraveler;
    }

    private Connection(String uuid, Stargate.ConnectionType connectionType, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate) {
        this(uuid, connectionType, dialingStargate, dialedStargate, false, 0, 0, 0);
    }

    public static Connection create(Stargate.ConnectionType connectionType, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate) {
        String uuid = UUID.randomUUID().toString();
        if (dialingStargate != null && dialedStargate != null) {
            dialedStargate.resetStargate(Stargate.Feedback.INTERRUPTED_BY_INCOMING_CONNECTION);
            dialingStargate.setKawooshTickCount(0);
            dialingStargate.updateClient();
            dialedStargate.setKawooshTickCount(0);
            dialedStargate.updateClient();
            dialingStargate.connectStargate(uuid, true);
            dialedStargate.connectStargate(uuid, false);
            return new Connection(uuid, connectionType, dialingStargate, dialedStargate);
        }
        return null;
    }

    public void terminate(MinecraftServer server, Stargate.Feedback feedback) {
        if (this.dialingStargate != null) {
            this.dialingStargate.updateInterfaceBlocks(EVENT_DISCONNECTED, feedback.getCode());
            this.dialingStargate.resetStargate(feedback);
        }
        if (this.dialedStargate != null) {
            this.dialedStargate.updateInterfaceBlocks(EVENT_DISCONNECTED, feedback.getCode());
            this.dialedStargate.resetStargate(feedback);
        }
        StargateNetwork.get(server).removeConnection(server, this.uuid, feedback);
    }

    public void reroute(AbstractStargateEntity newDialedStargate) {
        if (this.dialedStargate != null) {
            this.dialedStargate.resetStargate(Stargate.Feedback.CONNECTION_REROUTED);
        }
        newDialedStargate.connectStargate(this.uuid, false);
    }

    public boolean isStargateValid(AbstractStargateEntity stargate) {
        if (stargate == null) {
            StargateJourney.LOGGER.info("Stargate does not exist");
            return false;
        }
        BlockPos stargatePos = stargate.m_58899_();
        Level stargateLevel = stargate.m_58904_();
        BlockEntity blockEntity = stargateLevel.m_7702_(stargatePos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity targetStargate = (AbstractStargateEntity)blockEntity;
            if (stargate.isConnected()) {
                return true;
            }
            StargateJourney.LOGGER.info("Stargate is not connected");
            return false;
        }
        return false;
    }

    public void tick(MinecraftServer server) {
        Stargate.ChevronLockSpeed chevronLockSpeed = this.dialedStargate.getGateType().getChevronLockSpeed();
        int waitMultiplier = chevronLockSpeed.getMultiplier();
        int chevronWaitTicks = chevronLockSpeed.getChevronWaitTicks();
        int kawooshStartTicks = chevronLockSpeed.getKawooshStartTicks();
        int maxKawooshTicks = kawooshStartTicks + 40;
        int maxOpenTicks = maxKawooshTicks + 20;
        if (!this.isStargateValid(this.dialingStargate) || !this.isStargateValid(this.dialedStargate)) {
            this.terminate(server, Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
            return;
        }
        this.increaseTicks(maxKawooshTicks, maxOpenTicks);
        int openTime = this.openTime - kawooshStartTicks;
        if (this.openTime < kawooshStartTicks) {
            this.playStargateOpenSound(this.dialingStargate, kawooshStartTicks, this.openTime);
            this.playStargateOpenSound(this.dialedStargate, kawooshStartTicks, this.openTime);
            int addressLenght = this.dialingStargate.getAddress().length;
            int[] dialingAddress = Address.addressStringToIntArray(this.dialingStargate.getConnectionAddress(addressLenght));
            this.dialedStargate.setEngagedChevrons(AbstractStargateEntity.getChevronConfiguration(addressLenght));
            AbstractStargateEntity abstractStargateEntity = this.dialedStargate;
            if (abstractStargateEntity instanceof PegasusStargateEntity) {
                PegasusStargateEntity pegasusStargate = (PegasusStargateEntity)abstractStargateEntity;
                if (pegasusStargate.currentSymbol < 36) {
                    pegasusStargate.currentSymbol = this.openTime / waitMultiplier;
                    pegasusStargate.updatePegasusStargate();
                }
            }
            if (this.openTime % chevronWaitTicks == 0) {
                int dialedAddressLength = this.dialedStargate.getAddress().length;
                if (dialedAddressLength < dialingAddress.length) {
                    if (this.openTime / chevronWaitTicks == 4 && addressLenght < 7) {
                        return;
                    }
                    if (this.openTime / chevronWaitTicks == 5 && addressLenght < 8) {
                        return;
                    }
                    this.dialedStargate.encodeChevron(dialingAddress[dialedAddressLength], true);
                } else {
                    this.dialedStargate.chevronSound(true);
                    this.dialedStargate.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.dialedStargate.getAddress().length + 1, 0, true);
                }
            }
            return;
        }
        if (this.openTime == kawooshStartTicks) {
            List<Integer> dialedAddress = Arrays.stream(this.dialedStargate.getAddress()).boxed().toList();
            this.dialedStargate.updateInterfaceBlocks(EVENT_INCOMING_WORMHOLE, dialedAddress);
            List<Integer> dialingAddress = Arrays.stream(this.dialingStargate.getAddress()).boxed().toList();
            this.dialingStargate.updateInterfaceBlocks(EVENT_OUTGOING_WORMHOLE, dialingAddress);
        }
        if (this.openTime < maxOpenTicks) {
            this.dialingStargate.doKawoosh(openTime);
            this.dialedStargate.doKawoosh(openTime);
        } else {
            this.dialingStargate.setKawooshTickCount(openTime);
            this.dialingStargate.updateClient();
            this.dialedStargate.setKawooshTickCount(openTime);
            this.dialedStargate.updateClient();
        }
        if (this.openTime < maxKawooshTicks) {
            return;
        }
        this.dialingStargate.idleWormholeSound();
        this.dialedStargate.idleWormholeSound();
        if (this.connectionTime >= maxOpenTime && !energyBypassEnabled) {
            this.terminate(server, Stargate.Feedback.EXCEEDED_CONNECTION_TIME);
            return;
        }
        if (requireEnergy) {
            long energyDraw = this.connectionType.getPowerDraw();
            long l = energyDraw = this.connectionTime >= maxOpenTime ? energyDraw * (long)energyBypassMultiplier : energyDraw;
            if (this.dialingStargate.getEnergyStored() < energyDraw && this.dialedStargate.getEnergyStored() < energyDraw) {
                this.terminate(server, Stargate.Feedback.RAN_OUT_OF_POWER);
                return;
            }
            if (this.dialedStargate.getEnergyStored() > this.dialingStargate.getEnergyStored()) {
                this.dialedStargate.depleteEnergy(energyDraw, false);
            } else {
                this.dialingStargate.depleteEnergy(energyDraw, false);
            }
        }
        if (this.used) {
            ++this.timeSinceLastTraveler;
        }
        this.doWormhole(this.dialingStargate.getWormhole(), this.dialingStargate, this.dialedStargate, Stargate.WormholeTravel.ENABLED);
        this.doWormhole(this.dialedStargate.getWormhole(), this.dialedStargate, this.dialingStargate, (Stargate.WormholeTravel)((Object)CommonStargateConfig.two_way_wormholes.get()));
        if ((this.dialingStargate.advancedProtocolsEnabled() || this.dialedStargate.advancedProtocolsEnabled()) && this.timeSinceLastTraveler >= 200) {
            this.terminate(server, Stargate.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
    }

    protected void playStargateOpenSound(AbstractStargateEntity stargate, int kawooshStartTicks, int ticks) {
        if (ticks == kawooshStartTicks - stargate.getOpenSoundLead()) {
            stargate.openWormholeSound();
        }
    }

    protected void increaseTicks(int maxKawooshTicks, int maxOpenTicks) {
        if (this.openTime < maxOpenTicks) {
            ++this.openTime;
        }
        if (this.openTime > maxKawooshTicks) {
            ++this.connectionTime;
        }
    }

    protected void doWormhole(Wormhole wormhole, AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, Stargate.WormholeTravel wormholeTravel) {
        BlockPos pos = initialStargate.getCenterPos();
        double yCenter = initialStargate instanceof TollanStargateEntity ? 0.0 : 0.5;
        Vec3 stargatePos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + yCenter, (double)pos.m_123343_() + 0.5);
        if (wormhole.findCandidates(initialStargate.m_58904_(), stargatePos, initialStargate.getDirection()) && this.used) {
            this.timeSinceLastTraveler = 0;
        }
        if (wormhole.wormholeEntities(initialStargate, targetStargate, wormholeTravel)) {
            this.used = true;
        }
    }

    public String getID() {
        return this.uuid;
    }

    public int getKawooshTime() {
        return this.openTime;
    }

    public int getOpenTime() {
        return this.connectionTime;
    }

    public int getTimeSinceLastTraveler() {
        return this.timeSinceLastTraveler;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(DIALING_STARGATE, (Tag)this.serializeStargate(this.dialingStargate));
        tag.m_128365_(DIALED_STARGATE, (Tag)this.serializeStargate(this.dialedStargate));
        tag.m_128405_(OPEN_TIME, this.openTime);
        tag.m_128405_(CONNECTION_TIME, this.connectionTime);
        tag.m_128405_(TIME_SINCE_LAST_TRAVELER, this.timeSinceLastTraveler);
        tag.m_128359_(CONNECTION_TYPE, this.connectionType.toString().toUpperCase());
        return tag;
    }

    protected CompoundTag serializeStargate(AbstractStargateEntity stargate) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(DIMENSION, stargate.m_58904_().m_46472_().m_135782_().toString());
        tag.m_128385_(COORDINATES, new int[]{stargate.m_58899_().m_123341_(), stargate.m_58899_().m_123342_(), stargate.m_58899_().m_123343_()});
        return tag;
    }

    public static Connection deserialize(MinecraftServer server, String uuid, CompoundTag tag) {
        Stargate.ConnectionType connectionType = Stargate.ConnectionType.valueOf(tag.m_128461_(CONNECTION_TYPE));
        AbstractStargateEntity dialingStargate = Connection.deserializeStargate(server, tag.m_128469_(DIALING_STARGATE));
        AbstractStargateEntity dialedStargate = Connection.deserializeStargate(server, tag.m_128469_(DIALED_STARGATE));
        boolean used = tag.m_128471_(USED);
        int openTime = tag.m_128451_(OPEN_TIME);
        int connectionTime = tag.m_128451_(CONNECTION_TIME);
        int timeSinceLastTraveler = tag.m_128451_(TIME_SINCE_LAST_TRAVELER);
        return new Connection(uuid, connectionType, dialingStargate, dialedStargate, used, openTime, connectionTime, timeSinceLastTraveler);
    }

    protected static AbstractStargateEntity deserializeStargate(MinecraftServer server, CompoundTag stargateInfo) {
        ResourceKey<Level> dimension = Conversion.stringToDimension(stargateInfo.m_128461_(DIMENSION));
        BlockPos pos = Conversion.intArrayToBlockPos(stargateInfo.m_128465_(COORDINATES));
        BlockEntity blockEntity = server.m_129880_(dimension).m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate;
        }
        return null;
    }
}

