/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class PointOfOrigin {
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation POINT_OF_ORIGIN_LOCATION = new ResourceLocation("sgjourney", "point_of_origin");
    public static final ResourceKey<Registry<PointOfOrigin>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)POINT_OF_ORIGIN_LOCATION);
    public static final Codec<ResourceKey<PointOfOrigin>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    public static final Codec<PointOfOrigin> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PointOfOrigin::getName), (App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(PointOfOrigin::getTexture), (App)Codec.BOOL.fieldOf("generates_randomly").forGetter(PointOfOrigin::generatesRandomly)).apply((Applicative)instance, PointOfOrigin::new));
    private final String name;
    private final ResourceLocation texture;
    private final boolean generatesRandomly;

    public PointOfOrigin(String name, ResourceLocation texture, boolean generatesRandomly) {
        this.name = name;
        this.texture = texture;
        this.generatesRandomly = generatesRandomly;
    }

    public String getName() {
        return this.name;
    }

    private ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation texture() {
        ResourceLocation path = this.getTexture();
        ResourceLocation texture = new ResourceLocation(path.m_135827_(), "textures/symbols/" + path.m_135815_());
        if (Minecraft.m_91087_().m_91098_().m_213713_(texture).isPresent()) {
            return texture;
        }
        return ERROR_LOCATION;
    }

    public boolean generatesRandomly() {
        return this.generatesRandomly;
    }

    public static ResourceKey<PointOfOrigin> getRandomPointOfOrigin(MinecraftServer server, long seed) {
        Random random = new Random(seed);
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        Set set = registry.m_6579_();
        ArrayList list = new ArrayList();
        set.forEach(pointOfOrigin -> {
            PointOfOrigin PoO = (PointOfOrigin)pointOfOrigin.getValue();
            if (PoO.generatesRandomly) {
                list.add((ResourceKey)pointOfOrigin.getKey());
            }
        });
        return (ResourceKey)list.get(random.nextInt(0, list.size()));
    }

    public static PointOfOrigin getPointOfOrigin(Level level, String name) {
        String[] split = name.split(":");
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (PointOfOrigin)registry.m_7745_(new ResourceLocation(split[0], split[1]));
    }
}

