/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Symbols;

public class SolarSystem {
    public static final ResourceKey<Registry<SolarSystem>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("sgjourney", "solar_system"));
    public static final Codec<ResourceKey<SolarSystem>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    private static final Codec<Pair<List<Integer>, Boolean>> ADDRESS = Codec.pair((Codec)Codec.INT.listOf().fieldOf("address").codec(), (Codec)Codec.BOOL.fieldOf("randomizable").codec());
    public static final Codec<SolarSystem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(SolarSystem::getName), (App)Symbols.RESOURCE_KEY_CODEC.fieldOf("symbols").forGetter(SolarSystem::getSymbols), (App)Codec.INT.fieldOf("symbol_prefix").forGetter(SolarSystem::getSymbolPrefix), (App)ADDRESS.fieldOf("extragalactic_address").forGetter(SolarSystem::getExtragalacticAddress), (App)PointOfOrigin.RESOURCE_KEY_CODEC.fieldOf("point_of_origin").forGetter(SolarSystem::getPointOfOrigin), (App)Level.f_46427_.listOf().fieldOf("dimensions").forGetter(SolarSystem::getDimensions)).apply((Applicative)instance, SolarSystem::new));
    private final String name;
    private final ResourceKey<Symbols> symbols;
    private final int symbolPrefix;
    private final Pair<List<Integer>, Boolean> extragalactic_address;
    private final ResourceKey<PointOfOrigin> point_of_origin;
    private final List<ResourceKey<Level>> dimensions;

    public SolarSystem(String name, ResourceKey<Symbols> symbols, int symbolPrefix, Pair<List<Integer>, Boolean> extragalactic_address, ResourceKey<PointOfOrigin> point_of_origin, List<ResourceKey<Level>> dimensions) {
        this.name = name;
        this.symbols = symbols;
        this.symbolPrefix = symbolPrefix;
        this.extragalactic_address = extragalactic_address;
        this.point_of_origin = point_of_origin;
        this.dimensions = dimensions;
    }

    public String getName() {
        return this.name;
    }

    public ResourceKey<Symbols> getSymbols() {
        return this.symbols;
    }

    public int getSymbolPrefix() {
        return this.symbolPrefix;
    }

    public Pair<List<Integer>, Boolean> getExtragalacticAddress() {
        return this.extragalactic_address;
    }

    public int[] getAddressArray() {
        return ((List)this.extragalactic_address.getFirst()).stream().mapToInt(integer -> integer).toArray();
    }

    public boolean isAddressRandomizable() {
        return (Boolean)this.extragalactic_address.getSecond();
    }

    public ResourceKey<PointOfOrigin> getPointOfOrigin() {
        return this.point_of_origin;
    }

    public List<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }

    public static SolarSystem getSolarSystem(Level level, String part1, String part2) {
        return SolarSystem.getSolarSystem(level, new ResourceLocation(part1, part2));
    }

    public static SolarSystem getSolarSystem(Level level, ResourceLocation solarSystem) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (SolarSystem)registry.m_7745_(solarSystem);
    }
}

