/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.stargate.StargatePart;

public class Stargate {
    public static final float STANDARD_THICKNESS = 9.0f;
    public static final float TOLLAN_THICKNESS = 5.0f;
    public static final float CLASSIC_THICKNESS = 8.0f;
    public static final float VERTICAL_CENTER_STANDARD_HEIGHT = 0.5f;
    public static final float VERTICAL_CENTER_TOLLAN_HEIGHT = 0.0f;
    public static final float HORIZONTAL_CENTER_STANDARD_HEIGHT = 0.28125f;
    public static final float HORIZONTAL_CENTER_TOLLAN_HEIGHT = 0.15625f;
    public static final float HORIZONTAL_CENTER_CLASSIC_HEIGHT = 0.25f;
    public static final int[] DIALING_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 6, 7, 8, 4, 5};
    public static final int[] DIALED_7_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 6, 7, 8, 4, 5};
    public static final int[] DIALED_8_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 5};
    public static final int[] DIALED_9_CHEVRON_CONFIGURATION = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static long systemWideConnectionCost = (Long)CommonStargateConfig.system_wide_connection_energy_cost.get();
    private static long interstellarConnectionCost = (Long)CommonStargateConfig.interstellar_connection_energy_cost.get();
    private static long intergalacticConnectionCost = (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    private static long systemWideConnectionDraw = (Long)CommonStargateConfig.system_wide_connection_energy_draw.get();
    private static long interstellarConnectionDraw = (Long)CommonStargateConfig.interstellar_connection_energy_draw.get();
    private static long intergalacticConnectionDraw = (Long)CommonStargateConfig.intergalactic_connection_energy_draw.get();

    private static Component createInfo(String feedback) {
        return Component.m_237115_((String)("message.sgjourney.stargate.info." + feedback));
    }

    private static Component createError(String feedback, boolean majorError) {
        MutableComponent component = Component.m_237115_((String)("message.sgjourney.stargate.error." + feedback));
        return majorError ? component.m_130940_(ChatFormatting.DARK_RED) : component.m_130940_(ChatFormatting.RED);
    }

    public static enum Feedback {
        NONE(0, FeedbackType.INFO, (Component)Component.m_237119_()),
        UNKNOWN_ERROR(-1, FeedbackType.ERROR, Stargate.createError("unknown", true)),
        SYMBOL_ENCODED(1, FeedbackType.INFO, Stargate.createInfo("symbol_encoded")),
        SYMBOL_IN_ADDRESS(-2, FeedbackType.ERROR, Stargate.createError("symbol_in_addres", false)),
        SYMBOL_OUT_OF_BOUNDS(-3, FeedbackType.ERROR, Stargate.createError("symbol_out_of_bounds", false)),
        CONNECTION_ESTABILISHED_SYSTEM_WIDE(2, FeedbackType.INFO, Stargate.createInfo("connection_estabilished.system_wide")),
        CONNECTION_ESTABILISHED_INTERSTELLAR(3, FeedbackType.INFO, Stargate.createInfo("connection_estabilished.interstellar")),
        CONNECTION_ESTABILISHED_INTERGALACTIC(4, FeedbackType.INFO, Stargate.createInfo("connection_estabilished.intergalactic")),
        INCOPLETE_ADDRESS(-4, FeedbackType.ERROR, Stargate.createError("incomplete_address", false)),
        INVALID_ADDRESS(-5, FeedbackType.ERROR, Stargate.createError("invalid_address", false)),
        NOT_ENOUGH_POWER(-6, FeedbackType.MAJOR_ERROR, Stargate.createError("not_enough_power", true)),
        SELF_OBSTRUCTED(-7, FeedbackType.MAJOR_ERROR, Stargate.createError("self_obstructed", true)),
        TARGET_OBSTRUCTED(-8, FeedbackType.ERROR, Stargate.createError("target_obstructed", false)),
        SELF_DIAL(-9, FeedbackType.MAJOR_ERROR, Stargate.createError("self_dial", true)),
        SAME_SYSTEM_DIAL(-10, FeedbackType.MAJOR_ERROR, Stargate.createError("same_system_dial", true)),
        ALREADY_CONNECTED(-11, FeedbackType.MAJOR_ERROR, Stargate.createError("already_connected", true)),
        NO_GALAXY(-12, FeedbackType.MAJOR_ERROR, Stargate.createError("no_galaxy", true)),
        NO_DIMENSIONS(-13, FeedbackType.MAJOR_ERROR, Stargate.createError("no_dimensions", true)),
        NO_STARGATES(-14, FeedbackType.MAJOR_ERROR, Stargate.createError("no_stargates", true)),
        CONNECTION_ENDED_BY_DISCONNECT(7, FeedbackType.INFO, Stargate.createInfo("connection_ended.disconnect")),
        CONNECTION_ENDED_BY_POINT_OF_ORIGIN(8, FeedbackType.INFO, Stargate.createInfo("connection_ended.point_of_origin")),
        CONNECTION_ENDED_BY_NETWORK(9, FeedbackType.INFO, Stargate.createInfo("connection_ended.stargate_network")),
        CONNECTION_ENDED_BY_AUTOCLOSE(10, FeedbackType.INFO, Stargate.createInfo("connection_ended.autoclose")),
        EXCEEDED_CONNECTION_TIME(-15, FeedbackType.ERROR, Stargate.createError("exceeded_connection_time", false)),
        RAN_OUT_OF_POWER(-16, FeedbackType.ERROR, Stargate.createError("ran_out_of_power", false)),
        CONNECTION_REROUTED(-17, FeedbackType.ERROR, Stargate.createError("connection_rerouted", false)),
        WRONG_DISCONNECT_SIDE(-18, FeedbackType.ERROR, Stargate.createError("wrong_disconnect_side", false)),
        STARGATE_DESTROYED(-19, FeedbackType.ERROR, Stargate.createError("stargate_destroyed", false)),
        COULD_NOT_REACH_TARGET_STARGATE(-20, FeedbackType.ERROR, Stargate.createError("could_not_reach_target_stargate", false)),
        INTERRUPTED_BY_INCOMING_CONNECTION(-21, FeedbackType.ERROR, Stargate.createError("interrupted_by_incoming_connection", false)),
        CHEVRON_RAISED(11, FeedbackType.INFO, Stargate.createInfo("chevron_raised")),
        CHEVRON_ALREADY_RAISED(-22, FeedbackType.ERROR, Stargate.createError("chevron_already_raised", false)),
        CHEVRON_ALREADY_LOWERED(-23, FeedbackType.ERROR, Stargate.createError("chevron_already_lowered", false));

        private int code;
        private final FeedbackType type;
        private final Component feedbackMessage;

        private Feedback(int code, FeedbackType type, Component feedbackMessage) {
            this.code = code;
            this.type = type;
            this.feedbackMessage = feedbackMessage;
        }

        public int getCode() {
            return this.code;
        }

        public Component getFeedbackMessage() {
            return this.feedbackMessage;
        }

        public boolean playFailSound() {
            return this.type.shouldPlaySound();
        }

        public boolean isError() {
            return this.type.isError();
        }
    }

    public static enum FeedbackType {
        INFO,
        ERROR,
        MAJOR_ERROR;


        public boolean isError() {
            return this == ERROR || this == MAJOR_ERROR;
        }

        public boolean shouldPlaySound() {
            return this == MAJOR_ERROR;
        }
    }

    public static enum FilterType {
        NONE,
        WHITELIST,
        BLACKLIST;

    }

    public static enum WormholeTravel {
        ENABLED,
        CREATIVE_ONLY,
        DISABLED;

    }

    public static enum ChevronLockSpeed {
        SLOW(3),
        MEDIUM(2),
        FAST(1);

        private int multiplier;

        private ChevronLockSpeed(int multiplier) {
            this.multiplier = multiplier;
        }

        public int getMultiplier() {
            return this.multiplier;
        }

        public int getChevronWaitTicks() {
            return this.multiplier * 4;
        }

        public int getKawooshStartTicks() {
            return this.getChevronWaitTicks() * 9;
        }
    }

    public static enum ConnectionType {
        SYSTEM_WIDE(systemWideConnectionCost, systemWideConnectionDraw),
        INTERSTELLAR(interstellarConnectionCost, interstellarConnectionDraw),
        INTERGALACTIC(intergalacticConnectionCost, intergalacticConnectionDraw);

        private long estabilishingPowerCost;
        private long powerDraw;

        private ConnectionType(long estabilishingPowerCost, long powerDraw) {
            this.estabilishingPowerCost = estabilishingPowerCost;
            this.powerDraw = powerDraw;
        }

        public long getEstabilishingPowerCost() {
            return this.estabilishingPowerCost;
        }

        public long getPowerDraw() {
            return this.powerDraw;
        }
    }

    public static enum Gen {
        NONE(0),
        GEN_1(1),
        GEN_2(2),
        GEN_3(3);

        private final int gen;

        private Gen(int gen) {
            this.gen = gen;
        }

        public int getGen() {
            return this.gen;
        }
    }

    public static enum Type {
        UNIVERSE(StargatePart.DEFAULT_PARTS, (ChevronLockSpeed)((Object)CommonStargateConfig.universe_chevron_lock_speed.get()), 0.5f, 0.28125f),
        MILKY_WAY(StargatePart.DEFAULT_PARTS, (ChevronLockSpeed)((Object)CommonStargateConfig.milky_way_chevron_lock_speed.get()), 0.5f, 0.28125f),
        PEGASUS(StargatePart.DEFAULT_PARTS, (ChevronLockSpeed)((Object)CommonStargateConfig.pegasus_chevron_lock_speed.get()), 0.5f, 0.28125f),
        CLASSIC(StargatePart.DEFAULT_PARTS, (ChevronLockSpeed)((Object)CommonStargateConfig.classic_chevron_lock_speed.get()), 0.5f, 0.25f),
        TOLLAN(StargatePart.TOLLAN_PARTS, (ChevronLockSpeed)((Object)CommonStargateConfig.tollan_chevron_lock_speed.get()), 0.0f, 0.15625f);

        private ArrayList<StargatePart> parts;
        private ChevronLockSpeed chevronLockSpeed;
        private float verticalCenterHeight;
        private float horizontalCenterHeight;

        private Type(ArrayList<StargatePart> parts, ChevronLockSpeed chevronLockSpeed, float verticalCenterHeight, float horizontalCenterHeight) {
            this.parts = parts;
            this.chevronLockSpeed = chevronLockSpeed;
            this.verticalCenterHeight = verticalCenterHeight;
            this.horizontalCenterHeight = horizontalCenterHeight;
        }

        public ArrayList<StargatePart> getParts() {
            return this.parts;
        }

        public float getVerticalCenterHeight() {
            return this.verticalCenterHeight;
        }

        public float getHorizontalCenterHeight() {
            return this.horizontalCenterHeight;
        }

        public ChevronLockSpeed getChevronLockSpeed() {
            return this.chevronLockSpeed;
        }
    }
}

