/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class SymbolSet {
    public static final ResourceLocation ERROR_LOCATION = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    public static final ResourceLocation SYMBOL_SET_LOCATION = new ResourceLocation("sgjourney", "symbol_set");
    public static final ResourceKey<Registry<SymbolSet>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SYMBOL_SET_LOCATION);
    public static final Codec<ResourceKey<SymbolSet>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    public static final Codec<SymbolSet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(SymbolSet::getName), (App)ResourceLocation.f_135803_.listOf().fieldOf("textures").forGetter(SymbolSet::getTextures)).apply((Applicative)instance, SymbolSet::new));
    private final String name;
    private final List<ResourceLocation> textures;

    public SymbolSet(String name, List<ResourceLocation> textures) {
        this.name = name;
        this.textures = textures;
    }

    public String getName() {
        return this.name;
    }

    public List<ResourceLocation> getTextures() {
        return this.textures;
    }

    public ResourceLocation texture(int i) {
        if (i >= this.textures.size() || i < 0) {
            return ERROR_LOCATION;
        }
        ResourceLocation path = this.textures.get(i);
        ResourceLocation texture = new ResourceLocation(path.m_135827_(), "textures/symbols/" + path.m_135815_());
        return texture;
    }

    public static SymbolSet getClientSymbolSet(ResourceKey<SymbolSet> symbols) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (SymbolSet)registry.m_6246_(symbols);
    }

    public static SymbolSet getSymbolSet(Level level, ResourceKey<SymbolSet> symbols) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (SymbolSet)registry.m_6246_(symbols);
    }

    public static SymbolSet getSymbolSet(Level level, String name) {
        String[] split = name.split(":");
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (SymbolSet)registry.m_7745_(new ResourceLocation(split[0], split[1]));
    }
}

