/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.misc.MatrixHelper;
import net.povstalec.sgjourney.common.misc.Orientation;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class Wormhole
implements ITeleporter {
    private static final String EVENT_DECONSTRUCTING_ENTITY = "stargate_deconstructing_entity";
    private static final String EVENT_RECONSTRUCTING_ENTITY = "stargate_reconstructing_entity";
    protected Map<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();
    protected List<Entity> localEntities = new ArrayList<Entity>();
    protected boolean used = false;

    public boolean hasCandidates() {
        return this.localEntities.isEmpty();
    }

    public boolean findCandidates(Level level, Vec3 centerPos, Direction direction) {
        AABB localBox = new AABB(centerPos.f_82479_ - 2.5, centerPos.f_82480_ - 2.5, centerPos.f_82481_ - 2.5, centerPos.f_82479_ + 2.5, centerPos.f_82480_ + 2.5, centerPos.f_82481_ + 2.5);
        this.localEntities = level.m_45976_(Entity.class, localBox);
        return !this.localEntities.isEmpty();
    }

    public boolean wormholeEntities(AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, Stargate.WormholeTravel twoWayWormhole) {
        this.used = false;
        Direction direction = initialStargate.getDirection();
        Direction orientationDirection = Orientation.getEffectiveDirection(direction, initialStargate.getOrientation());
        HashMap<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();
        this.localEntities.stream().forEach(traveler -> {
            if (this.entityLocations.containsKey(traveler.m_19879_())) {
                double axisMomentum;
                double travelerPos;
                double previousTravelerPos;
                int unitDistance;
                double previousX = this.entityLocations.get(traveler.m_19879_()).m_7096_();
                double previousY = this.entityLocations.get(traveler.m_19879_()).m_7098_();
                double previousZ = this.entityLocations.get(traveler.m_19879_()).m_7094_();
                Vec3 momentum = new Vec3(traveler.m_20185_() - previousX, traveler.m_20186_() - previousY, traveler.m_20189_() - previousZ);
                if (orientationDirection == null) {
                    return;
                }
                if (orientationDirection.m_122434_() == Direction.Axis.X) {
                    unitDistance = initialStargate.getCenterPos().m_123341_() - initialStargate.getCenterPos().m_121945_(orientationDirection).m_123341_();
                    previousTravelerPos = (double)initialStargate.getCenterPos().m_123341_() + 0.5 - previousX;
                    travelerPos = (double)initialStargate.getCenterPos().m_123341_() + 0.5 - traveler.m_20185_();
                    axisMomentum = momentum.m_7096_();
                } else if (orientationDirection.m_122434_() == Direction.Axis.Z) {
                    unitDistance = initialStargate.getCenterPos().m_123343_() - initialStargate.getCenterPos().m_121945_(orientationDirection).m_123343_();
                    previousTravelerPos = (double)initialStargate.getCenterPos().m_123343_() + 0.5 - previousZ;
                    travelerPos = (double)initialStargate.getCenterPos().m_123343_() + 0.5 - traveler.m_20189_();
                    axisMomentum = momentum.m_7094_();
                } else {
                    unitDistance = initialStargate.getCenterPos().m_123342_() - initialStargate.getCenterPos().m_121945_(orientationDirection).m_123342_();
                    previousTravelerPos = (double)initialStargate.getCenterPos().m_123342_() + initialStargate.getGateAddition() - previousY;
                    travelerPos = (double)initialStargate.getCenterPos().m_123342_() + initialStargate.getGateAddition() - traveler.m_20186_();
                    axisMomentum = momentum.m_7098_();
                }
                if (this.shouldWormhole(initialStargate, (Entity)traveler, unitDistance, previousTravelerPos, travelerPos, axisMomentum)) {
                    this.doWormhole(initialStargate, targetStargate, (Entity)traveler, momentum, twoWayWormhole);
                } else {
                    entityLocations.put(traveler.m_19879_(), new Vec3(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_()));
                }
            } else {
                entityLocations.put(traveler.m_19879_(), new Vec3(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_()));
            }
        });
        this.entityLocations = entityLocations;
        return this.used;
    }

    public boolean shouldWormhole(AbstractStargateEntity initialStargate, Entity traveler, int unitDistance, double previousTravelerPos, double travelerPos, double axisMomentum) {
        Vec3 travelerVector;
        Vec3 centerVector = initialStargate.getCenter();
        if (centerVector.m_82554_(travelerVector = traveler.m_20191_().m_82399_()) > 2.5) {
            return false;
        }
        previousTravelerPos = this.reverseIfNeeded(unitDistance > 0, previousTravelerPos);
        travelerPos = this.reverseIfNeeded(unitDistance > 0, travelerPos);
        axisMomentum = this.reverseIfNeeded(unitDistance > 0, axisMomentum);
        return previousTravelerPos < 0.0 && travelerPos >= 0.0 && axisMomentum < 0.0;
    }

    public double reverseIfNeeded(boolean shouldReverse, double number) {
        return shouldReverse ? -number : number;
    }

    public void doWormhole(AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, Entity traveler, Vec3 momentum, Stargate.WormholeTravel twoWayWormhole) {
        Player player;
        Level level = traveler.m_9236_();
        Wormhole.playWormholeSound(level, traveler);
        if (level.m_5776_()) {
            return;
        }
        if (twoWayWormhole == Stargate.WormholeTravel.ENABLED || traveler instanceof Player && (player = (Player)traveler).m_7500_() && twoWayWormhole == Stargate.WormholeTravel.CREATIVE_ONLY) {
            ServerLevel destinationlevel = (ServerLevel)targetStargate.m_58904_();
            if (destinationlevel == null) {
                System.out.println("Dimension is null");
                return;
            }
            if (targetStargate != null) {
                Direction initialDirection = initialStargate.getDirection();
                Orientation initialOrientation = initialStargate.getOrientation();
                Direction destinationDirection = targetStargate.getDirection();
                Orientation destinationOrientation = targetStargate.getOrientation();
                double initialYAddition = initialStargate.getGateAddition();
                double destinationYAddition = targetStargate.getGateAddition();
                Vec3 position = Wormhole.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, new Vec3(traveler.m_20185_() - ((double)initialStargate.getCenterPos().m_123341_() + 0.5), traveler.m_20186_() - ((double)initialStargate.getCenterPos().m_123342_() + initialYAddition), traveler.m_20189_() - ((double)initialStargate.getCenterPos().m_123343_() + 0.5)));
                if (traveler instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)traveler;
                    this.deconstructEvent(initialStargate, (Entity)player2, false);
                    player2.m_8999_(destinationlevel, (double)targetStargate.getCenterPos().m_123341_() + 0.5 + position.m_7096_(), (double)targetStargate.getCenterPos().m_123342_() + destinationYAddition + position.m_7098_(), (double)targetStargate.getCenterPos().m_123343_() + 0.5 + position.m_7094_(), Wormhole.preserveYRot(initialDirection, destinationDirection, player2.m_146908_()), player2.m_146909_());
                    player2.m_20256_(Wormhole.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, momentum));
                    player2.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(traveler));
                    Wormhole.playWormholeSound(level, (Entity)player2);
                    this.reconstructEvent(targetStargate, (Entity)player2);
                } else {
                    this.deconstructEvent(initialStargate, traveler, false);
                    Entity newTraveler = traveler;
                    if ((ServerLevel)level != destinationlevel) {
                        newTraveler = traveler.changeDimension(destinationlevel, (ITeleporter)this);
                    }
                    newTraveler.m_7678_((double)targetStargate.getCenterPos().m_123341_() + 0.5 + position.m_7096_(), (double)targetStargate.getCenterPos().m_123342_() + destinationYAddition + position.m_7098_(), (double)targetStargate.getCenterPos().m_123343_() + 0.5 + position.m_7094_(), Wormhole.preserveYRot(initialDirection, destinationDirection, traveler.m_146908_()), traveler.m_146909_());
                    newTraveler.m_20256_(Wormhole.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, momentum));
                    Wormhole.playWormholeSound(level, newTraveler);
                    this.reconstructEvent(targetStargate, newTraveler);
                }
                this.used = true;
            }
        } else if (((Boolean)CommonStargateConfig.reverse_wormhole_kills.get()).booleanValue()) {
            Player player3;
            if (traveler instanceof Player && (player3 = (Player)traveler).m_7500_()) {
                player3.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.one_way_wormhole").m_130940_(ChatFormatting.DARK_RED), true);
            } else {
                this.deconstructEvent(initialStargate, traveler, true);
                traveler.m_6074_();
            }
        }
    }

    private void deconstructEvent(AbstractStargateEntity initialStargate, Entity traveler, boolean disintegrated) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        initialStargate.updateInterfaceBlocks(EVENT_DECONSTRUCTING_ENTITY, travelerType, displayName, uuid, disintegrated);
    }

    private void reconstructEvent(AbstractStargateEntity targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        targetStargate.updateInterfaceBlocks(EVENT_RECONSTRUCTING_ENTITY, travelerType, displayName, uuid);
    }

    private static Vec3 preserveRelative(Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation, Vec3 initial) {
        return MatrixHelper.rotateVector(initial, initialDirection, initialOrientation, destinationDirection, destinationOrientation);
    }

    private static float preserveYRot(Direction initialDirection, Direction destinationDirection, float yRot) {
        float initialStargateDirection = Mth.m_14177_((float)initialDirection.m_122435_());
        float destinationStargateDirection = Mth.m_14177_((float)destinationDirection.m_122435_());
        float relativeRot = destinationStargateDirection - initialStargateDirection;
        yRot = yRot + relativeRot + 180.0f;
        return yRot;
    }

    private static void playWormholeSound(Level level, Entity traveler) {
        level.m_5594_((Player)null, traveler.m_20183_(), (SoundEvent)SoundInit.WORMHOLE_ENTER.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
    }
}

