/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.datafixerapi.DataFixesInternals;
import com.railwayteam.railways.base.datafixers.UpsideDownMonoBogeyFix;
import com.railwayteam.railways.config.CRConfigs;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import net.minecraft.SharedConstants;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class CRDataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;

    public static void register() {
        Railways.LOGGER.info("Registering data fixers");
        if (CRConfigs.getDisableDatafixer()) {
            Railways.LOGGER.warn("SKIPPING DATAFIXER REGISTRATION DUE TO CONFIG");
            return;
        }
        DataFixesInternals api = DataFixesInternals.get();
        DataFixerBuilder builder = new DataFixerBuilder(1);
        CRDataFixers.addFixers(builder);
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Railways Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        api.registerFixer(1, builder.buildOptimized(SharedConstants.f_273866_, (Executor)executor));
    }

    private static void addFixers(DataFixerBuilder builder) {
        builder.addSchema(0, DataFixesInternals.BASE_SCHEMA);
        Schema schemaV1 = builder.addSchema(1, SAME_NAMESPACED);
        builder.addFixer((DataFix)new UpsideDownMonoBogeyFix(schemaV1, "Merge railways:mono_bogey_upside_down into railways:mono_bogey[upside_down=true]"));
    }
}

