/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMPackets;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class LabelGunItem
extends Item {
    public LabelGunItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void setActiveLabel(ItemStack gun, String label) {
        if (label.isEmpty()) {
            return;
        }
        LabelPositionHolder.from(gun).addReferencedLabel(label).save(gun);
        gun.m_41784_().m_128359_("sfm:active_label", label);
    }

    public static String getActiveLabel(ItemStack stack) {
        return !stack.m_41782_() ? "" : stack.m_41783_().m_128461_("sfm:active_label");
    }

    public static String getNextLabel(ItemStack gun, int change) {
        List labels = LabelPositionHolder.from(gun).get().keySet().stream().sorted(Comparator.naturalOrder()).toList();
        if (labels.isEmpty()) {
            return "";
        }
        String currentLabel = LabelGunItem.getActiveLabel(gun);
        int currentLabelIndex = 0;
        for (int i = 0; i < labels.size(); ++i) {
            if (!((String)labels.get(i)).equals(currentLabel)) continue;
            currentLabelIndex = i;
            break;
        }
        int nextLabelIndex = currentLabelIndex + change;
        nextLabelIndex = (nextLabelIndex % labels.size() + labels.size()) % labels.size();
        return (String)labels.get(nextLabelIndex);
    }

    public InteractionResult onItemUseFirst(ItemStack gun, UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (level.f_46443_ && ctx.m_43723_() != null) {
            SFMPackets.LABEL_GUN_ITEM_CHANNEL.sendToServer((Object)new ServerboundLabelGunUsePacket(ctx.m_43724_(), ctx.m_8083_(), Screen.m_96637_(), ctx.m_43723_().m_6144_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        lines.add((Component)Constants.LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_1.getComponent().m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Constants.LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_2.getComponent().m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Constants.LocalizationKeys.LABEL_GUN_ITEM_TOOLTIP_3.getComponent().m_130940_(ChatFormatting.GRAY));
        lines.addAll(LabelPositionHolder.from(stack).asHoverText());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            ClientStuff.showLabelGunScreen(stack, hand);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public Component m_7626_(ItemStack stack) {
        String name = LabelGunItem.getActiveLabel(stack);
        if (name.isEmpty()) {
            return super.m_7626_(stack);
        }
        return Constants.LocalizationKeys.LABEL_GUN_ITEM_NAME_WITH_LABEL.getComponent(name).m_130940_(ChatFormatting.AQUA);
    }
}

