/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import javax.annotation.Nullable;

public class LimitedInputSlot<STACK, ITEM, CAP> {
    public ResourceType<STACK, ITEM, CAP> type;
    public CAP handler;
    public int slot;
    public InputResourceTracker<STACK, ITEM, CAP> tracker;
    private boolean done = false;
    @Nullable
    private STACK extractSimulateCache = null;

    public LimitedInputSlot(CAP handler, int slot, InputResourceTracker<STACK, ITEM, CAP> tracker) {
        this.init(handler, slot, tracker);
    }

    public boolean isDone() {
        if (this.done) {
            return true;
        }
        if (this.tracker.isDone()) {
            return true;
        }
        STACK stack = this.peekExtractPotential();
        if (this.type.isEmpty(stack)) {
            return true;
        }
        return !this.tracker.test(stack);
    }

    public void setDone() {
        this.done = true;
    }

    public STACK extract(long amount) {
        this.extractSimulateCache = null;
        return this.type.extract(this.handler, this.slot, amount, false);
    }

    public STACK peekExtractPotential() {
        if (this.extractSimulateCache == null) {
            this.extractSimulateCache = this.type.extract(this.handler, this.slot, Long.MAX_VALUE, true);
        }
        return this.extractSimulateCache;
    }

    public void init(CAP handler, int slot, InputResourceTracker<STACK, ITEM, CAP> tracker) {
        this.done = false;
        this.extractSimulateCache = null;
        this.handler = handler;
        this.tracker = tracker;
        this.slot = slot;
        this.type = tracker.getResourceLimit().resourceId().getResourceType();
        assert (this.type != null);
    }
}

