/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackTooltipComponent
implements TooltipComponent {
    protected ItemStackHandler inventory = new ItemStackHandler(54);
    protected ItemStackHandler craftingInventory = new ItemStackHandler(9);
    protected FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    protected FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    protected ItemStack stack;
    protected Tiers.Tier tier = Tiers.LEATHER;

    public BackpackTooltipComponent(ItemStack stack) {
        this.stack = stack;
        this.loadTier(stack.m_41783_());
        this.loadComponentData(stack.m_41783_());
    }

    public void loadTier(CompoundTag compound) {
        this.tier = compound != null ? Tiers.of(compound.m_128451_("Tier")) : Tiers.LEATHER;
    }

    public void loadComponentData(CompoundTag compound) {
        if (compound == null) {
            return;
        }
        this.loadInventory(compound);
        this.loadCraftingInventory(compound);
        this.loadLeftTank(compound);
        this.loadRightTank(compound);
    }

    public void loadInventory(CompoundTag compound) {
        if (compound.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        }
    }

    public void loadCraftingInventory(CompoundTag compound) {
        if (compound.m_128441_("CraftingInventory")) {
            this.craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
        }
    }

    public void loadLeftTank(CompoundTag compound) {
        if (compound.m_128441_("LeftTank")) {
            this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        }
    }

    public void loadRightTank(CompoundTag compound) {
        if (compound.m_128441_("RightTank")) {
            this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
        }
    }

    public boolean hasToolInSlot(Tiers.SlotType type) {
        return !this.inventory.getStackInSlot(this.tier.getSlotIndex(type)).m_41619_();
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            public FluidTank readFromNBT(CompoundTag nbt) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setCapacity(BackpackTooltipComponent.this.tier.getTankCapacity());
                this.setFluid(fluid);
                return this;
            }
        };
    }
}

