/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientBackpackTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation LEATHER_TOOLTIP_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/tooltip/leather_travelers_backpack_tooltip.png");
    public static final ResourceLocation IRON_TOOLTIP_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/tooltip/iron_travelers_backpack_tooltip.png");
    public static final ResourceLocation GOLD_TOOLTIP_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/tooltip/gold_travelers_backpack_tooltip.png");
    public static final ResourceLocation DIAMOND_TOOLTIP_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/tooltip/diamond_travelers_backpack_tooltip.png");
    public static final ResourceLocation NETHERITE_TOOLTIP_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/tooltip/netherite_travelers_backpack_tooltip.png");
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public int m_142103_() {
        if (BackpackUtils.isCtrlPressed() && this.component.stack.m_41782_()) {
            return this.getTextureHeight();
        }
        return 0;
    }

    public int m_142069_(Font font) {
        if (BackpackUtils.isCtrlPressed() && this.component.stack.m_41782_()) {
            return 229;
        }
        return 0;
    }

    public void m_142440_(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
    }

    public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        if (!this.component.stack.m_41782_()) {
            return;
        }
        if (BackpackUtils.isCtrlPressed()) {
            int i;
            this.blit(pGuiGraphics, pX, pY);
            int slot = 0;
            boolean isEmpty = true;
            if (!ContainerUtils.isEmpty(this.component.inventory)) {
                for (int j = 0; j < 3 + this.component.tier.getOrdinal(); ++j) {
                    for (int i2 = 0; i2 < 9; ++i2) {
                        if (this.applyGridConditions(i2, j)) continue;
                        int i1 = pX + i2 * 18 + 43;
                        int j1 = pY + j * 18 + 6;
                        this.renderItemInSlot(i1, j1, slot, pFont, pGuiGraphics, false);
                        ++slot;
                    }
                }
                isEmpty = false;
            }
            int craftingSlot = 0;
            if (!ContainerUtils.isEmpty(this.component.craftingInventory)) {
                for (int j = 0; j < 3; ++j) {
                    for (i = 0; i < 3; ++i) {
                        int i1 = pX + i * 18 + 151;
                        int j1 = pY + j * 18 + this.component.tier.getOrdinal() * 18 + 6;
                        this.renderItemInSlot(i1, j1, craftingSlot, pFont, pGuiGraphics, true);
                        ++craftingSlot;
                    }
                }
            }
            int tool = 0;
            if (!isEmpty && this.component.hasToolInSlot(Tiers.SlotType.TOOL_FIRST)) {
                for (i = this.component.tier.getSlotIndex(Tiers.SlotType.TOOL_FIRST); i <= this.component.tier.getSlotIndex(Tiers.SlotType.TOOL_FIRST) + this.component.tier.getToolSlots() - 1; ++i) {
                    this.renderItemInSlot(pX + 5, pY + tool * 18 + 6, i, pFont, pGuiGraphics, false);
                    ++tool;
                }
            }
            if (!this.component.leftTank.isEmpty()) {
                RenderUtils.renderScreenTank(pGuiGraphics, this.component.leftTank, pX + 25, pY + 7, 1000.0, this.component.tier.getTankRenderPos(), 16.0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (!this.component.rightTank.isEmpty()) {
                RenderUtils.renderScreenTank(pGuiGraphics, this.component.rightTank, pX + 207, pY + 7, 1000.0, this.component.tier.getTankRenderPos(), 16.0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void renderItemInSlot(int pX, int pY, int slot, Font pFont, GuiGraphics guiGraphics, boolean isCrafting) {
        ItemStack stack = ItemStack.f_41583_;
        if (!isCrafting) {
            if (slot > this.component.tier.getStorageSlots() + this.component.tier.getToolSlots()) {
                return;
            }
            stack = this.component.inventory.getStackInSlot(slot);
        } else {
            stack = this.component.craftingInventory.getStackInSlot(slot);
        }
        if (stack.m_41619_()) {
            return;
        }
        guiGraphics.m_280203_(stack, pX + 1, pY + 1);
        guiGraphics.m_280370_(pFont, stack, pX + 1, pY + 1);
    }

    private void blit(GuiGraphics guiGraphics, int pX, int pY) {
        guiGraphics.m_280163_(this.getTooltipTexture(), pX, pY, 0.0f, 0.0f, 229, this.getTextureHeight(), 256, 256);
    }

    private boolean applyGridConditions(int i, int j) {
        if (this.component.tier == Tiers.LEATHER && i > 5) {
            return true;
        }
        if (this.component.tier == Tiers.IRON && j > 0 && i > 5) {
            return true;
        }
        if (this.component.tier == Tiers.GOLD && j > 1 && i > 5) {
            return true;
        }
        if (this.component.tier == Tiers.DIAMOND && j > 2 && i > 5) {
            return true;
        }
        return this.component.tier == Tiers.NETHERITE && j > 3 && i > 5;
    }

    public ResourceLocation getTooltipTexture() {
        if (this.component.tier == Tiers.LEATHER) {
            return LEATHER_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.IRON) {
            return IRON_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.GOLD) {
            return GOLD_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.DIAMOND) {
            return DIAMOND_TOOLTIP_TRAVELERS_BACKPACK;
        }
        if (this.component.tier == Tiers.NETHERITE) {
            return NETHERITE_TOOLTIP_TRAVELERS_BACKPACK;
        }
        return LEATHER_TOOLTIP_TRAVELERS_BACKPACK;
    }

    public int getTextureHeight() {
        if (this.component.tier == Tiers.LEATHER) {
            return 67;
        }
        if (this.component.tier == Tiers.IRON) {
            return 85;
        }
        if (this.component.tier == Tiers.GOLD) {
            return 103;
        }
        if (this.component.tier == Tiers.DIAMOND) {
            return 121;
        }
        if (this.component.tier == Tiers.NETHERITE) {
            return 139;
        }
        return 67;
    }
}

