/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class UnpackBackpackCommand {
    public UnpackBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unpack").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(source -> this.unpackTargetBlockEntity((CommandSourceStack)source.getSource(), BlockPosArgument.m_118242_((CommandContext)source, (String)"pos"))))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(source -> this.unpackTargetInventory((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int unpackTargetBlockEntity(CommandSourceStack source, BlockPos blockPos) throws CommandSyntaxException {
        if (source.m_81372_().m_7702_(blockPos) instanceof TravelersBackpackBlockEntity) {
            ItemStack stack;
            int i;
            TravelersBackpackBlockEntity inv = (TravelersBackpackBlockEntity)source.m_81372_().m_7702_(blockPos);
            NonNullList stacks = NonNullList.m_122779_();
            for (i = 0; i < inv.getHandler().getSlots(); ++i) {
                stack = inv.getHandler().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                stacks.add((Object)stack);
                inv.getHandler().setStackInSlot(i, ItemStack.f_41583_);
            }
            for (i = 0; i < inv.getCraftingGridHandler().getSlots(); ++i) {
                stack = inv.getCraftingGridHandler().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                stacks.add((Object)stack);
                inv.getCraftingGridHandler().setStackInSlot(i, ItemStack.f_41583_);
            }
            if (stacks.size() > 0) {
                if (!source.m_81372_().f_46443_) {
                    Containers.m_19010_((Level)source.m_81372_(), (BlockPos)blockPos, (NonNullList)stacks);
                }
                source.m_288197_(() -> Component.m_237113_((String)("Dropping contents of backpack placed at " + blockPos.m_123344_())), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("There's no contents in backpack at coordinates " + blockPos.m_123344_())));
            return -1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("There's no backpack at coordinates " + blockPos.m_123344_())));
        return -1;
    }

    public int unpackTargetInventory(CommandSourceStack source, ServerPlayer serverPlayer) throws CommandSyntaxException {
        boolean hasBackpack = CapabilityUtils.isWearingBackpack((Player)serverPlayer);
        if (hasBackpack) {
            AtomicBoolean flag = new AtomicBoolean(false);
            CapabilityUtils.getCapability((Player)serverPlayer).ifPresent(cap -> {
                ItemStack stack;
                int i;
                NonNullList stacks = NonNullList.m_122779_();
                for (i = 0; i < cap.getContainer().getHandler().getSlots(); ++i) {
                    stack = cap.getContainer().getHandler().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    stacks.add((Object)stack);
                    cap.getContainer().getHandler().setStackInSlot(i, ItemStack.f_41583_);
                }
                for (i = 0; i < cap.getContainer().getCraftingGridHandler().getSlots(); ++i) {
                    stack = cap.getContainer().getCraftingGridHandler().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    stacks.add((Object)stack);
                    cap.getContainer().getCraftingGridHandler().setStackInSlot(i, ItemStack.f_41583_);
                }
                if (stacks.size() > 0 && !source.m_81372_().f_46443_) {
                    Containers.m_19010_((Level)source.m_81372_(), (BlockPos)serverPlayer.m_20183_(), (NonNullList)stacks);
                    flag.set(true);
                }
            });
            if (flag.get()) {
                source.m_288197_(() -> Component.m_237113_((String)("Dropping contents of " + serverPlayer.m_5446_().getString() + " backpack at " + serverPlayer.m_20183_().m_123344_())), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("There's no contents in " + serverPlayer.m_5446_().getString() + " backpack")));
            return -1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Player " + serverPlayer.m_5446_().getString() + " is not wearing backpack")));
        return -1;
    }
}

