/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSettingsPacket {
    private final byte screenID;
    private final byte dataArray;
    private final int place;
    private final byte value;

    public ServerboundSettingsPacket(byte screenID, byte dataArray, int place, byte value) {
        this.screenID = screenID;
        this.dataArray = dataArray;
        this.place = place;
        this.value = value;
    }

    public static ServerboundSettingsPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        byte dataArray = buffer.readByte();
        int place = buffer.readInt();
        byte value = buffer.readByte();
        return new ServerboundSettingsPacket(screenID, dataArray, place, value);
    }

    public static void encode(ServerboundSettingsPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.dataArray);
        buffer.writeInt(message.place);
        buffer.writeByte((int)message.value);
    }

    public static void handle(ServerboundSettingsPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                SettingsManager manager;
                if (message.screenID == 2) {
                    manager = CapabilityUtils.getBackpackInv((Player)serverPlayer).getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemMenu)serverPlayer.f_36096_).container.getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackBlockEntityMenu)serverPlayer.f_36096_).container.getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

