/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.twigs.block.enums;

import com.ninni.twigs.TwigsProperties;
import com.ninni.twigs.block.FallingBlockWithEntity;
import com.ninni.twigs.block.entity.SiltPotBlockEntity;
import com.ninni.twigs.registry.TwigsBlockEntityType;
import com.ninni.twigs.registry.TwigsSoundEvents;
import com.ninni.twigs.stat.TwigsStats;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SiltPotBlock
extends FallingBlockWithEntity
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty FILLED = TwigsProperties.FILLED;
    protected static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SiltPotBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public SoundType m_49962_(BlockState state) {
        return (Boolean)state.m_61143_((Property)FILLED) != false ? TwigsSoundEvents.SILT_POT_FILLED : TwigsSoundEvents.SILT_POT;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem blockItem;
        Item item;
        BlockEntity blockEntity = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (hit.m_82434_() == Direction.UP && (item = stack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof FlowerBlock && ((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            blockItem.m_40576_(new BlockPlaceContext(player, hand, stack, hit));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (((Boolean)state.m_61143_((Property)FILLED)).booleanValue() && stack.m_41720_() instanceof ShovelItem) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)), 4);
            if (!player.m_150110_().f_35937_) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            }
            if (level.f_46443_) {
                level.m_5594_(player, pos, SoundEvents.f_144206_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else if (!((Boolean)state.m_61143_((Property)FILLED)).booleanValue() && stack.m_150930_(Blocks.f_152549_.m_5456_())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)), 4);
            if (level.f_46443_) {
                level.m_5594_(player, pos, SoundEvents.f_144209_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        } else if (blockEntity instanceof SiltPotBlockEntity && !((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5893_((MenuProvider)((SiltPotBlockEntity)blockEntity));
            player.m_36220_(TwigsStats.OPEN_SILT_POT);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        SiltPotBlockEntity blockEntity = (SiltPotBlockEntity)((BlockEntityType)TwigsBlockEntityType.SILT_POT.get()).m_155264_(pos, fallingBlockEntity.m_31980_());
        assert (blockEntity != null);
        blockEntity.m_142466_(fallingBlockEntity.f_31944_);
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)blockEntity);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!moved && blockEntity instanceof Container) {
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
            level.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof SiltPotBlockEntity) {
            ((SiltPotBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SiltPotBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    @Override
    protected void configureFallingBlockEntity(FallingBlockEntity entity) {
        super.configureFallingBlockEntity(entity);
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FILLED});
    }
}

