/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.wireless;

import de.melanx.utilitix.content.wireless.BesrLinkedRepeater;
import de.melanx.utilitix.content.wireless.ItemLinkedCrystal;
import de.melanx.utilitix.content.wireless.TileLinkedRepeater;
import de.melanx.utilitix.content.wireless.WirelessStorage;
import de.melanx.utilitix.registration.ModItems;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.moddingx.libx.base.tile.BlockBE;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.SetupContext;

public class BlockLinkedRepeater
extends BlockBE<TileLinkedRepeater> {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public BlockLinkedRepeater(ModX mod, BlockBehaviour.Properties properties) {
        this(mod, properties, new Item.Properties());
    }

    public BlockLinkedRepeater(ModX mod, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, TileLinkedRepeater.class, properties, itemProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61433_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(SetupContext ctx) {
        BlockEntityRenderers.m_173590_((BlockEntityType)this.getBlockEntityType(), context -> new BesrLinkedRepeater());
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61433_, BlockStateProperties.f_61426_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61433_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(0));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!level.f_46443_) {
            TileLinkedRepeater tile = (TileLinkedRepeater)this.getBlockEntity(level, pos);
            ItemStack link = tile.getLink();
            if (!link.m_41619_()) {
                ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, link.m_41777_());
                level.m_7967_((Entity)entity);
                tile.setLink(ItemStack.f_41583_);
            } else {
                ItemStack held = player.m_21120_(hand);
                if (!held.m_41619_() && held.m_41720_() == ModItems.linkedCrystal && ItemLinkedCrystal.getId(held) != null) {
                    tile.setLink(held.m_41620_(1));
                    player.m_21008_(hand, held);
                } else {
                    return InteractionResult.FAIL;
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
            TileLinkedRepeater tile = (TileLinkedRepeater)this.getBlockEntity(level, pos);
            WirelessStorage.get(level).remove(level, tile.getLinkId(), GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
            ItemStack stack = tile.getLink();
            if (!stack.m_41619_()) {
                ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, stack.m_41777_());
                level.m_7967_((Entity)entity);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
        this.notifyNeighbors(level, pos, state);
    }

    protected boolean shouldDropInventory(Level level, BlockPos pos, BlockState state) {
        return false;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return BlockLinkedRepeater.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    public int m_6376_(BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.m_60746_(blockAccess, pos, side);
    }

    public int m_6378_(BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.m_61143_((Property)BlockStateProperties.f_61374_) == side ? (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61426_) : 0;
    }

    public void m_6861_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (state.m_60710_((LevelReader)level, pos)) {
            this.updateState(level, pos, state);
        } else {
            level.m_7471_(pos, false);
            for (Direction direction : Direction.values()) {
                level.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.m_7899_(state) && direction != null && direction.m_122434_() == ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_();
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (BlockLinkedRepeater.inputStrength(level, state, pos) != (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        this.notifyNeighbors(level, pos, state);
    }

    private void updateState(Level level, BlockPos pos, BlockState state) {
        if (!level.m_183326_().m_183588_(pos, (Object)this)) {
            TickPriority priority = TickPriority.HIGH;
            Block targetBlock = level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).m_60734_();
            if (targetBlock instanceof DiodeBlock || targetBlock instanceof BlockLinkedRepeater) {
                priority = TickPriority.EXTREMELY_HIGH;
            }
            level.m_186464_(pos, (Block)this, 1, priority);
        }
    }

    public void m_213897_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        UUID uid = ((TileLinkedRepeater)this.getBlockEntity((Level)level, pos)).getLinkId();
        int input = BlockLinkedRepeater.inputStrength((Level)level, state, pos);
        if (uid != null) {
            WirelessStorage storage = WirelessStorage.get((Level)level);
            storage.update((Level)level, uid, GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos), input);
            input = storage.getStrength(uid);
        }
        if (input != (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(input)), 2);
        }
    }

    private void notifyNeighbors(Level level, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos target = pos.m_121945_(face.m_122424_());
        if (ForgeEventFactory.onNeighborNotify((Level)level, (BlockPos)pos, (BlockState)level.m_8055_(pos), EnumSet.of(face.m_122424_()), (boolean)false).isCanceled()) {
            return;
        }
        level.m_46586_(target, (Block)this, pos);
        level.m_46590_(target, (Block)this, face);
    }

    public static int inputStrength(Level level, BlockState state, BlockPos pos) {
        Direction face = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos targetPos = pos.m_121945_(face);
        int i = level.m_277185_(targetPos, face);
        if (i >= 15) {
            return i;
        }
        BlockState targetState = level.m_8055_(targetPos);
        return Math.max(i, targetState.m_60713_(Blocks.f_50088_) ? (Integer)targetState.m_61143_((Property)BlockStateProperties.f_61426_) : 0);
    }
}

