/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.utilitix.recipe.EffectTransformer;
import de.melanx.utilitix.registration.ModRecipes;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class BreweryRecipeBuilder {
    @Nullable
    private Ingredient input;
    @Nullable
    private EffectTransformer transformer;

    private BreweryRecipeBuilder() {
    }

    public static BreweryRecipeBuilder breweryRecipe() {
        return new BreweryRecipeBuilder();
    }

    public BreweryRecipeBuilder input(ItemLike input) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
    }

    public BreweryRecipeBuilder input(TagKey<Item> input) {
        return this.input(Ingredient.m_204132_(input));
    }

    public BreweryRecipeBuilder input(Ingredient input) {
        if (this.input != null) {
            throw new IllegalStateException("Advanced Brewery Recipes can only take one input.");
        }
        this.input = input;
        return this;
    }

    public BreweryRecipeBuilder action(EffectTransformer transformer) {
        if (this.transformer != null) {
            throw new IllegalStateException("Advanced Brewery Recipes can only take one effect transformer.");
        }
        this.transformer = transformer;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.transformer == null) {
            throw new IllegalStateException("Can't build Advanced Brewery Recipe without action.");
        }
        consumerIn.accept(new Recipe(new ResourceLocation(id.m_135827_(), "utilitix_brewery/" + id.m_135815_()), this.input, this.transformer));
    }

    private record Recipe(ResourceLocation id, @Nullable Ingredient input, EffectTransformer transformer) implements FinishedRecipe
    {
        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (this.input != null) {
                json.add("input", this.input.m_43942_());
            }
            json.add("action", (JsonElement)this.transformer.serialize());
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return ModRecipes.BREWERY_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

