/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.experiencecrystal;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.util.BoundingBoxUtils;
import de.melanx.utilitix.util.XPUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.Nullable;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;

public class TileExperienceCrystal
extends BlockEntityBase
implements TickingBlock,
IFluidTank,
IFluidHandler {
    public static int MB_PER_XP = 20;
    private int xp;

    public TileExperienceCrystal(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            this.moveExps(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.xp = nbt.m_128451_("Xp");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128405_("Xp", this.xp);
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.xp = nbt.m_128451_("Xp");
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("Xp", this.xp);
        return nbt;
    }

    public int getXp() {
        return this.xp;
    }

    public int addXp(int xp) {
        int add = Math.min(Math.max(0, xp), UtilitiXConfig.ExperienceCrystal.maxXp - this.xp);
        this.xp += add;
        this.m_6596_();
        this.setDispatchable();
        return add;
    }

    public int subtractXp(int xp) {
        int remove = Math.max(0, Math.min(xp, this.xp));
        this.xp -= remove;
        this.m_6596_();
        this.setDispatchable();
        return remove;
    }

    private void moveExps(Level level, BlockPos pos) {
        if (!UtilitiXConfig.ExperienceCrystal.pullOrbs || this.xp >= UtilitiXConfig.ExperienceCrystal.maxXp) {
            return;
        }
        List xps = level.m_45976_(ExperienceOrb.class, BoundingBoxUtils.expand(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), 7.0));
        for (ExperienceOrb orb : xps) {
            Vec3 vector = new Vec3((double)pos.m_123341_() - orb.m_20185_() + 0.5, (double)((float)pos.m_123342_() + orb.m_20192_() / 2.0f) - orb.m_20186_(), (double)pos.m_123343_() - orb.m_20189_() + 0.5);
            double scale = 1.0 - vector.m_82553_() / 8.0;
            orb.m_20256_(orb.m_20184_().m_82549_(vector.m_82541_().m_82490_(scale * scale * 0.1)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (TileExperienceCrystal.validXpFluidIsPresent() && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(capability, side);
    }

    @Nonnull
    public FluidStack getFluid() {
        return TileExperienceCrystal.xpFluid().map(fluid -> new FluidStack(fluid, this.xp * MB_PER_XP)).orElse(FluidStack.EMPTY);
    }

    public int getFluidAmount() {
        if (this.xp > Integer.MAX_VALUE / MB_PER_XP) {
            return Integer.MAX_VALUE;
        }
        return this.xp * MB_PER_XP;
    }

    public int getCapacity() {
        if (UtilitiXConfig.ExperienceCrystal.maxXp > Integer.MAX_VALUE / MB_PER_XP) {
            return Integer.MAX_VALUE;
        }
        return UtilitiXConfig.ExperienceCrystal.maxXp * MB_PER_XP;
    }

    public boolean isFluidValid(FluidStack stack) {
        return XPUtils.XP_FLUID_TAGS.stream().anyMatch(p -> TileExperienceCrystal.getFluidTag((TagKey<Fluid>)p).contains((Object)stack.getFluid()));
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(resource)) {
            return 0;
        }
        int xpAccepted = Math.min(this.getCapacity() - this.getFluidAmount(), resource.getAmount()) / MB_PER_XP;
        if (action.execute()) {
            xpAccepted = this.addXp(xpAccepted);
        }
        return xpAccepted * MB_PER_XP;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(new FluidStack(this.getFluid(), maxDrain), action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFluidValid(resource) || resource.getAmount() == 0 || this.getFluidAmount() == 0) {
            return FluidStack.EMPTY;
        }
        int xpToDrain = Math.min(this.getFluidAmount(), resource.getAmount()) / MB_PER_XP;
        FluidStack result = new FluidStack(resource.getFluid(), xpToDrain * MB_PER_XP);
        if (action.execute()) {
            this.subtractXp(xpToDrain);
        }
        return result;
    }

    @Nonnull
    private static ITag<Fluid> getFluidTag(TagKey<Fluid> tag) {
        return Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).getTag(tag);
    }

    public static boolean validXpFluidIsPresent() {
        return XPUtils.XP_FLUID_TAGS.stream().anyMatch(tag -> !TileExperienceCrystal.getFluidTag((TagKey<Fluid>)tag).isEmpty());
    }

    public static Optional<Fluid> xpFluid() {
        return XPUtils.XP_FLUID_TAGS.stream().flatMap(tag -> TileExperienceCrystal.getFluidTag((TagKey<Fluid>)tag).stream()).min(Comparator.comparing(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0)));
    }
}

