/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.mixin;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.compat.quark.QuarkCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DoorBlock.class})
public abstract class MixinDoorBlock {
    private static boolean HANDLE_DOOR = false;

    @Inject(method={"use"}, at={@At(value="RETURN")})
    public void openSecondDoor(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (cir.getReturnValue() == InteractionResult.PASS || !UtilitiXConfig.doubleDoor || HANDLE_DOOR || ModList.get().isLoaded("quark") && !QuarkCompat.useDoorOpening()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
        DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
        boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) == false;
        BlockPos neighborPos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
        BlockState neighborState = level.m_8055_(neighborPos);
        if (!(neighborState.m_60734_() instanceof DoorBlock) && !neighborState.m_204336_(BlockTags.f_13103_) || (Boolean)neighborState.m_61143_((Property)DoorBlock.f_52727_) != open || DoorBlock.m_52817_((BlockState)neighborState)) {
            return;
        }
        if (neighborState.m_61143_((Property)DoorBlock.f_52730_) == half && neighborState.m_61143_((Property)DoorBlock.f_52728_) != hinge && neighborState.m_61143_((Property)DoorBlock.f_52726_) == facing) {
            BlockHitResult neighborHit = new BlockHitResult(new Vec3((double)neighborPos.m_123341_() + 0.5, (double)neighborPos.m_123342_() + 0.5, (double)neighborPos.m_123343_() + 0.5), facing, neighborPos, false);
            HANDLE_DOOR = true;
            if (neighborHit.m_6662_() == HitResult.Type.BLOCK) {
                neighborState.m_60664_(level, player, hand, neighborHit);
            }
            HANDLE_DOOR = false;
        }
    }
}

