/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;
import tamaized.voidscape.world.feature.ClusterFeature;
import tamaized.voidscape.world.feature.SpireFeature;
import tamaized.voidscape.world.feature.ThunderVinesFeature;
import tamaized.voidscape.world.feature.config.BooleanFeatureConfig;
import tamaized.voidscape.world.feature.config.ClusterConfig;
import tamaized.voidscape.world.feature.config.FluidFeatureConfig;

public class ModFeatures
implements RegistryClass {
    private static final DeferredRegister<Feature<?>> REGISTRY_FEATURES = RegUtil.create(ForgeRegistries.FEATURES);
    private static final DeferredRegister<PlacementModifierType<?>> REGISTRY_PLACEMENT_MOD_TYPE = RegUtil.create(Registries.f_256843_);
    public static final ResourceKey<ConfiguredFeature<?, ?>> THUNDER_FUNGUS = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("voidscape", "thunder_fungus"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> THUNDER_FOREST_VEGETATION_BONEMEAL = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("voidscape", "thunder_forest_vegetation_bonemeal"));
    public static final RegistryObject<Feature<BooleanFeatureConfig>> SPIRE = REGISTRY_FEATURES.register("spire", () -> new SpireFeature(BooleanFeatureConfig.CODEC));
    public static final RegistryObject<Feature<FluidFeatureConfig>> FLUID = REGISTRY_FEATURES.register("fluid", () -> new Feature<FluidFeatureConfig>(FluidFeatureConfig.CODEC){

        public boolean m_142674_(FeaturePlaceContext<FluidFeatureConfig> context) {
            context.m_159774_().m_7731_(context.m_159777_(), ((FluidFeatureConfig)context.m_159778_()).state.m_76188_(), 2);
            context.m_159774_().m_186469_(context.m_159777_(), ((FluidFeatureConfig)context.m_159778_()).state.m_76152_(), 0);
            return true;
        }
    });
    public static final RegistryObject<Feature<ClusterConfig>> CLUSTER = REGISTRY_FEATURES.register("cluster", () -> new ClusterFeature(ClusterConfig.CODEC));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> THUNDER_VINES = REGISTRY_FEATURES.register("thunder_vines", ThunderVinesFeature::new);

    private static <P extends PlacementModifier> RegistryObject<PlacementModifierType<P>> registerPlacementModifierType(String name, Supplier<PlacementModifierType<P>> factory) {
        return REGISTRY_PLACEMENT_MOD_TYPE.register(name, factory);
    }

    @Override
    public void init(IEventBus bus) {
        SeekDownPlacementMod.CODEC.getClass();
        AirAbovePlacementMod.CODEC.getClass();
        NotAirBelowPlacementMod.CODEC.getClass();
        NotInBlockPlacementMod.CODEC.getClass();
        RandomYPlacementMod.CODEC.getClass();
        UnderBlockPlacementMod.CODEC.getClass();
    }

    private static class SeekDownPlacementMod
    extends PlacementModifier {
        public static final Codec<SeekDownPlacementMod> CODEC = RecordCodecBuilder.create(p_242803_0_ -> p_242803_0_.group((App)Codec.BOOL.fieldOf("check_below").orElse((Object)false).forGetter(c -> c.check_below)).apply((Applicative)p_242803_0_, SeekDownPlacementMod::new));
        public static RegistryObject<PlacementModifierType<SeekDownPlacementMod>> TYPE = ModFeatures.registerPlacementModifierType("seek", () -> () -> CODEC);
        private final boolean check_below;

        public SeekDownPlacementMod(boolean val) {
            this.check_below = val;
        }

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            int y = pos.m_123342_();
            BlockPos.MutableBlockPos seek = pos.m_122032_().m_122175_(Direction.UP, random.m_188503_(15));
            BlockPos.MutableBlockPos check = seek.m_122032_().m_122175_(Direction.DOWN, 1);
            while ((this.check_below ? check : seek).m_123342_() > y && seek.m_123342_() > context.m_191831_().m_141937_() && context.m_191831_().m_8055_((BlockPos)(this.check_below ? check : seek)).m_60795_()) {
                seek.m_122175_(Direction.DOWN, 1);
                check.m_122175_(Direction.DOWN, 1);
            }
            return Stream.of(seek);
        }

        public PlacementModifierType<?> m_183327_() {
            return (PlacementModifierType)TYPE.get();
        }
    }

    private static class AirAbovePlacementMod
    extends PlacementModifier {
        public static final Codec<AirAbovePlacementMod> CODEC = Codec.unit(AirAbovePlacementMod::new);
        public static RegistryObject<PlacementModifierType<AirAbovePlacementMod>> TYPE = ModFeatures.registerPlacementModifierType("air_above", () -> () -> CODEC);

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            return context.m_191828_(pos.m_7494_()).m_60795_() ? Stream.of(pos) : Stream.empty();
        }

        public PlacementModifierType<?> m_183327_() {
            return (PlacementModifierType)TYPE.get();
        }
    }

    private static class NotAirBelowPlacementMod
    extends PlacementModifier {
        public static final Codec<NotAirBelowPlacementMod> CODEC = Codec.unit(NotAirBelowPlacementMod::new);
        public static RegistryObject<PlacementModifierType<NotAirBelowPlacementMod>> TYPE = ModFeatures.registerPlacementModifierType("not_air_below", () -> () -> CODEC);

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            return context.m_191828_(pos.m_7495_()).m_60795_() ? Stream.empty() : Stream.of(pos);
        }

        public PlacementModifierType<?> m_183327_() {
            return (PlacementModifierType)TYPE.get();
        }
    }

    private static class NotInBlockPlacementMod
    extends PlacementModifier {
        public static final Codec<NotInBlockPlacementMod> CODEC = Codec.unit(NotInBlockPlacementMod::new);
        public static RegistryObject<PlacementModifierType<NotInBlockPlacementMod>> TYPE = ModFeatures.registerPlacementModifierType("not_in_block", () -> () -> CODEC);

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            return context.m_191828_(pos).m_60795_() ? Stream.of(pos) : Stream.empty();
        }

        public PlacementModifierType<?> m_183327_() {
            return (PlacementModifierType)TYPE.get();
        }
    }

    private static class RandomYPlacementMod
    extends PlacementModifier {
        public static final Codec<RandomYPlacementMod> CODEC = RecordCodecBuilder.create(p_242803_0_ -> p_242803_0_.group((App)Codec.INT.fieldOf("y").orElse((Object)0).forGetter(c -> c.y)).apply((Applicative)p_242803_0_, RandomYPlacementMod::new));
        public static RegistryObject<PlacementModifierType<RandomYPlacementMod>> TYPE = ModFeatures.registerPlacementModifierType("random_y", () -> () -> CODEC);
        private final int y;

        public RandomYPlacementMod(int y) {
            this.y = y;
        }

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            return Stream.of(pos.m_6630_(random.m_188503_(this.y) - this.y / 2));
        }

        public PlacementModifierType<?> m_183327_() {
            return (PlacementModifierType)TYPE.get();
        }
    }

    private static class UnderBlockPlacementMod
    extends PlacementModifier {
        public static final Codec<UnderBlockPlacementMod> CODEC = RecordCodecBuilder.create(p_242803_0_ -> p_242803_0_.group((App)BlockState.f_61039_.fieldOf("state").forGetter(c -> c.state)).apply((Applicative)p_242803_0_, UnderBlockPlacementMod::new));
        public static RegistryObject<PlacementModifierType<UnderBlockPlacementMod>> TYPE = ModFeatures.registerPlacementModifierType("under_block", () -> () -> CODEC);
        private final BlockState state;

        public UnderBlockPlacementMod(BlockState state) {
            this.state = state;
        }

        public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
            BlockPos check;
            for (int i = 1; i < 14 && (check = pos.m_6630_(i)).m_123342_() <= context.m_191831_().m_151558_(); ++i) {
                if (!context.m_191828_(check).m_60713_(this.state.m_60734_())) continue;
                return Stream.of(pos);
            }
            return Stream.empty();
        }

        public PlacementModifierType<?> m_183327_() {
            return (PlacementModifierType)TYPE.get();
        }
    }
}

