/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.registry.ModBlocks;
import tamaized.voidscape.registry.ModSounds;

public class PortalBlock
extends HalfTransparentBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public PortalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? Z_AABB : X_AABB;
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean tryToCreatePortal(Level level, BlockPos pos) {
        Size size = this.isPortal((LevelAccessor)level, pos);
        if (size != null && (level.m_46472_().m_135782_().equals((Object)Level.f_46428_.m_135782_()) || Voidscape.checkForVoidDimension(level))) {
            size.placePortalBlocks();
            return true;
        }
        return false;
    }

    @Nullable
    public Size isPortal(LevelAccessor world, BlockPos pos) {
        Size sizeX = new Size(world, pos, Direction.Axis.X);
        if (sizeX.isValid() && sizeX.portalBlockCount == 0) {
            return sizeX;
        }
        Size sizeZ = new Size(world, pos, Direction.Axis.Z);
        return sizeZ.isValid() && sizeZ.portalBlockCount == 0 ? sizeZ : null;
    }

    @Deprecated
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = facing.m_122434_();
        Direction.Axis directionAxis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(worldIn, currentPos, directionAxis1).canCreatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            entity.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> data.setInPortal(true)));
        }
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(100) == 0) {
            worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.PORTAL.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        double x = (float)pos.m_123341_() + rand.m_188501_();
        double y = (float)pos.m_123342_() + rand.m_188501_();
        double z = (float)pos.m_123343_() + rand.m_188501_();
        double sX = ((double)rand.m_188501_() - 0.5) * 0.25;
        double sY = ((double)rand.m_188501_() - 0.5) * 0.25;
        double sZ = ((double)rand.m_188501_() - 0.5) * 0.25;
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, sX, sY, sZ);
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public static class Size {
        private final LevelAccessor world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private static final BlockBehaviour.StatePredicate FRAME_TEST = (state, reader, pos) -> state.m_60713_((Block)ModBlocks.VOIDIC_CRYSTAL_BLOCK.get()) || state.m_60713_((Block)ModBlocks.FRAGILE_VOIDIC_CRYSTAL_BLOCK.get());
        private final Block PORTAL = (Block)ModBlocks.PORTAL.get();

        public Size(LevelAccessor worldIn, BlockPos pos, Direction.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            this.rightDir = facing == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(pos);
            if (this.bottomLeft == null) {
                this.bottomLeft = pos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculatePortalWidth();
                if (this.width > 0) {
                    this.height = this.calculatePortalHeight();
                }
            }
        }

        @Nullable
        private BlockPos calculateBottomLeft(BlockPos pos) {
            int i = Math.max(0, pos.m_123342_() - 21);
            while (pos.m_123342_() > i && this.isEmptyBlock(this.world.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            Direction direction = this.rightDir.m_122424_();
            int j = this.getDistanceUntilEdge(pos, direction) - 1;
            return j < 0 ? null : pos.m_5484_(direction, j);
        }

        private int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 22; ++i) {
                mutable.m_122190_((Vec3i)pos).m_122175_(facing, i);
                BlockState state = this.world.m_8055_((BlockPos)mutable);
                if (!this.isEmptyBlock(state)) {
                    if (!FRAME_TEST.m_61035_(state, (BlockGetter)this.world, (BlockPos)mutable)) break;
                    return i;
                }
                BlockState state1 = this.world.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN));
                if (!FRAME_TEST.m_61035_(state1, (BlockGetter)this.world, (BlockPos)mutable)) break;
            }
            return 0;
        }

        private int calculatePortalWidth() {
            int dist = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            return dist >= 2 && dist <= 21 ? dist : 0;
        }

        private int calculatePortalHeight() {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int dist = this.getDistanceUntilTop(mutable);
            return dist >= 3 && dist <= 21 && this.hasTopFrame(mutable, dist) ? dist : 0;
        }

        private int getDistanceUntilTop(BlockPos.MutableBlockPos mutable) {
            for (int i = 0; i < 21; ++i) {
                mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
                if (!FRAME_TEST.m_61035_(this.world.m_8055_((BlockPos)mutable), (BlockGetter)this.world, (BlockPos)mutable)) {
                    return i;
                }
                mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
                if (!FRAME_TEST.m_61035_(this.world.m_8055_((BlockPos)mutable), (BlockGetter)this.world, (BlockPos)mutable)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                    BlockState blockstate = this.world.m_8055_((BlockPos)mutable);
                    if (!this.isEmptyBlock(blockstate)) {
                        return i;
                    }
                    if (blockstate.m_60734_() != this.PORTAL) continue;
                    ++this.portalBlockCount;
                }
            }
            return 21;
        }

        private boolean hasTopFrame(BlockPos.MutableBlockPos mutable, int offset) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos mutablepos = mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, offset).m_122175_(this.rightDir, i);
                if (FRAME_TEST.m_61035_(this.world.m_8055_((BlockPos)mutablepos), (BlockGetter)this.world, (BlockPos)mutablepos)) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyBlock(BlockState state) {
            Block block = state.m_60734_();
            return state.m_60795_() || block == this.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            BlockState state = (BlockState)this.PORTAL.m_49966_().m_61124_(AXIS, (Comparable)this.axis);
            BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(pos -> this.world.m_7731_(pos, state, 18));
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount == this.width * this.height;
        }
    }
}

