/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import tamaized.voidscape.registry.ModParticles;

public abstract class SpellBoltEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected LivingEntity shootingEntity;
    private int particleColor;
    private int ticksInAir;
    private Vec3 startingPoint = this.m_20182_();
    protected double speed = 1.0;
    protected float range = 32.0f;
    protected double maxRange = 0.0;

    public SpellBoltEntity(EntityType<? extends SpellBoltEntity> type, Level level, int color) {
        super(type, level);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.f_19811_ = true;
        this.particleColor = color;
    }

    public SpellBoltEntity(EntityType<? extends SpellBoltEntity> type, LivingEntity shooter, int color) {
        this(type, shooter.m_9236_(), color);
        this.shootingEntity = shooter;
        this.m_146884_(shooter.m_146892_().m_82549_(shooter.m_20252_(1.0f).m_82541_().m_82490_(0.5)));
        this.startingPoint = this.m_20182_();
        this.setTheVelocity(shooter.m_20252_(1.0f));
    }

    private void setTheVelocity(Vec3 dir) {
        this.m_20256_(dir);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)));
            this.m_146926_((float)(Mth.m_14136_((double)dir.f_82480_, (double)f) * 57.29577951308232));
            this.m_146922_((float)(Mth.m_14136_((double)dir.f_82479_, (double)dir.f_82481_) * 57.29577951308232));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    @Deprecated
    public float m_213856_() {
        return 1.0f;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.m_20185_());
        buffer.writeDouble(this.m_20186_());
        buffer.writeDouble(this.m_20189_());
        buffer.writeFloat(this.range);
        buffer.writeDouble(this.speed);
        buffer.writeDouble(this.maxRange);
        buffer.writeInt(this.particleColor);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.m_6027_(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.range = buffer.readFloat();
        this.speed = buffer.readDouble();
        this.maxRange = buffer.readDouble();
        this.particleColor = buffer.readInt();
    }

    public boolean m_36792_() {
        return false;
    }

    public void m_36762_(boolean critical) {
    }

    protected boolean m_5603_(Entity entity) {
        return entity != this.shootingEntity && entity instanceof LivingEntity;
    }

    public void m_8119_() {
        Object voxelshape;
        this.m_6075_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_)));
            this.f_19859_ = (float)(Math.atan2(this.m_20184_().f_82479_, this.m_20184_().f_82481_) * 57.29577951308232);
            this.m_146922_(this.f_19859_);
            this.f_19860_ = (float)(Math.atan2(this.m_20184_().f_82480_, f) * 57.29577951308232);
            this.m_146926_(this.f_19860_);
        }
        BlockPos blockpos = this.m_20183_();
        BlockState iblockstate = this.m_9236_().m_8055_(blockpos);
        if (!iblockstate.m_60795_() && !(voxelshape = iblockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
            for (AABB axisalignedbb : voxelshape.m_83299_()) {
                if (!axisalignedbb.m_82338_(blockpos).m_82390_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()))) continue;
                this.onBlockHit(iblockstate, blockpos);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        ++this.ticksInAir;
        if (this.maxRange > 0.0) {
            if (this.startingPoint.m_82554_(this.m_20182_()) >= this.maxRange) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else if (this.ticksInAir > 100) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.m_9236_().m_5776_()) {
            for (Entity e : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 1.0, 1.0))) {
                if (!this.m_5603_(e) || !(e instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)e;
                this.onHit(living);
            }
        }
        float f1 = 0.99f;
        float f4 = Mth.m_14116_((float)((float)(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_)));
        if (this.m_20069_()) {
            for (int l = 0; l < 4; ++l) {
                f4 = 0.25f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - this.m_20184_().f_82479_ * (double)f4, this.m_20186_() - this.m_20184_().f_82480_ * (double)f4, this.m_20189_() - this.m_20184_().f_82481_ * (double)f4, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
            }
            f1 = 0.6f;
        }
        this.m_6027_(this.m_20185_() + this.m_20184_().f_82479_ * this.speed * (double)f1, this.m_20186_() + this.m_20184_().f_82480_ * this.speed * (double)f1, this.m_20189_() + this.m_20184_().f_82481_ * this.speed * (double)f1);
        this.m_146922_((float)(Math.atan2(this.m_20184_().f_82479_, this.m_20184_().f_82481_) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)this.m_20184_().f_82480_, (double)f4) * 57.29577951308232));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(this.f_19860_ + (this.m_146909_() - this.f_19860_) * 0.2f);
        this.m_146922_(this.f_19859_ + (this.m_146908_() - this.f_19859_) * 0.2f);
        if (this.m_20070_()) {
            this.m_20095_();
        }
        this.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20101_();
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)new ModParticles.ParticleSpellCloudData(this.particleColor), this.m_20185_() - (double)0.3f + (double)(this.f_19796_.m_188501_() * 0.6f), this.m_20186_() - (double)0.3f + (double)(this.f_19796_.m_188501_() * 0.6f), this.m_20189_() - (double)0.3f + (double)(this.f_19796_.m_188501_() * 0.6f), 0.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult p_37260_) {
    }

    protected void onHit(LivingEntity entity) {
        this.m_7761_(entity);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void onBlockHit(BlockState state, BlockPos pos) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_7761_(LivingEntity entity) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    public void m_7380_(CompoundTag compound) {
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

