/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.Insanity;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.entity.IchorBoltEntity;
import tamaized.voidscape.item.SpellTome;
import tamaized.voidscape.registry.ModAdvancementTriggers;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.registry.ModEffects;
import tamaized.voidscape.registry.ModItems;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

public class ModTools
implements RegistryClass {
    private static final Map<UUID, Direction> LAST_HIT_BLOCK_FACE = new HashMap<UUID, Direction>();
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_SWORD = RegUtil.ToolAndArmorHelper.sword(ItemTier.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 1.0)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_BOW = RegUtil.ToolAndArmorHelper.bow(ItemTier.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 1.0)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_XBOW = RegUtil.ToolAndArmorHelper.xbow(ItemTier.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 1.0)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_SHIELD = RegUtil.ToolAndArmorHelper.shield(ItemTier.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_RES, AttributeModifier.Operation.ADDITION, 1.0)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_AXE = RegUtil.ToolAndArmorHelper.axe(ItemTier.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 2.0)), tooltip -> {});
    public static final RegistryObject<Item> VOIDIC_CRYSTAL_PICKAXE = RegUtil.ToolAndArmorHelper.pickaxe(ItemTier.VOIDIC_CRYSTAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 1.0)), tooltip -> {});
    public static final RegistryObject<Item> CHARRED_WARHAMMER = ModTools.hammer(ItemTier.CHARRED, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_SWORD = RegUtil.ToolAndArmorHelper.sword(ItemTier.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 2.0)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_BOW = RegUtil.ToolAndArmorHelper.bow(ItemTier.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 2.0)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_XBOW = RegUtil.ToolAndArmorHelper.xbow(ItemTier.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 2.0)), tooltip -> {});
    public static final RegistryObject<Item> CORRUPT_AXE = RegUtil.ToolAndArmorHelper.axe(ItemTier.CORRUPT, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_SWORD = RegUtil.ToolAndArmorHelper.sword(ItemTier.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_BOW = RegUtil.ToolAndArmorHelper.bow(ItemTier.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_XBOW = RegUtil.ToolAndArmorHelper.xbow(ItemTier.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_AXE = RegUtil.ToolAndArmorHelper.axe(ItemTier.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 4.0)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_PICKAXE = RegUtil.ToolAndArmorHelper.pickaxe(ItemTier.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 2.0)), tooltip -> {});
    public static final RegistryObject<Item> TITANITE_HOE = ModTools.bonemealHoe(ItemTier.TITANITE, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 1.0)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_TOME = ModItems.REGISTRY.register("ichor_tome", () -> new SpellTome(ModItems.ItemProps.LAVA_IMMUNE.properties().get().m_41503_(100), (Supplier<Item>)ModItems.ICHOR_CRYSTAL, 200, context -> context.level().m_7967_((Entity)new IchorBoltEntity(context.parent()))));
    public static final RegistryObject<Item> VOIDIC_TOME = ModItems.REGISTRY.register("voidic_tome", () -> new SpellTome(ModItems.ItemProps.LAVA_IMMUNE.properties().get().m_41503_(100), (Supplier<Item>)ModItems.VOIDIC_CRYSTAL, 900, context -> context.parent().m_7292_(new MobEffectInstance((MobEffect)ModEffects.AURA.get(), 600))));
    public static final RegistryObject<Item> CORRUPT_TOME = ModItems.REGISTRY.register("corrupt_tome", () -> new SpellTome(ModItems.ItemProps.LAVA_IMMUNE.properties().get().m_41503_(100), (Supplier<Item>)ModItems.TENDRIL, 100, context -> {
        context.parent().m_246865_(context.parent().m_20154_().m_82490_(2.5));
        context.level().m_6269_(null, (Entity)context.parent(), SoundEvents.f_11932_, SoundSource.PLAYERS, 1.0f, 0.75f + context.parent().m_217043_().m_188501_() * 0.5f);
        context.parent().getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(Insanity::enableLeapParticles));
        context.parent().m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200));
    }));
    public static final RegistryObject<Item> TITANITE_TOME = ModItems.REGISTRY.register("titanite_tome", () -> new SpellTome(ModItems.ItemProps.LAVA_IMMUNE.properties().get().m_41503_(100), (Supplier<Item>)ModItems.TITANITE_SHARD, 900, context -> context.parent().m_7292_(new MobEffectInstance((MobEffect)ModEffects.FORTIFIED.get(), 600))));
    public static final RegistryObject<Item> ICHOR_SWORD = RegUtil.ToolAndArmorHelper.sword(ItemTier.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 4.0)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_BOW = RegUtil.ToolAndArmorHelper.bow(ItemTier.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 4.0)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_XBOW = RegUtil.ToolAndArmorHelper.xbow(ItemTier.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 4.0)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_AXE = RegUtil.ToolAndArmorHelper.axe(ItemTier.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 5.0)), tooltip -> {});
    public static final RegistryObject<Item> ICHOR_PICKAXE = RegUtil.ToolAndArmorHelper.pickaxe(ItemTier.ICHOR, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_SWORD = RegUtil.ToolAndArmorHelper.sword(ItemTier.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 5.0)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_AXE = RegUtil.ToolAndArmorHelper.axe(ItemTier.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 6.0)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_PICKAXE = RegUtil.ToolAndArmorHelper.pickaxe(ItemTier.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 4.0)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_SHOVEL = ModTools.threeByThreeShovel(ItemTier.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_DMG, AttributeModifier.Operation.ADDITION, 3.0)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_BOW = RegUtil.ToolAndArmorHelper.bow(ItemTier.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 5.0)), tooltip -> {});
    public static final RegistryObject<Item> ASTRAL_XBOW = RegUtil.ToolAndArmorHelper.xbow(ItemTier.ASTRAL, ModItems.ItemProps.LAVA_IMMUNE.properties().get(), RegUtil.makeAttributeFactory(RegUtil.AttributeData.make(ModAttributes.VOIDIC_ARROW_DMG, AttributeModifier.Operation.ADDITION, 5.0)), tooltip -> {});

    @Override
    public void init(IEventBus bus) {
        MinecraftForge.EVENT_BUS.addListener(event -> LAST_HIT_BLOCK_FACE.put(event.getEntity().m_20148_(), event.getFace()));
        MinecraftForge.EVENT_BUS.addListener(event -> LAST_HIT_BLOCK_FACE.remove(event.getEntity().m_20148_()));
    }

    private static RegistryObject<Item> hammer(RegUtil.ItemTier tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer) {
        return ModItems.REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_warhammer"), () -> new LootingWarhammer(factory, tier, 7, -3.5f, properties, tooltipConsumer));
    }

    private static RegistryObject<Item> threeByThreeShovel(RegUtil.ItemTier tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer) {
        return ModItems.REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_shovel"), () -> new ThreeByThreeShovel(factory, tier, 1.5f, -3.0f, properties, tooltipConsumer));
    }

    private static RegistryObject<Item> bonemealHoe(RegUtil.ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer) {
        return ModItems.REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_hoe"), () -> new HoeItem(tier, -3, 0.0f, properties){

            @OnlyIn(value=Dist.CLIENT)
            public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                if (RegUtil.ToolAndArmorHelper.isBroken(stack)) {
                    tooltip.add((Component)Component.m_237115_((String)"voidscape.tooltip.broken").m_130940_(ChatFormatting.DARK_RED));
                }
                tooltipConsumer.accept(new RegUtil.ToolAndArmorHelper.TooltipContext(stack, worldIn, tooltip, flagIn));
                super.m_7373_(stack, worldIn, tooltip, flagIn);
            }

            public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                if (amount >= remaining) {
                    onBroken.accept(entity);
                }
                return Math.min(remaining, amount);
            }

            public float m_8102_(ItemStack stack, BlockState state) {
                return RegUtil.ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state);
            }

            public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                return !RegUtil.ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
            }

            public InteractionResult m_6225_(UseOnContext context) {
                InteractionResult result;
                if (RegUtil.ToolAndArmorHelper.isBroken(context.m_43722_())) {
                    return InteractionResult.FAIL;
                }
                InteractionResult interactionResult = result = context.m_43723_() != null && context.m_43723_().m_6144_() ? InteractionResult.PASS : super.m_6225_(context);
                if (result == InteractionResult.PASS) {
                    result = Items.f_42499_.m_6225_(new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), new ItemStack((ItemLike)Items.f_42499_), new BlockHitResult(context.m_43720_(), context.m_8125_(), context.m_8083_(), context.m_43721_())));
                    if ((result == InteractionResult.SUCCESS || result == InteractionResult.CONSUME) && context.m_43723_() != null) {
                        context.m_43722_().m_41622_(20, (LivingEntity)context.m_43723_(), (Consumer)new Consumer<LivingEntity>(){

                            @Override
                            public void accept(LivingEntity entityIn1) {
                                entityIn1.m_21166_(EquipmentSlot.MAINHAND);
                            }
                        });
                        Player player = context.m_43723_();
                        if (player instanceof ServerPlayer) {
                            ServerPlayer player2 = (ServerPlayer)player;
                            ModAdvancementTriggers.HOE_BONEMEAL_TRIGGER.trigger(player2);
                        }
                    }
                    return result;
                }
                return result;
            }

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                if (!RegUtil.ToolAndArmorHelper.isBroken(stack)) {
                    map.putAll(super.m_7167_(slot));
                    if (slot == EquipmentSlot.MAINHAND) {
                        map.putAll((Multimap)factory.apply(null));
                    }
                }
                return map.build();
            }
        });
    }

    @Nullable
    public static Boolean threeByThreeBreak(Item item, ItemStack stack, BlockPos pos, Player pl) {
        ServerPlayer player;
        block17: {
            block16: {
                if (pl.m_9236_().f_46443_ || !(pl instanceof ServerPlayer)) break block16;
                player = (ServerPlayer)pl;
                if (!RegUtil.ToolAndArmorHelper.isBroken(stack)) break block17;
            }
            return null;
        }
        ServerLevel level = player.m_284548_();
        BlockState oState = level.m_8055_(pos);
        if (!item.isCorrectToolForDrops(stack, oState)) {
            return false;
        }
        float hardness = oState.m_60800_((BlockGetter)level, pos);
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        switch (LAST_HIT_BLOCK_FACE.get(player.m_20148_())) {
            default: {
                area.add(pos);
                break;
            }
            case DOWN: 
            case UP: {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        area.add(pos.m_7918_(x, 0, z));
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        area.add(pos.m_7918_(0, y, z));
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int y = -1; y <= 1; ++y) {
                    for (int x = -1; x <= 1; ++x) {
                        area.add(pos.m_7918_(x, y, 0));
                    }
                }
            }
        }
        if (area.size() > 1) {
            ModAdvancementTriggers.THREE_BY_THREE.trigger(player, stack);
        }
        area.stream().map(p -> Pair.of((Object)p, (Object)level.m_8055_(p))).filter(p -> {
            BlockState state = (BlockState)p.right();
            if (state.m_60795_()) {
                return false;
            }
            float h = state.m_60800_((BlockGetter)level, (BlockPos)p.left());
            if (h < 0.0f) {
                return false;
            }
            return (hardness == 0.0f ? h == 0.0f : h / hardness <= 3.0f) && item.isCorrectToolForDrops(stack, state);
        }).forEach(p -> {
            BlockPos blockPos = (BlockPos)p.left();
            BlockState state = (BlockState)p.right();
            int exp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)player.f_8941_.m_9290_(), (ServerPlayer)player, (BlockPos)blockPos);
            if (exp != -1 && !player.m_36187_((Level)level, blockPos, player.f_8941_.m_9290_())) {
                if (player.m_7500_()) {
                    ModTools.removeBlock((Level)level, (Player)player, blockPos, false);
                } else {
                    boolean flag;
                    BlockEntity blockentity = level.m_7702_(blockPos);
                    ItemStack cloneStack = stack.m_41777_();
                    boolean flag1 = state.canHarvestBlock((BlockGetter)level, blockPos, (Player)player);
                    stack.m_41686_((Level)level, state, blockPos, (Player)player);
                    if (stack.m_41619_() && !cloneStack.m_41619_()) {
                        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)cloneStack, (InteractionHand)InteractionHand.MAIN_HAND);
                    }
                    if ((flag = ModTools.removeBlock((Level)level, (Player)player, blockPos, flag1)) && flag1) {
                        state.m_60734_().m_6240_((Level)level, (Player)player, blockPos, state, blockentity, cloneStack);
                    }
                    if (flag && exp > 0) {
                        state.m_60734_().m_49805_(level, blockPos, exp);
                    }
                    level.m_6798_(2001, blockPos, Block.m_49956_((BlockState)state));
                    player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, blockPos));
                }
            }
        });
        return true;
    }

    private static boolean removeBlock(Level level, Player player, BlockPos pos, boolean canHarvest) {
        BlockState state = level.m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer(level, pos, player, canHarvest, level.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    public static class ThreeByThreeShovel
    extends ShovelItem {
        private final Function<Integer, Multimap<Attribute, AttributeModifier>> factory;
        private final Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer;

        public ThreeByThreeShovel(Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Tier tier, float attackDamage, float speed, Item.Properties properties, Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer) {
            super(tier, attackDamage, speed, properties);
            this.factory = factory;
            this.tooltipConsumer = tooltipConsumer;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            if (RegUtil.ToolAndArmorHelper.isBroken(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"voidscape.tooltip.broken").m_130940_(ChatFormatting.DARK_RED));
            }
            this.tooltipConsumer.accept(new RegUtil.ToolAndArmorHelper.TooltipContext(stack, worldIn, tooltip, flagIn));
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }

        public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
            int remaining = stack.m_41776_() - 1 - stack.m_41773_();
            if (amount >= remaining) {
                onBroken.accept(entity);
            }
            return Math.min(remaining, amount);
        }

        public float m_8102_(ItemStack stack, BlockState state) {
            return RegUtil.ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state) / 3.0f;
        }

        public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player pl) {
            Boolean state = ModTools.threeByThreeBreak((Item)this, stack, pos, pl);
            if (state == null) {
                return super.onBlockStartBreak(stack, pos, pl);
            }
            return state;
        }

        public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
            return !RegUtil.ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
            ImmutableMultimap.Builder map = ImmutableMultimap.builder();
            if (!RegUtil.ToolAndArmorHelper.isBroken(stack)) {
                map.putAll(super.m_7167_(slot));
                if (slot == EquipmentSlot.MAINHAND) {
                    map.putAll(this.factory.apply(null));
                }
            }
            return map.build();
        }
    }

    public static class LootingWarhammer
    extends PickaxeItem {
        private final Function<Integer, Multimap<Attribute, AttributeModifier>> factory;
        private final Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer;

        public LootingWarhammer(Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Tier tier, int attackDamage, float speed, Item.Properties properties, Consumer<RegUtil.ToolAndArmorHelper.TooltipContext> tooltipConsumer) {
            super(tier, attackDamage, speed, properties);
            this.factory = factory;
            this.tooltipConsumer = tooltipConsumer;
        }

        public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)stack) > 0 && toolAction == ToolActions.SWORD_SWEEP || super.canPerformAction(stack, toolAction);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            if (RegUtil.ToolAndArmorHelper.isBroken(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"voidscape.tooltip.broken").m_130940_(ChatFormatting.DARK_RED));
            }
            this.tooltipConsumer.accept(new RegUtil.ToolAndArmorHelper.TooltipContext(stack, worldIn, tooltip, flagIn));
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }

        public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
            int remaining = stack.m_41776_() - 1 - stack.m_41773_();
            if (amount >= remaining) {
                onBroken.accept(entity);
            }
            return Math.min(remaining, amount);
        }

        public float m_8102_(ItemStack stack, BlockState state) {
            return RegUtil.ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state) / 3.0f;
        }

        public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player pl) {
            Boolean state = ModTools.threeByThreeBreak((Item)this, stack, pos, pl);
            if (state == null) {
                return super.onBlockStartBreak(stack, pos, pl);
            }
            return state;
        }

        public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
            return !RegUtil.ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
            ImmutableMultimap.Builder map = ImmutableMultimap.builder();
            if (!RegUtil.ToolAndArmorHelper.isBroken(stack)) {
                map.putAll(super.m_7167_(slot));
                if (slot == EquipmentSlot.MAINHAND) {
                    map.putAll(this.factory.apply(null));
                }
            }
            return map.build();
        }
    }

    public static class ItemTier {
        public static final RegUtil.ItemTier VOIDIC_CRYSTAL = new RegUtil.ItemTier("voidic_crystal", 5, 2538, 9.5f, 5.0f, 17, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDIC_CRYSTAL.get()}));
        public static final RegUtil.ItemTier CHARRED = new RegUtil.ItemTier("charred", 5, 2538, 9.5f, 5.0f, 17, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHARRED_BONE.get()}));
        public static final RegUtil.ItemTier CORRUPT = new RegUtil.ItemTier("corrupt", 6, 3041, 10.0f, 6.0f, 19, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TENDRIL.get()}));
        public static final RegUtil.ItemTier TITANITE = new RegUtil.ItemTier("titanite", 7, 3544, 10.5f, 7.0f, 21, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TITANITE_SHARD.get()}));
        public static final RegUtil.ItemTier ICHOR = new RegUtil.ItemTier("ichor", 8, 4047, 11.0f, 8.0f, 23, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ICHOR_CRYSTAL.get()}));
        public static final RegUtil.ItemTier ASTRAL = new RegUtil.ItemTier("astral", 9, 4550, 11.5f, 9.0f, 25, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ICHOR_CRYSTAL.get()}));

        public static boolean check(Tier tier) {
            return tier == VOIDIC_CRYSTAL || tier == CHARRED || tier == CORRUPT || tier == TITANITE || tier == ICHOR || tier == ASTRAL;
        }
    }
}

