/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.world.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import tamaized.voidscape.registry.ModBlocks;
import tamaized.voidscape.world.VoidscapeLayeredBiomeProvider;
import tamaized.voidscape.world.feature.config.BooleanFeatureConfig;

public class SpireFeature
extends Feature<BooleanFeatureConfig> {
    public SpireFeature(Codec<BooleanFeatureConfig> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<BooleanFeatureConfig> context) {
        int antiYLimit;
        BlockPos.MutableBlockPos pos = context.m_159777_().m_122032_();
        if (pos.m_123341_() <= 48 && pos.m_123341_() >= -48 && pos.m_123343_() <= 48 && pos.m_123343_() >= -48) {
            return false;
        }
        int base = pos.m_123342_();
        int length = context.m_225041_().m_188503_(25) + 5;
        boolean canGen = false;
        BiomeSource biomeSource = context.m_159775_().m_62218_();
        if (biomeSource instanceof VoidscapeLayeredBiomeProvider) {
            VoidscapeLayeredBiomeProvider provider = (VoidscapeLayeredBiomeProvider)biomeSource;
            v0 = provider.getLayerY(0);
        } else {
            v0 = antiYLimit = context.m_159774_().m_141937_() + 32;
        }
        while ((((BooleanFeatureConfig)context.m_159778_()).get() ? base + length < antiYLimit : base < context.m_159774_().m_151558_() - length) && !(canGen = this.checkForRoom(context.m_159774_(), (BlockPos)pos.m_122178_(pos.m_123341_(), ((BooleanFeatureConfig)context.m_159778_()).get() ? base + length : base, pos.m_123343_()), length, ((BooleanFeatureConfig)context.m_159778_()).get()))) {
            ++base;
        }
        if (canGen) {
            this.genSpire(context.m_159774_(), (BlockPos)pos.m_122178_(pos.m_123341_(), base + length * (((BooleanFeatureConfig)context.m_159778_()).get() ? 0 : 1), pos.m_123343_()), length, context.m_225041_(), 5, ((BooleanFeatureConfig)context.m_159778_()).get());
            context.m_159774_().m_7731_((BlockPos)pos, ((Block)(((BooleanFeatureConfig)context.m_159778_()).get() ? ModBlocks.ANTIROCK : ModBlocks.THUNDERROCK).get()).m_49966_(), 18);
            return true;
        }
        return false;
    }

    private boolean checkForRoom(WorldGenLevel level, BlockPos pos, int len, boolean invert) {
        if (!level.m_8055_(pos).m_60713_(Blocks.f_50752_)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            BlockPos p;
            BlockPos blockPos = p = invert ? pos.m_6625_(i + 1) : pos.m_6630_(i + 1);
            if (p.m_123342_() <= 0) {
                return false;
            }
            if (level.m_8055_(p).m_60795_()) continue;
            return false;
        }
        return true;
    }

    private void genSpire(WorldGenLevel level, BlockPos pos, int len, RandomSource rand, int chance, boolean invert) {
        int flag = 18;
        for (int y = len; y > 0; --y) {
            Direction dir;
            level.m_7731_(invert ? pos.m_6630_(len - y) : pos.m_6625_(len - y), Blocks.f_50752_.m_49966_(), 18);
            if (rand.m_188503_(chance) != 0 || !level.m_8055_(pos.m_121945_(dir = Direction.Plane.HORIZONTAL.m_235690_(rand))).m_60795_()) continue;
            this.genSpire(level, (invert ? pos.m_6630_(len - y) : pos.m_6625_(len - y)).m_121945_(dir), y, rand, chance * 2, invert);
        }
    }
}

