/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.betterdungeons.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.BitSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Fluids;

public class SpiderDungeonEggRoomPiece
extends SpiderDungeonPiece {
    private final BlockPos startPos;
    private float xRadius = 0.0f;
    private float yRadius = 0.0f;
    private float zRadius = 0.0f;
    private static final float X_MINRADIUS = 2.0f;
    private static final float X_MAXRADIUS = 3.0f;
    private static final float Y_MINRADIUS = 2.0f;
    private static final float Y_MAXRADIUS = 3.0f;
    private static final float Z_MINRADIUS = 2.0f;
    private static final float Z_MAXRADIUS = 3.0f;
    private static final BlockStateRandomizer WOOL_SELECTOR = BlockStateRandomizer.from((BlockState[])new BlockState[]{Blocks.f_50041_.m_49966_()});
    private static final BlockStateRandomizer COBWEB_SELECTOR = BlockStateRandomizer.from((BlockState[])new BlockState[]{Blocks.f_50033_.m_49966_()});

    public SpiderDungeonEggRoomPiece(BlockPos startPos, int pieceChainLength) {
        super(StructurePieceTypeModule.EGG_ROOM, pieceChainLength, SpiderDungeonEggRoomPiece.getInitialBoundingBox(startPos));
        this.startPos = new BlockPos((Vec3i)startPos);
    }

    public SpiderDungeonEggRoomPiece(CompoundTag compoundTag) {
        super(StructurePieceTypeModule.EGG_ROOM, compoundTag);
        int[] start = compoundTag.m_128465_("startPos");
        this.startPos = new BlockPos(start[0], start[1], start[2]);
        this.xRadius = compoundTag.m_128457_("xRadius");
        this.yRadius = compoundTag.m_128457_("yRadius");
        this.zRadius = compoundTag.m_128457_("zRadius");
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.m_128385_("startPos", new int[]{this.startPos.m_123341_(), this.startPos.m_123342_(), this.startPos.m_123343_()});
        compoundTag.m_128350_("xRadius", this.xRadius);
        compoundTag.m_128350_("yRadius", this.yRadius);
        compoundTag.m_128350_("zRadius", this.zRadius);
    }

    public void m_214092_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, RandomSource randomSource) {
        this.xRadius = randomSource.m_188501_() * 1.0f + 2.0f;
        this.yRadius = randomSource.m_188501_() * 1.0f + 2.0f;
        this.zRadius = randomSource.m_188501_() * 1.0f + 2.0f;
        ((BoundingBoxAccessor)this.f_73383_).setMinX(this.startPos.m_123341_() - (int)this.xRadius - 4);
        ((BoundingBoxAccessor)this.f_73383_).setMaxX(this.startPos.m_123341_() + (int)this.xRadius + 4);
        ((BoundingBoxAccessor)this.f_73383_).setMinY(this.startPos.m_123342_() - (int)this.yRadius - 4);
        ((BoundingBoxAccessor)this.f_73383_).setMaxY(this.startPos.m_123342_() + (int)this.yRadius + 4);
        ((BoundingBoxAccessor)this.f_73383_).setMinZ(this.startPos.m_123343_() - (int)this.zRadius - 4);
        ((BoundingBoxAccessor)this.f_73383_).setMaxZ(this.startPos.m_123343_() + (int)this.zRadius + 4);
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        WorldgenRandom decoRand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        decoRand.m_190068_(world.m_7328_(), this.startPos.m_123341_(), this.startPos.m_123343_());
        int xBits = 4;
        int zBits = 4;
        int yBits = Mth.m_14163_((int)(world.m_151558_() - world.m_141937_()));
        BitSet carvingMask = new BitSet((int)Math.pow(2.0, xBits + zBits + yBits));
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.m_122178_(chunkPos.m_45604_() + x, 1, chunkPos.m_45605_() + z);
                surface[x * 16 + z] = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, mutable.m_123341_(), mutable.m_123343_());
            }
        }
        float caveStartX = this.startPos.m_123341_();
        float caveStartY = this.startPos.m_123342_();
        float caveStartZ = this.startPos.m_123343_();
        int minX = Mth.m_14143_((float)(caveStartX - this.xRadius)) - chunkPos.f_45578_ * 16 - 1;
        int maxX = Mth.m_14143_((float)(caveStartX + this.xRadius)) - chunkPos.f_45578_ * 16 + 1;
        int minY = Mth.m_14045_((int)(Mth.m_14143_((float)(caveStartY - this.yRadius)) - 1), (int)world.m_141937_(), (int)world.m_151558_());
        int maxY = Mth.m_14045_((int)(Mth.m_14143_((float)(caveStartY + this.yRadius)) + 1), (int)world.m_141937_(), (int)world.m_151558_());
        int minZ = Mth.m_14143_((float)(caveStartZ - this.zRadius)) - chunkPos.f_45579_ * 16 - 1;
        int maxZ = Mth.m_14143_((float)(caveStartZ + this.zRadius)) - chunkPos.f_45579_ * 16 + 1;
        minX = Mth.m_14045_((int)minX, (int)0, (int)15);
        maxX = Mth.m_14045_((int)maxX, (int)0, (int)15);
        minZ = Mth.m_14045_((int)minZ, (int)0, (int)15);
        maxZ = Mth.m_14045_((int)maxZ, (int)0, (int)15);
        for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
            int globalX = (int)x + chunkPos.f_45578_ * 16;
            if (globalX < chunkPos.m_45604_() || globalX > chunkPos.m_45608_()) continue;
            float radialXDist = ((float)globalX - caveStartX + 0.5f) / this.xRadius;
            for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                int globalY;
                int globalZ = (int)z + chunkPos.f_45579_ * 16;
                if (globalZ < chunkPos.m_45605_() || globalZ > chunkPos.m_45609_()) continue;
                float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / this.zRadius;
                for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                    BlockState state;
                    float radialYDist = (y - caveStartY - 0.5f) / this.yRadius;
                    int mask = (int)x | (int)z << 4 | (int)(y - (float)world.m_141937_()) << 8;
                    float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                    if ((double)radialDist < 1.0) {
                        if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains(this.m_73398_((BlockGetter)world, globalX, globalY, globalZ, box).m_60734_())) continue;
                        this.m_73434_(world, Blocks.f_50627_.m_49966_(), globalX, globalY, globalZ, box);
                        carvingMask.set(mask);
                        continue;
                    }
                    float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (this.xRadius + 1.2f);
                    float radialYDistShell = (y - caveStartY - 0.5f) / (this.yRadius + 1.2f);
                    float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (this.zRadius + 1.2f);
                    float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                    if (!((double)radialDistShell < 1.0) || carvingMask.get(mask) || BLOCK_BLACKLIST.contains((state = this.m_73398_((BlockGetter)world, globalX, globalY, globalZ, box)).m_60734_()) || !state.m_60795_() || !state.m_60795_() && state.m_60819_().m_76152_() == Fluids.f_76191_ && !(decoRand.m_188501_() < 0.8f)) continue;
                    this.m_73434_(world, Blocks.f_50652_.m_49966_(), globalX, globalY, globalZ, box);
                }
            }
        }
        BlockPos chestPos = new BlockPos((int)caveStartX, (int)caveStartY - (int)this.yRadius + 1, (int)caveStartZ);
        this.placeSphereRandomized(world, box, chestPos, 2.0f, (RandomSource)decoRand, 0.5f, WOOL_SELECTOR, false);
        this.m_73434_(world, Blocks.f_50041_.m_49966_(), chestPos.m_123341_() + 1, chestPos.m_123342_(), chestPos.m_123343_(), box);
        this.m_73434_(world, Blocks.f_50041_.m_49966_(), chestPos.m_123341_() - 1, chestPos.m_123342_(), chestPos.m_123343_(), box);
        this.m_73434_(world, Blocks.f_50041_.m_49966_(), chestPos.m_123341_(), chestPos.m_123342_(), chestPos.m_123343_() + 1, box);
        this.m_73434_(world, Blocks.f_50041_.m_49966_(), chestPos.m_123341_(), chestPos.m_123342_(), chestPos.m_123343_() - 1, box);
        this.m_73434_(world, Blocks.f_50041_.m_49966_(), chestPos.m_123341_(), chestPos.m_123342_() - 1, chestPos.m_123343_(), box);
        this.m_73434_(world, Blocks.f_50041_.m_49966_(), chestPos.m_123341_(), chestPos.m_123342_() + 1, chestPos.m_123343_(), box);
        this.placeSphereRandomized(world, box, chestPos.m_123341_(), chestPos.m_123342_(), chestPos.m_123343_(), 2.0f, (RandomSource)decoRand, 0.4f, COBWEB_SELECTOR, true);
        if (randomSource.m_188501_() < 0.6f) {
            this.m_213787_(world, box, randomSource, chestPos.m_123341_(), chestPos.m_123342_(), chestPos.m_123343_(), new ResourceLocation("betterdungeons", "spider_dungeon/chests/egg_room"));
        } else if (box.m_71051_((Vec3i)chestPos)) {
            this.m_73434_(world, Blocks.f_50085_.m_49966_(), chestPos.m_123341_(), chestPos.m_123342_(), chestPos.m_123343_(), box);
            BlockEntity spawnerBlockEntity = world.m_7702_(chestPos);
            if (spawnerBlockEntity instanceof SpawnerBlockEntity) {
                ((SpawnerBlockEntity)spawnerBlockEntity).m_252803_(EntityType.f_20479_, randomSource);
            } else {
                BetterDungeonsCommon.LOGGER.warn("Expected spider spawner entity at {}, but found none!", (Object)chestPos);
            }
        }
        this.decorateCave(world, (RandomSource)decoRand, chunkPos, box, carvingMask);
    }
}

