/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.DragonRespawnStage;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndPodiumFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndSpawnPlatformFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterSpikeFeature;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndDragonFight.class})
public abstract class EndDragonFightMixin
implements IDragonFight {
    @Shadow
    @Final
    private ServerBossEvent f_64060_;
    @Shadow
    private boolean f_64068_;
    @Shadow
    private int f_64067_;
    @Shadow
    @Final
    private ServerLevel f_64061_;
    @Shadow
    private boolean f_64071_;
    @Shadow
    @Nullable
    private List<EndCrystal> f_64075_;
    @Shadow
    private int f_64074_;
    @Shadow
    @Nullable
    private BlockPos f_64072_;
    @Shadow
    @Nullable
    private UUID f_64070_;
    @Shadow
    private int f_64064_;
    @Shadow
    private int f_64066_;
    @Shadow
    private boolean f_64069_;
    @Shadow
    private int f_64065_;
    @Shadow
    @Nullable
    private DragonRespawnAnimation f_64073_;
    @Shadow
    @Final
    private ObjectArrayList<Integer> f_64062_;
    @Unique
    private DragonRespawnStage betterendisland$dragonRespawnStage;
    @Unique
    private boolean betterendisland$firstExitPortalSpawn = true;
    @Unique
    private boolean betterendisland$hasDragonEverSpawned;
    @Unique
    private int betterendisland$numberTimesDragonKilled = 0;

    @Shadow
    public abstract void m_64101_();

    @Shadow
    public abstract void m_64100_();

    @Shadow
    protected abstract void m_64107_();

    @Shadow
    protected abstract boolean m_64106_();

    @Shadow
    protected abstract void m_64103_();

    @Shadow
    protected abstract void m_64108_();

    @Shadow
    protected abstract EnderDragon m_64110_();

    @Shadow
    @Nullable
    protected abstract BlockPattern.BlockPatternMatch m_64105_();

    @Shadow
    protected abstract void m_64091_(List<EndCrystal> var1);

    @Shadow
    protected abstract boolean m_64104_();

    @Shadow
    protected abstract void m_64109_();

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;JLnet/minecraft/world/level/dimension/end/EndDragonFight$Data;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    public void betterendisland_EndDragonFight(ServerLevel level, long seed, EndDragonFight.Data data, BlockPos origin, CallbackInfo ci) {
        if (data.f_289703_()) {
            this.betterendisland$dragonRespawnStage = DragonRespawnStage.START;
        }
        this.f_64060_.m_8321_(false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tickFight(CallbackInfo ci) {
        this.f_64060_.m_8321_(!this.f_64068_ && this.betterendisland$hasDragonEverSpawned);
        if (++this.f_64067_ >= 20) {
            this.m_64107_();
            this.f_64067_ = 0;
        }
        if (!this.f_64060_.m_8324_().isEmpty()) {
            this.f_64061_.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean isArenaLoaded = this.m_64106_();
            if (this.f_64071_ && isArenaLoaded) {
                this.betterendisland$scanForInitialState();
                this.f_64071_ = false;
            }
            if (this.betterendisland$dragonRespawnStage != null) {
                if (this.f_64075_ == null && isArenaLoaded) {
                    this.betterendisland$dragonRespawnStage = null;
                    this.m_64100_();
                }
                this.betterendisland$dragonRespawnStage.tick(this.f_64061_, (EndDragonFight)this, this.f_64075_, this.f_64074_++, this.f_64072_);
            }
            if (!this.f_64068_) {
                if ((this.f_64070_ == null || ++this.f_64064_ >= 1200) && isArenaLoaded && this.betterendisland$hasDragonEverSpawned) {
                    this.m_64103_();
                    this.f_64064_ = 0;
                }
                if (++this.f_64066_ >= 100 && isArenaLoaded) {
                    this.m_64108_();
                    this.f_64066_ = 0;
                }
            }
        } else {
            this.f_64061_.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
        ci.cancel();
    }

    @Override
    public void betterendisland$reset(boolean forcePortalPosReset) {
        List dragons = this.f_64061_.m_8857_();
        dragons.forEach(Entity::m_146870_);
        this.f_64060_.m_142711_(0.0f);
        this.f_64060_.m_8321_(false);
        if (this.f_64072_ == null || this.f_64072_.m_123342_() < 5 || forcePortalPosReset) {
            BetterEndIslandCommon.LOGGER.info("Tried to reset, but need to find the portal first.");
            if (this.f_64072_ == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently null.");
            } else if (this.f_64072_.m_123342_() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently too low: {}", (Object)this.f_64072_.m_123342_());
            } else {
                BetterEndIslandCommon.LOGGER.info("Forcing portal position reset...");
            }
            this.m_64105_();
            if (this.f_64072_ == null || this.f_64072_.m_123342_() < 5 || forcePortalPosReset) {
                if (this.f_64072_ == null) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still null. Placing manually...");
                } else if (this.f_64072_.m_123342_() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still too low: {}. Placing manually...", (Object)this.f_64072_.m_123342_());
                }
                this.f_64072_ = new BlockPos(0, this.betterendisland$getSurfacePos(0, 0), 0);
                while (this.f_64061_.m_8055_(this.f_64072_).m_60713_(Blocks.f_50752_) && this.f_64072_.m_123342_() > this.f_64061_.m_5736_()) {
                    this.f_64072_ = this.f_64072_.m_7495_();
                }
                if (this.f_64072_.m_123342_() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal was still placed too low! Force placing at y=65...");
                    this.f_64072_ = new BlockPos(this.f_64072_.m_123341_(), 65, this.f_64072_.m_123343_());
                }
            }
        }
        BlockPos portalPos = this.f_64072_;
        this.f_64070_ = null;
        this.f_64068_ = false;
        this.f_64069_ = false;
        this.betterendisland$firstExitPortalSpawn = false;
        this.betterendisland$hasDragonEverSpawned = false;
        this.betterendisland$numberTimesDragonKilled = 0;
        this.betterendisland$dragonRespawnStage = null;
        this.f_64073_ = null;
        this.f_64074_ = 0;
        this.f_64071_ = true;
        this.f_64067_ = 0;
        this.f_64064_ = 0;
        this.f_64065_ = 0;
        this.f_64066_ = 0;
        if (this.f_64075_ != null) {
            this.f_64075_.forEach(Entity::m_146870_);
        }
        this.f_64075_ = null;
        List<EndCrystal> remainingSummoningCrystals = this.betterendisland$checkRespawnCrystals(portalPos.m_6630_(1));
        remainingSummoningCrystals.forEach(Entity::m_146870_);
        remainingSummoningCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.m_6625_(2));
        remainingSummoningCrystals.forEach(Entity::m_146870_);
        List allSpikes = SpikeFeature.m_66858_((WorldGenLevel)this.f_64061_);
        for (SpikeFeature.EndSpike spike2 : allSpikes) {
            for (EndCrystal crystal : this.f_64061_.m_45976_(EndCrystal.class, spike2.m_66905_())) {
                crystal.m_146870_();
            }
        }
        BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(true, false, false);
        BlockPos spawnPos = portalPos.m_6625_(5);
        endPodiumFeature.m_225028_((FeatureConfiguration)FeatureConfiguration.f_67737_, (WorldGenLevel)this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), spawnPos);
        this.betterendisland$clearVanillaPillars();
        allSpikes.forEach(spike -> {
            int resetRadius = 11;
            int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)new BlockPos(spike.m_66886_() - resetRadius, spike.m_66899_() - verticalRadius, spike.m_66893_() - resetRadius), (BlockPos)new BlockPos(spike.m_66886_() + resetRadius, spike.m_66899_() + verticalRadius, spike.m_66893_() + resetRadius))) {
                if (this.f_64061_.m_8055_(blockPos).m_60713_(Blocks.f_50259_)) continue;
                this.f_64061_.m_7471_(blockPos, false);
            }
            SpikeConfiguration spikeConfig = new SpikeConfiguration(true, (List)ImmutableList.of((Object)spike), null);
            BetterSpikeFeature.placeSpike((ServerLevelAccessor)this.f_64061_, RandomSource.m_216327_(), spikeConfig, spike, true);
        });
        BlockPos platformPos = ServerLevel.f_8562_.m_7495_();
        BetterEndSpawnPlatformFeature.place(this.f_64061_, platformPos);
        for (int i = 0; i < 20; ++i) {
            int x = Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int z = Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            BlockPos gatePos = new BlockPos(x, 75, z);
            BlockPos.m_121940_((BlockPos)gatePos.m_7918_(-1, -4, -1), (BlockPos)gatePos.m_7918_(1, 4, 1)).forEach(pos -> this.f_64061_.m_46597_(pos, Blocks.f_50016_.m_49966_()));
        }
        this.f_64062_.clear();
        this.f_64062_.addAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
        Util.m_214673_(this.f_64062_, (RandomSource)RandomSource.m_216335_((long)this.f_64061_.m_7328_()));
    }

    @Override
    public void betterendisland$clearVanillaPillars() {
        int obsidianRemoved = 0;
        RandomSource randomSource = RandomSource.m_216335_((long)this.f_64061_.m_7328_());
        long seed = randomSource.m_188505_() & 0xFFFFL;
        IntArrayList indexes = Util.m_214658_((IntStream)IntStream.range(0, 10), (RandomSource)RandomSource.m_216335_((long)seed));
        for (int i = 0; i < 10; ++i) {
            int x = Mth.m_14107_((double)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int z = Mth.m_14107_((double)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int index = indexes.get(i);
            int radius = 2 + index / 3;
            int height = 76 + index * 3;
            boolean isGuarded = index == 1 || index == 2;
            AABB topBoundingBox = new AABB((double)(x - radius), (double)DimensionType.f_156653_, (double)(z - radius), (double)(x + radius), (double)DimensionType.f_156652_, (double)(z + radius));
            this.f_64061_.m_45976_(EndCrystal.class, topBoundingBox).forEach(Entity::m_146870_);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(x - radius, this.f_64061_.m_141937_(), z - radius), (BlockPos)new BlockPos(x + radius, height + 20, z + radius))) {
                BlockState blockState;
                if (!(pos.m_203202_((double)x, (double)pos.m_123342_(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = this.f_64061_.m_8055_(pos)).m_60713_(Blocks.f_50080_) && !blockState.m_60713_(Blocks.f_50752_)) continue;
                this.f_64061_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                if (!blockState.m_60713_(Blocks.f_50080_)) continue;
                ++obsidianRemoved;
            }
            if (obsidianRemoved > 10) {
                int offset = radius + 1;
                int topY = -1;
                int surfaceY = this.betterendisland$getSurfacePos(x - offset, z - offset);
                if (surfaceY > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x - offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x + offset, z - offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x + offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                int bottomY = 255;
                surfaceY = this.betterendisland$getLowestBlockPos(x - offset, z - offset);
                if (surfaceY < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x - offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x + offset, z - offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x + offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if (topY != -1 && bottomY != 255) {
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(x - radius, bottomY, z - radius), (BlockPos)new BlockPos(x + radius, topY, z + radius))) {
                        BlockState blockState;
                        if (!(pos.m_203202_((double)x, (double)pos.m_123342_(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = this.f_64061_.m_8055_(pos)).m_60713_(Blocks.f_50016_) || pos.m_123342_() > topY || pos.m_123342_() < bottomY) continue;
                        this.f_64061_.m_46597_(pos, Blocks.f_50259_.m_49966_());
                    }
                }
            }
            if (!isGuarded) continue;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int fenceX = -2; fenceX <= 2; ++fenceX) {
                for (int fenceZ = -2; fenceZ <= 2; ++fenceZ) {
                    for (int fenceY = 0; fenceY <= 3; ++fenceY) {
                        if (Mth.m_14040_((int)fenceX) != 2 && Mth.m_14040_((int)fenceZ) != 2 && fenceY != 3) continue;
                        mutable.m_122178_(x + fenceX, height + fenceY, z + fenceZ);
                        this.f_64061_.m_46597_((BlockPos)mutable, Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    @Unique
    private int betterendisland$getLowestBlockPos(int x, int z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = this.f_64061_.m_141937_(); y < this.f_64061_.m_151558_(); ++y) {
            mutable.m_122178_(x, y, z);
            if (!this.f_64061_.m_8055_((BlockPos)mutable).m_60713_(Blocks.f_50259_)) continue;
            return y;
        }
        return 255;
    }

    @Unique
    private int betterendisland$getSurfacePos(int x, int z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = this.f_64061_.m_151558_(); y > this.f_64061_.m_141937_(); --y) {
            mutable.m_122178_(x, y, z);
            if (!this.f_64061_.m_8055_((BlockPos)mutable).m_60713_(Blocks.f_50259_)) continue;
            return y;
        }
        return -1;
    }

    @Unique
    private void betterendisland$scanForInitialState() {
        BetterEndIslandCommon.LOGGER.info("Scanning for legacy world dragon fight...");
        boolean hasActiveExitPortal = this.m_64104_();
        if (hasActiveExitPortal) {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has been killed in this world already.");
            this.f_64069_ = true;
        } else {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.f_64069_ = false;
            if (this.m_64105_() == null) {
                this.betterendisland$spawnPortal(false, false);
            }
        }
        List dragons = this.f_64061_.m_8857_();
        if (dragons.isEmpty()) {
            this.f_64068_ = true;
        } else {
            EnderDragon dragon = (EnderDragon)dragons.get(0);
            this.f_64070_ = dragon.m_20148_();
            BetterEndIslandCommon.LOGGER.info("Found that there's a dragon still alive ({})", (Object)dragon);
            this.f_64068_ = false;
            if (!hasActiveExitPortal) {
                BetterEndIslandCommon.LOGGER.info("But we didn't have a portal, so let's remove the dragon.");
                dragon.m_146870_();
                this.f_64070_ = null;
            }
        }
        if (!this.f_64069_ && this.f_64068_) {
            this.f_64068_ = false;
        }
    }

    @Inject(method={"onCrystalDestroyed"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_onCrystalDestroyed(EndCrystal crystal, DamageSource damageSource, CallbackInfo ci) {
        if (this.betterendisland$dragonRespawnStage != null && this.f_64075_.contains(crystal)) {
            BetterEndIslandCommon.LOGGER.info("Aborting dragon respawn sequence");
            this.betterendisland$dragonRespawnStage = null;
            this.f_64074_ = 0;
            this.m_64101_();
        } else {
            this.m_64108_();
            Entity dragonEntity = this.f_64061_.m_8791_(this.f_64070_);
            if (dragonEntity instanceof EnderDragon) {
                ((EnderDragon)dragonEntity).m_31124_(crystal, crystal.m_20183_(), damageSource);
            }
        }
        ci.cancel();
    }

    @Inject(method={"tryRespawn"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tryRespawn(CallbackInfo ci) {
        if (this.f_64068_ && this.betterendisland$dragonRespawnStage == null) {
            List<EndCrystal> allCrystals;
            BlockPos portalPos = this.f_64072_;
            if (portalPos == null) {
                BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
                BlockPattern.BlockPatternMatch portalPatternMatch = this.m_64105_();
                if (portalPatternMatch == null) {
                    BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                    this.betterendisland$spawnPortal(false, false);
                    this.betterendisland$spawnPortal(true, true);
                } else {
                    BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
                }
                portalPos = this.f_64072_;
            }
            if ((allCrystals = this.betterendisland$checkRespawnCrystals(portalPos.m_6630_(1))).size() != 4 && (allCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.m_6625_(2))).size() != 4) {
                return;
            }
            BetterEndIslandCommon.LOGGER.info("Found all crystals, respawning dragon.");
            this.m_64091_(allCrystals);
        }
        ci.cancel();
    }

    @Override
    @Unique
    public void betterendisland$initialRespawn() {
        List<EndCrystal> allCrystals;
        BetterEndIslandCommon.LOGGER.info("Starting initial dragon fight!");
        BlockPos portalPos = this.f_64072_;
        if (portalPos == null) {
            BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
            BlockPattern.BlockPatternMatch portalPatternMatch = this.m_64105_();
            if (portalPatternMatch == null) {
                BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                this.betterendisland$spawnPortal(false, false);
                this.betterendisland$spawnPortal(true, true);
            } else {
                BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
            }
            portalPos = this.f_64072_;
        }
        if ((allCrystals = this.betterendisland$checkRespawnCrystals(portalPos.m_6630_(1))).size() != 4 && (allCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.m_6625_(2))).size() != 4) {
            BetterEndIslandCommon.LOGGER.info("Unable to find all 4 summoning crystals. This shouldn't happen!");
            return;
        }
        BetterEndIslandCommon.LOGGER.info("Found all crystals, starting initial dragon spawn.");
        this.m_64091_(allCrystals);
    }

    @Unique
    private List<EndCrystal> betterendisland$checkRespawnCrystals(BlockPos centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            AABB crystalCheckbox = new AABB(centerPos.m_5484_(direction, 7));
            List crystalsInDirection = this.f_64061_.m_45976_(EndCrystal.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    @Unique
    private List<EndCrystal> betterendisland$checkVanillaRespawnCrystals(BlockPos centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            AABB crystalCheckbox = new AABB(centerPos.m_5484_(direction, 2));
            List crystalsInDirection = this.f_64061_.m_45976_(EndCrystal.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    @Inject(method={"respawnDragon"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterendisland_respawnDragon(List<EndCrystal> crystals, CallbackInfo ci) {
        if ((this.f_64068_ || !this.betterendisland$hasDragonEverSpawned) && this.betterendisland$dragonRespawnStage == null) {
            this.betterendisland$dragonRespawnStage = DragonRespawnStage.START;
            this.f_64074_ = 0;
            this.f_64075_ = crystals;
        }
        ci.cancel();
    }

    @Unique
    private void betterendisland$spawnPortal(boolean isActive, boolean isBottomOnly) {
        if (this.f_64072_ == null || this.f_64072_.m_123342_() < 5) {
            if (this.f_64072_ == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is null. Placing manually...");
            } else {
                BetterEndIslandCommon.LOGGER.info("Portal location is too low: {}. Placing manually...", (Object)this.f_64072_.m_123342_());
            }
            this.f_64072_ = new BlockPos(0, this.betterendisland$getSurfacePos(0, 0), 0);
            while (this.f_64061_.m_8055_(this.f_64072_).m_60713_(Blocks.f_50752_) && this.f_64072_.m_123342_() > this.f_64061_.m_5736_()) {
                this.f_64072_ = this.f_64072_.m_7495_();
            }
            if (this.f_64072_.m_123342_() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal was placed too low! Force placing at y=65...");
                this.f_64072_ = new BlockPos(this.f_64072_.m_123341_(), 65, this.f_64072_.m_123343_());
            }
        }
        BetterEndIslandCommon.LOGGER.info("Set the exit portal location to: {}", (Object)this.f_64072_);
        BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(this.betterendisland$firstExitPortalSpawn, isBottomOnly, isActive);
        BlockPos spawnPos = this.f_64072_.m_6625_(5);
        endPodiumFeature.m_225028_((FeatureConfiguration)FeatureConfiguration.f_67737_, (WorldGenLevel)this.f_64061_, this.f_64061_.m_7726_().m_8481_(), RandomSource.m_216327_(), spawnPos);
        this.betterendisland$firstExitPortalSpawn = false;
    }

    @Inject(method={"resetSpikeCrystals"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_resetSpikeCrystals(CallbackInfo ci) {
        for (SpikeFeature.EndSpike $$0 : SpikeFeature.m_66858_((WorldGenLevel)this.f_64061_)) {
            for (EndCrystal $$2 : this.f_64061_.m_45976_(EndCrystal.class, $$0.m_66905_())) {
                $$2.m_20331_(false);
                $$2.m_31052_(null);
            }
        }
        if (this.f_64075_ != null) {
            for (EndCrystal crystal : this.f_64075_) {
                crystal.m_20331_(false);
                crystal.m_31052_(null);
            }
        }
        ci.cancel();
    }

    @Inject(method={"setDragonKilled"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_setDragonKilled(EnderDragon dragon, CallbackInfo ci) {
        if (dragon.m_20148_().equals(this.f_64070_)) {
            this.f_64060_.m_142711_(0.0f);
            this.f_64060_.m_8321_(false);
            this.betterendisland$spawnPortal(true, true);
            this.f_64061_.m_254849_(null, (double)this.f_64072_.m_123341_(), (double)this.f_64072_.m_123342_(), (double)this.f_64072_.m_123343_(), 6.0f, Level.ExplosionInteraction.NONE);
            this.m_64109_();
            if (!this.f_64069_) {
                this.f_64061_.m_46597_(this.f_64072_.m_7494_(), Blocks.f_50260_.m_49966_());
            }
            int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
            List spikes = SpikeFeature.m_66858_((WorldGenLevel)this.f_64061_);
            spikes.forEach(spike -> {
                int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset();
                this.f_64061_.m_7731_(new BlockPos(spike.m_66886_(), crystalY - 1, spike.m_66893_()), Blocks.f_50080_.m_49966_(), 3);
            });
            this.f_64069_ = true;
            this.f_64068_ = true;
            ++this.betterendisland$numberTimesDragonKilled;
        }
        ci.cancel();
    }

    @Override
    public void betterendisland$setDragonRespawnStage(DragonRespawnStage stage) {
        if (this.betterendisland$dragonRespawnStage == null) {
            throw new IllegalStateException("Better Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.f_64074_ = 0;
        if (stage == DragonRespawnStage.END) {
            this.betterendisland$dragonRespawnStage = null;
            this.f_64068_ = false;
            EnderDragon newDragon = this.m_64110_();
            if (this.f_64069_) {
                for (ServerPlayer serverPlayer : this.f_64060_.m_8324_()) {
                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)newDragon);
                }
            }
            this.betterendisland$spawnPortal(false, false);
            this.f_64061_.m_254849_(null, (double)this.f_64072_.m_123341_(), (double)(this.f_64072_.m_123342_() + 20), (double)this.f_64072_.m_123343_(), 6.0f, Level.ExplosionInteraction.NONE);
            this.f_64061_.m_6907_().forEach(player -> {
                this.f_64061_.m_8624_(player, (ParticleOptions)ParticleTypes.f_123812_, true, (double)this.f_64072_.m_123341_(), (double)(this.f_64072_.m_123342_() + 20), (double)this.f_64072_.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
                if (player.m_20275_((double)this.f_64072_.m_123341_(), (double)(this.f_64072_.m_123342_() + 20), (double)this.f_64072_.m_123343_()) > 32.0) {
                    this.f_64061_.m_5594_(null, this.f_64072_.m_6630_(20), SoundEvents.f_11913_, SoundSource.NEUTRAL, 24.0f, 1.0f);
                }
            });
            if (this.betterendisland$hasDragonEverSpawned) {
                this.betterendisland$spawnPortal(false, true);
                this.f_64061_.m_254849_(null, (double)this.f_64072_.m_123341_(), (double)this.f_64072_.m_123342_(), (double)this.f_64072_.m_123343_(), 6.0f, Level.ExplosionInteraction.NONE);
            }
            int dragonKills = Mth.m_14045_((int)this.betterendisland$numberTimesDragonKilled, (int)0, (int)10);
            float cryingChance = Mth.m_14179_((float)((float)dragonKills / 10.0f), (float)0.0f, (float)0.5f);
            ArrayList existingGateways = new ArrayList(ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            existingGateways.removeAll((Collection<?>)this.f_64062_);
            existingGateways.forEach(gateway -> {
                int x = Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                int z = Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                BlockPos gatewayPos = new BlockPos(x, 75, z);
                RandomSource gatewayRandom = RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)gatewayPos));
                BlockPos.m_121940_((BlockPos)gatewayPos.m_7918_(-1, -4, -1), (BlockPos)gatewayPos.m_7918_(1, 4, 1)).forEach(pos -> {
                    if (this.f_64061_.m_8055_(pos).m_60713_(Blocks.f_50080_) && gatewayRandom.m_188501_() < cryingChance) {
                        this.f_64061_.m_46597_(pos, Blocks.f_50723_.m_49966_());
                    }
                });
            });
            BlockPos platformPos = ServerLevel.f_8562_;
            RandomSource platformRandom = RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)platformPos));
            BlockPos.m_121940_((BlockPos)platformPos.m_7918_(-3, -15, -3), (BlockPos)platformPos.m_7918_(3, 4, 3)).forEach(pos -> {
                if (this.f_64061_.m_8055_(pos).m_60713_(Blocks.f_50080_) && platformRandom.m_188501_() < cryingChance) {
                    this.f_64061_.m_46597_(pos, Blocks.f_50723_.m_49966_());
                }
            });
            this.betterendisland$hasDragonEverSpawned = true;
        } else {
            this.betterendisland$dragonRespawnStage = stage;
        }
    }

    @Override
    public void betterendisland$tickBellSound() {
        if (!this.betterendisland$hasDragonEverSpawned || this.betterendisland$dragonRespawnStage != null) {
            int soundY;
            long gameTime = this.f_64061_.m_46467_();
            int n = soundY = this.f_64072_ == null ? 80 : this.f_64072_.m_123342_() + 15;
            if (gameTime % 100L == 0L) {
                this.f_64061_.m_5594_(null, new BlockPos(0, soundY, 0), SoundEvents.f_11699_, SoundSource.NEUTRAL, 24.0f, 0.5f);
                this.f_64061_.m_5594_(null, new BlockPos(0, soundY, 0), SoundEvents.f_11700_, SoundSource.NEUTRAL, 4.0f, 0.9f);
            }
            if (gameTime % 300L == 0L) {
                this.f_64061_.m_5594_(null, new BlockPos(0, 80, 0), SoundEvents.f_11700_, SoundSource.NEUTRAL, 24.0f, 0.8f);
            }
        }
    }

    @Override
    public DragonRespawnStage betterendisland$getDragonRespawnStage() {
        return this.betterendisland$dragonRespawnStage;
    }

    @Override
    public boolean betterendisland$firstExitPortalSpawn() {
        return this.betterendisland$firstExitPortalSpawn;
    }

    @Override
    public boolean betterendisland$hasDragonEverSpawned() {
        return this.betterendisland$hasDragonEverSpawned;
    }

    @Override
    public int betterendisland$numTimesDragonKilled() {
        return this.betterendisland$numberTimesDragonKilled;
    }

    @Override
    public void betterendisland$setFirstExitPortalSpawn(boolean bl) {
        this.betterendisland$firstExitPortalSpawn = bl;
    }

    @Override
    public void betterendisland$setHasDragonEverSpawned(boolean bl) {
        this.betterendisland$hasDragonEverSpawned = bl;
    }

    @Override
    public void betterendisland$setNumTimesDragonKilled(int i) {
        this.betterendisland$numberTimesDragonKilled = i;
    }
}

