/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.NonNullConsumer;

public enum GuiSprite implements ISprite
{
    RADIOBUTTON_NORMAL(0, 0),
    RADIOBUTTON_ACTIVE(16, 0),
    RADIOBUTTON_NORMAL_HIGHLIGHTED(32, 0),
    RADIOBUTTON_ACTIVE_HIGHLIGHTED(48, 0),
    RADIOBUTTON_NORMAL_DISABLED(64, 0),
    RADIOBUTTON_ACTIVE_DISABLED(80, 0),
    CHECKBOX_NORMAL(0, 16),
    CHECKBOX_ACTIVE(16, 16),
    CHECKBOX_NORMAL_HIGHLIGHTED(32, 16),
    CHECKBOX_ACTIVE_HIGHLIGHTED(48, 16),
    CHECKBOX_NORMAL_DISABLED(64, 16),
    CHECKBOX_ACTIVE_DISABLED(80, 16);

    private final int _width;
    private final int _height;
    private final int _u;
    private final int _v;
    private final float _minU;
    private final float _maxU;
    private final float _minV;
    private final float _maxV;
    private final ISprite _overlay;
    private static final ISpriteTextureMap TEXTURE_MAP;

    private GuiSprite(int u, int v) {
        this(16, 16, u, v, null);
    }

    private GuiSprite(int width, int height, int u, int v) {
        this(width, height, u, v, null);
    }

    private GuiSprite(int width, int height, @Nullable int u, int v, ISprite overlay) {
        this._width = width;
        this._height = height;
        this._u = u;
        this._v = v;
        this._overlay = overlay;
        float textureMapWidth = this.getTextureMap().getWidth();
        float textureMapHeight = this.getTextureMap().getHeight();
        this._minU = (float)this._u / textureMapWidth;
        this._maxU = (float)(this._u + this._width) / textureMapWidth;
        this._minV = (float)this._v / textureMapHeight;
        this._maxV = (float)(this._v + this._height) / textureMapHeight;
    }

    @Override
    public int getU() {
        return this._u;
    }

    @Override
    public int getV() {
        return this._v;
    }

    @Override
    public float getMinU() {
        return this._minU;
    }

    @Override
    public float getMaxU() {
        return this._maxU;
    }

    @Override
    public float getMinV() {
        return this._minV;
    }

    @Override
    public float getMaxV() {
        return this._maxV;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public ISpriteTextureMap getTextureMap() {
        return TEXTURE_MAP;
    }

    @Override
    public Optional<ISprite> getSpriteOverlay() {
        return Optional.ofNullable(this._overlay);
    }

    @Override
    public void applyOverlay(NonNullConsumer<ISprite> overlayConsumer) {
        if (null != this._overlay) {
            overlayConsumer.accept((Object)this._overlay);
        }
    }

    @Override
    public ISprite copy() {
        return this;
    }

    @Override
    public ISprite copyWith(ISprite overlay) {
        return this;
    }

    static {
        TEXTURE_MAP = new SpriteTextureMap(Lib.GUI_TEXTURES_LOCATION.buildWithSuffix("gui_sprites.png"), 128, 128);
    }
}

