/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class ParentModel
implements Supplier<JsonElement> {
    private final ResourceLocation _id;
    private final Set<String> _textures;

    public static ParentModel of(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id, (Object)"ID must not be null");
        return new ParentModel(id, (Set<String>)ImmutableSet.of());
    }

    public static ParentModel of(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"ID must not be null or empty");
        return ParentModel.of(new ResourceLocation(id));
    }

    public static ParentModel of(ResourceLocation id, String ... textures) {
        Preconditions.checkNotNull((Object)id, (Object)"ID must not be null");
        Preconditions.checkArgument((textures.length > 0 ? 1 : 0) != 0, (Object)"At least one texture variable must be specified");
        return new ParentModel(id, (Set<String>)ImmutableSet.copyOf((Object[])textures));
    }

    public static ParentModel of(String id, String ... textures) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"ID must not be null or empty");
        return ParentModel.of(new ResourceLocation(id), textures);
    }

    public static ParentModel of(ResourceLocation id, TextureSlot ... textures) {
        Preconditions.checkNotNull((Object)id, (Object)"ID must not be null");
        Preconditions.checkArgument((textures.length > 0 ? 1 : 0) != 0, (Object)"At least one texture variable must be specified");
        Set<String> set = Arrays.stream(textures).map(TextureSlot::m_125897_).collect(Collectors.toUnmodifiableSet());
        return new ParentModel(id, set);
    }

    public static ParentModel of(String id, TextureSlot ... textures) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"ID must not be null or empty");
        return ParentModel.of(new ResourceLocation(id), textures);
    }

    public Set<String> textures() {
        return this._textures;
    }

    @Override
    @ApiStatus.Internal
    public JsonElement get() {
        return (JsonElement)Util.m_137469_((Object)new JsonObject(), $ -> $.addProperty("parent", this._id.toString()));
    }

    public String toString() {
        return this._id.toString();
    }

    private ParentModel(ResourceLocation id, Set<String> textures) {
        Preconditions.checkNotNull((Object)id);
        if (textures.stream().anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("All textures must not be empty");
        }
        this._id = id;
        this._textures = textures;
    }
}

