/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.zerono.mods.zerocore.lib.datagen.provider.client.model.ModelBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.client.state.ModelVariantsList;
import it.zerono.mods.zerocore.lib.functional.NonNullBiConsumer;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.Util;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.NonNullConsumer;

public class MultiVariantBuilder
implements BlockStateGenerator {
    private final ModelBuilder _modelBuilder;
    private final Block _block;
    private final SortedSet<Property<?>> _properties;
    private final Map<BlockState, ModelVariantsList> _selectors;

    MultiVariantBuilder(ModelBuilder modelBuilder, Block block) {
        Preconditions.checkNotNull((Object)modelBuilder, (Object)"Model builder must not be null");
        Preconditions.checkNotNull((Object)block, (Object)"Block must not be null");
        this._modelBuilder = modelBuilder;
        this._block = block;
        this._properties = new TreeSet<Property>(Comparator.comparing(Property::m_61708_));
        this._properties.addAll(block.m_49965_().m_61092_());
        this._selectors = new Object2ObjectArrayMap(64);
    }

    MultiVariantBuilder(ModelBuilder modelBuilder, Block block, Set<Property<?>> ignoredProperties) {
        this(modelBuilder, block);
        Preconditions.checkNotNull(ignoredProperties, (Object)"Ignored properties must not be null");
        this._properties.removeAll(ignoredProperties);
    }

    public MultiVariantBuilder selector(NonNullConsumer<SelectorBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        SelectorBuilder selectorBuilder = new SelectorBuilder(this._block.m_49966_(), this._properties, this._modelBuilder);
        builder.accept((Object)selectorBuilder);
        selectorBuilder.build(this::addSelector);
        return this;
    }

    public <T extends Comparable<T>, V extends T> MultiVariantBuilder selector(Property<T> property, V value, Variant ... variants) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        Preconditions.checkArgument((variants.length > 0 ? 1 : 0) != 0, (Object)"At least one variant must be provided");
        return this.selector((NonNullConsumer<SelectorBuilder>)((NonNullConsumer)selector -> selector.state(property, value).variant(variants)));
    }

    public <T extends Comparable<T>, V extends T> MultiVariantBuilder selector(Property<T> property, V value, NonNullConsumer<ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        Preconditions.checkNotNull(builder, (Object)"The variant builder must not be null");
        return this.selector((NonNullConsumer<SelectorBuilder>)((NonNullConsumer)selector -> selector.state(property, value).variant(builder)));
    }

    public void all(NonNullBiConsumer<BlockState, ModelVariantBuilder> builder) {
        Preconditions.checkNotNull(builder, (Object)"Builder must not be null");
        ImmutableList possibleStates = this._block.m_49965_().m_61056_();
        ObjectArraySet states = new ObjectArraySet(possibleStates.size());
        for (BlockState state : possibleStates) {
            if (!states.stream().noneMatch(seenState -> this.matchValidProperties((BlockState)seenState, state))) continue;
            states.add((Object)state);
        }
        for (BlockState state : states) {
            ModelVariantsList variants = new ModelVariantsList(8);
            ModelVariantBuilder.build(variants, this._modelBuilder, (NonNullConsumer<ModelVariantBuilder>)((NonNullConsumer)vb -> builder.accept(state, (ModelVariantBuilder)vb)));
            this._selectors.put(state, variants);
        }
    }

    public Block m_6968_() {
        return this._block;
    }

    public JsonElement get() {
        Set<BlockState> defined = this._selectors.keySet();
        LinkedList<BlockState> missing = new LinkedList<BlockState>((Collection<BlockState>)this._block.m_49965_().m_61056_());
        missing.removeAll(defined);
        if (!missing.isEmpty()) {
            for (BlockState definedState : defined) {
                missing.removeIf(missingState -> this.matchValidProperties((BlockState)missingState, definedState));
                if (!missing.isEmpty()) continue;
                break;
            }
        }
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"The following block states for block %s were not defined: %s", (Object)this._block, missing);
        JsonObject variants = new JsonObject();
        for (Map.Entry<BlockState, ModelVariantsList> entry : this._selectors.entrySet()) {
            String name = this.getSelectorsString(entry.getKey());
            entry.getValue().apply(name, variants);
        }
        return (JsonElement)Util.m_137469_((Object)new JsonObject(), json -> json.add("variants", (JsonElement)variants));
    }

    private void addSelector(BlockState state, ModelVariantsList variants) {
        if (null != this._selectors.put(state, variants)) {
            throw new IllegalStateException("Added duplicate block state definition for " + state.m_60734_());
        }
    }

    private String getSelectorsString(BlockState state) {
        StringBuilder builder = new StringBuilder();
        for (Property property : this._properties) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(property.m_61708_()).append('=').append(property.m_6940_(state.m_61143_(property)));
        }
        return builder.toString();
    }

    private boolean matchValidProperties(BlockState state1, BlockState state2) {
        for (Property property : this._properties) {
            if (state1.m_61143_(property) == state2.m_61143_(property)) continue;
            return false;
        }
        return true;
    }

    public static class SelectorBuilder {
        private final Set<Property<?>> _validProperties;
        private final ModelVariantsList _modelVariants;
        private final ModelBuilder _modelBuilder;
        private BlockState _state;

        SelectorBuilder(BlockState defaultState, Set<Property<?>> validProperties, ModelBuilder modelBuilder) {
            this._validProperties = validProperties;
            this._modelVariants = new ModelVariantsList(4);
            this._modelBuilder = modelBuilder;
            this._state = defaultState;
        }

        public <T extends Comparable<T>, V extends T> SelectorBuilder state(Property<T> property, V value) {
            if (!this._validProperties.contains(property)) {
                throw new IllegalArgumentException(String.format("The provided property is invalid for the block or was ignored: %s", property));
            }
            this._state = (BlockState)this._state.m_61124_(property, value);
            return this;
        }

        public SelectorBuilder variant(Variant ... variants) {
            this._modelVariants.add(variants);
            return this;
        }

        public SelectorBuilder variant(NonNullConsumer<ModelVariantBuilder> builder) {
            ModelVariantBuilder.build(this._modelVariants, this._modelBuilder, builder);
            return this;
        }

        protected void build(NonNullBiConsumer<BlockState, ModelVariantsList> sink) {
            sink.accept(this._state, this._modelVariants);
        }
    }
}

