/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.client.event.load.ZAddBlockColorHandlers;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.registry.DyeablesRegistry;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.registry.ZetaRegistry;

public abstract class ClientRegistryExtension {
    protected final Zeta z;
    protected final ZetaRegistry registry;
    protected final Map<RenderLayerRegistry.Layer, RenderType> resolvedTypes = new EnumMap<RenderLayerRegistry.Layer, RenderType>(RenderLayerRegistry.Layer.class);

    public ClientRegistryExtension(Zeta z) {
        this.z = z;
        this.registry = z.registry;
        this.resolvedTypes.put(RenderLayerRegistry.Layer.SOLID, RenderType.m_110451_());
        this.resolvedTypes.put(RenderLayerRegistry.Layer.CUTOUT, RenderType.m_110463_());
        this.resolvedTypes.put(RenderLayerRegistry.Layer.CUTOUT_MIPPED, RenderType.m_110457_());
        this.resolvedTypes.put(RenderLayerRegistry.Layer.TRANSLUCENT, RenderType.m_110466_());
    }

    @LoadEvent
    public void registerItemColorHandlers(ZAddItemColorHandlers event) {
        DyeablesRegistry dyeables = this.z.dyeables;
        ClampedItemPropertyFunction isDyed = (stack, level, entity, i) -> dyeables.isDyed(stack) ? 1.0f : 0.0f;
        ItemColor color = (stack, layer) -> layer == 0 ? dyeables.getColor(stack) : 0xFFFFFF;
        ResourceLocation isDyedId = new ResourceLocation("minecraft", this.z.modid + "_dyed");
        for (Item item : dyeables.dyeableConditions.keySet()) {
            ItemProperties.register((Item)item, (ResourceLocation)isDyedId, (ItemPropertyFunction)isDyed);
            event.register(color, new ItemLike[]{item});
        }
    }

    @LoadEvent
    public void registerBlockColorsPost(ZAddBlockColorHandlers.Post event) {
        this.registry.finalizeBlockColors((block, name) -> {
            Function<Block, BlockColor> blockColorCreator = event.getNamedBlockColors().get(name);
            if (blockColorCreator == null) {
                this.z.log.error("Unknown block color creator {} used on block {}", name, block);
            } else {
                event.register(blockColorCreator.apply((Block)block), (Block)block);
            }
        });
    }

    @LoadEvent
    public void registerItemColorsPost(ZAddItemColorHandlers.Post event) {
        this.registry.finalizeItemColors((item, name) -> {
            Function<Item, ItemColor> itemColorCreator = event.getNamedItemColors().get(name);
            if (itemColorCreator == null) {
                this.z.log.error("Unknown item color creator {} used on item {}", name, item);
            } else {
                event.register(itemColorCreator.apply((Item)item), new ItemLike[]{item});
            }
        });
    }

    @LoadEvent
    public void registerRenderLayers(ZClientSetup event) {
        this.z.renderLayerRegistry.finalize(this::doSetRenderLayer);
    }

    protected abstract void doSetRenderLayer(Block var1, RenderLayerRegistry.Layer var2);
}

